/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.util;

import com.intellij.diff.DiffContext;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.tools.holders.EditorHolder;
import com.intellij.diff.util.DiffUserDataKeys;
import com.intellij.diff.util.Side;
import com.intellij.diff.util.ThreeSide;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class FocusTrackerSupport<T> {

    public static class ThreesideFocusTrackerSupport {
        @NotNull
        private ThreeSide myCurrentSide;

        public ThreesideFocusTrackerSupport(@NotNull List<? extends EditorHolder> holders) {
            if (holders == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holders", "com/intellij/diff/tools/util/FocusTrackerSupport$ThreesideFocusTrackerSupport", "<init>"));
            }
            this.myCurrentSide = ThreeSide.BASE;
            this.addListener(holders, ThreeSide.LEFT);
            this.addListener(holders, ThreeSide.BASE);
            this.addListener(holders, ThreeSide.RIGHT);
        }

        @NotNull
        public ThreeSide getCurrentSide() {
            ThreeSide threeSide = this.myCurrentSide;
            if (threeSide == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/FocusTrackerSupport$ThreesideFocusTrackerSupport", "getCurrentSide"));
            }
            return threeSide;
        }

        public void setCurrentSide(@NotNull ThreeSide side) {
            if (side == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/util/FocusTrackerSupport$ThreesideFocusTrackerSupport", "setCurrentSide"));
            }
            this.myCurrentSide = side;
        }

        public void processContextHints(@NotNull DiffRequest request, @NotNull DiffContext context) {
            if (request == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/diff/tools/util/FocusTrackerSupport$ThreesideFocusTrackerSupport", "processContextHints"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/diff/tools/util/FocusTrackerSupport$ThreesideFocusTrackerSupport", "processContextHints"));
            }
            ThreeSide side = (ThreeSide)context.getUserData(DiffUserDataKeys.PREFERRED_FOCUS_THREESIDE);
            if (side != null) {
                this.setCurrentSide(side);
            }
        }

        public void updateContextHints(@NotNull DiffRequest request, @NotNull DiffContext context) {
            if (request == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/diff/tools/util/FocusTrackerSupport$ThreesideFocusTrackerSupport", "updateContextHints"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/diff/tools/util/FocusTrackerSupport$ThreesideFocusTrackerSupport", "updateContextHints"));
            }
            context.putUserData(DiffUserDataKeys.PREFERRED_FOCUS_THREESIDE, (Object)this.myCurrentSide);
        }

        private void addListener(@NotNull List<? extends EditorHolder> holders, @NotNull ThreeSide side) {
            if (holders == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holders", "com/intellij/diff/tools/util/FocusTrackerSupport$ThreesideFocusTrackerSupport", "addListener"));
            }
            if (side == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/util/FocusTrackerSupport$ThreesideFocusTrackerSupport", "addListener"));
            }
            ((EditorHolder)side.select(holders)).installFocusListener(new MyFocusListener(side));
        }

        private class MyFocusListener
        extends FocusAdapter {
            @NotNull
            private final ThreeSide mySide;

            private MyFocusListener(ThreeSide side) {
                if (side == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/util/FocusTrackerSupport$ThreesideFocusTrackerSupport$MyFocusListener", "<init>"));
                }
                this.mySide = side;
            }

            @Override
            public void focusGained(FocusEvent e) {
                ThreesideFocusTrackerSupport.this.myCurrentSide = this.mySide;
            }
        }
    }

    public static class TwosideFocusTrackerSupport {
        @NotNull
        private Side myCurrentSide;

        public TwosideFocusTrackerSupport(@NotNull List<? extends EditorHolder> holders) {
            if (holders == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holders", "com/intellij/diff/tools/util/FocusTrackerSupport$TwosideFocusTrackerSupport", "<init>"));
            }
            assert (holders.size() == 2);
            this.myCurrentSide = Side.RIGHT;
            this.addListener(holders, Side.LEFT);
            this.addListener(holders, Side.RIGHT);
        }

        @NotNull
        public Side getCurrentSide() {
            Side side = this.myCurrentSide;
            if (side == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/FocusTrackerSupport$TwosideFocusTrackerSupport", "getCurrentSide"));
            }
            return side;
        }

        public void setCurrentSide(@NotNull Side side) {
            if (side == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/util/FocusTrackerSupport$TwosideFocusTrackerSupport", "setCurrentSide"));
            }
            this.myCurrentSide = side;
        }

        public void processContextHints(@NotNull DiffRequest request, @NotNull DiffContext context) {
            if (request == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/diff/tools/util/FocusTrackerSupport$TwosideFocusTrackerSupport", "processContextHints"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/diff/tools/util/FocusTrackerSupport$TwosideFocusTrackerSupport", "processContextHints"));
            }
            Side side = (Side)context.getUserData(DiffUserDataKeys.PREFERRED_FOCUS_SIDE);
            if (side != null) {
                this.setCurrentSide(side);
            }
        }

        public void updateContextHints(@NotNull DiffRequest request, @NotNull DiffContext context) {
            if (request == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/diff/tools/util/FocusTrackerSupport$TwosideFocusTrackerSupport", "updateContextHints"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/diff/tools/util/FocusTrackerSupport$TwosideFocusTrackerSupport", "updateContextHints"));
            }
            context.putUserData(DiffUserDataKeys.PREFERRED_FOCUS_SIDE, (Object)this.myCurrentSide);
        }

        private void addListener(@NotNull List<? extends EditorHolder> holders, @NotNull Side side) {
            if (holders == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holders", "com/intellij/diff/tools/util/FocusTrackerSupport$TwosideFocusTrackerSupport", "addListener"));
            }
            if (side == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/util/FocusTrackerSupport$TwosideFocusTrackerSupport", "addListener"));
            }
            ((EditorHolder)side.select(holders)).installFocusListener(new MyFocusListener(side));
        }

        private class MyFocusListener
        extends FocusAdapter {
            @NotNull
            private final Side mySide;

            private MyFocusListener(Side side) {
                if (side == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/util/FocusTrackerSupport$TwosideFocusTrackerSupport$MyFocusListener", "<init>"));
                }
                this.mySide = side;
            }

            @Override
            public void focusGained(FocusEvent e) {
                TwosideFocusTrackerSupport.this.myCurrentSide = this.mySide;
            }
        }
    }
}

