/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.util;

import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.UIUtil;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Shape;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.Collections;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextArea;
import javax.swing.text.BadLocationException;
import org.jetbrains.annotations.NotNull;

public class CopyableLabel
extends JTextArea {
    @NotNull
    private JLabel ELLIPSIS_LABEL;

    @NotNull
    public static JComponent create(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/diff/util/CopyableLabel", "create"));
        }
        if (text.isEmpty()) {
            text = " ";
        }
        text = text.replace('\r', ' ').replace('\n', ' ');
        if (Registry.is((String)"diff.copyable.title.label")) {
            CopyableLabel copyableLabel = new CopyableLabel(text);
            if (copyableLabel == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/CopyableLabel", "create"));
            }
            return copyableLabel;
        }
        JLabel jLabel = new JLabel(text);
        if (jLabel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/CopyableLabel", "create"));
        }
        return jLabel;
    }

    private CopyableLabel(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/diff/util/CopyableLabel", "<init>"));
        }
        this.ELLIPSIS_LABEL = new JBLabel("...");
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                int caretPosition = CopyableLabel.this.getCaretPosition();
                CopyableLabel.this.setSelectionStart(caretPosition);
                CopyableLabel.this.setSelectionEnd(caretPosition);
            }
        });
        this.setWrapStyleWord(false);
        this.setFont(UIUtil.getLabelFont());
        this.setEditable(false);
        this.setForeground(UIUtil.getLabelForeground());
        this.setBackground(UIUtil.TRANSPARENT_COLOR);
        this.setBorder(null);
        this.setOpaque(false);
        this.setText(StringUtil.stripHtml((String)text, (boolean)false));
        this.setCaretPosition(0);
        UIUtil.putClientProperty((JComponent)this, (Key)UIUtil.NOT_IN_HIERARCHY_COMPONENTS, Collections.singleton(this.ELLIPSIS_LABEL));
    }

    @Override
    public void paint(Graphics g) {
        boolean paintEllipsis;
        Dimension size = this.getSize();
        boolean bl = paintEllipsis = this.getPreferredSize().width > size.width;
        if (!paintEllipsis) {
            super.paint(g);
        } else {
            Dimension ellipsisSize = this.ELLIPSIS_LABEL.getPreferredSize();
            int endOffset = size.width - ellipsisSize.width;
            try {
                endOffset = this.modelToView((int)(this.viewToModel((Point)new Point((int)endOffset, (int)0)) - 1)).x;
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            Shape oldClip = g.getClip();
            g.clipRect(0, 0, endOffset, size.height);
            super.paint(g);
            g.setClip(oldClip);
            g.translate(endOffset, 0);
            this.ELLIPSIS_LABEL.setSize(ellipsisSize);
            this.ELLIPSIS_LABEL.paint(g);
            g.translate(-endOffset, 0);
        }
    }
}

