/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dupLocator.util;

import com.intellij.dupLocator.DuplicatesProfile;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.PsiAnchor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.usageView.UsageInfo;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PsiFragment {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.dupLocator.PsiFragment");
    protected final PsiAnchor[] myElementAnchors;
    private final Language myLanguage;
    private PsiFragment[] myParents;
    private boolean myDuplicate;
    private boolean myChecked;
    private boolean myNested;
    private int myCost;

    public PsiFragment(PsiElement element) {
        this(element, 0);
    }

    public PsiFragment(PsiElement element, int cost) {
        this.myElementAnchors = new PsiAnchor[]{this.createAnchor(element)};
        this.myDuplicate = false;
        this.myChecked = false;
        this.myNested = false;
        this.myParents = null;
        this.myCost = cost;
        this.myLanguage = this.calcLanguage(element);
    }

    protected Language calcLanguage(PsiElement element) {
        return PsiFragment.doGetLanguageForElement(element);
    }

    protected PsiAnchor createAnchor(final PsiElement element) {
        return (PsiAnchor)ApplicationManager.getApplication().runReadAction((Computable)new Computable<PsiAnchor>(){

            public PsiAnchor compute() {
                return PsiAnchor.create(element);
            }
        });
    }

    public PsiFragment(List<? extends PsiElement> elements) {
        this(elements, 0, elements.size() - 1);
    }

    public PsiFragment(List<? extends PsiElement> elements, int from, int to) {
        this.myElementAnchors = new PsiAnchor[to - from + 1];
        for (int i = from; i <= to; ++i) {
            this.myElementAnchors[i - from] = this.createAnchor(elements.get(i));
        }
        this.myDuplicate = false;
        this.myChecked = false;
        this.myNested = false;
        this.myParents = null;
        this.myLanguage = to >= from && from < elements.size() ? this.calcLanguage(elements.get(from)) : null;
    }

    @NotNull
    private static Language doGetLanguageForElement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/dupLocator/util/PsiFragment", "doGetLanguageForElement"));
        }
        DuplicatesProfile profile = DuplicatesProfile.findProfileForLanguage(element.getLanguage());
        if (profile == null) {
            Language language = element.getLanguage();
            if (language == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dupLocator/util/PsiFragment", "doGetLanguageForElement"));
            }
            return language;
        }
        Language language = profile.getLanguage(element);
        if (language == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dupLocator/util/PsiFragment", "doGetLanguageForElement"));
        }
        return language;
    }

    public void setCost(int c) {
        if (this.myCost != -1) {
            this.myCost = c;
        }
    }

    public void markDuplicate() {
        this.myDuplicate = true;
    }

    public boolean isNested() {
        if (this.myChecked) {
            return this.myNested;
        }
        this.myChecked = true;
        if (this.myParents != null) {
            PsiFragment parent1 = this.myParents[0];
            PsiFragment parent2 = this.myParents[1];
            if (parent1 != null) {
                this.myNested |= parent1.myDuplicate || parent1.isNested();
                if (parent2 != null) {
                    this.myNested |= parent2.myDuplicate || parent2.isNested();
                }
            }
        }
        return this.myNested;
    }

    public void setParent(PsiFragment f) {
        if (f == null) {
            return;
        }
        if (this.myParents == null) {
            this.myParents = new PsiFragment[]{f, null};
        } else {
            if (this.myParents[0] == f || this.myParents[1] == f) {
                return;
            }
            if (this.myParents[1] != null) {
                LOG.error("Third parent set.");
            }
            this.myParents[1] = f;
        }
    }

    public PsiElement[] getElements() {
        PsiElement[] elements = new PsiElement[this.myElementAnchors.length];
        for (int i = 0; i < elements.length; ++i) {
            elements[i] = this.myElementAnchors[i].retrieve();
        }
        return elements;
    }

    @Nullable
    public PsiFile getFile() {
        return this.myElementAnchors.length > 0 ? this.myElementAnchors[0].getFile() : null;
    }

    public int getStartOffset() {
        return this.myElementAnchors.length > 0 ? this.myElementAnchors[0].getStartOffset() : -1;
    }

    public int getEndOffset() {
        return this.myElementAnchors.length > 0 ? this.myElementAnchors[this.myElementAnchors.length - 1].getEndOffset() : -1;
    }

    public boolean intersectsWith(PsiFragment f) {
        int start = this.getStartOffset();
        int end = this.getEndOffset();
        int fStart = f.getStartOffset();
        int fEnd = f.getEndOffset();
        return Comparing.equal((Object)f.getFile(), (Object)this.getFile()) && (start <= fStart && fStart <= end || start <= fEnd && fEnd <= end);
    }

    public boolean contains(PsiFragment f) {
        int start = this.getStartOffset();
        int end = this.getEndOffset();
        int fStart = f.getStartOffset();
        int fEnd = f.getEndOffset();
        return Comparing.equal((Object)f.getFile(), (Object)this.getFile()) && start <= fStart && end >= fEnd;
    }

    public abstract boolean isEqual(PsiElement[] var1, int var2);

    @Nullable
    public UsageInfo getUsageInfo() {
        if (this.myElementAnchors.length == 1) {
            PsiElement element = this.myElementAnchors[0].retrieve();
            if (element == null || !element.isValid()) {
                return null;
            }
            return new UsageInfo(element);
        }
        PsiElement parent = PsiTreeUtil.findCommonParent((PsiElement[])this.getElements());
        if (parent == null) {
            return null;
        }
        int offs = parent.getTextRange().getStartOffset();
        int startOffsetInParent = this.getStartOffset() - offs;
        int endOffsetInParent = this.getEndOffset() - offs;
        if (startOffsetInParent < 0) {
            return null;
        }
        if (endOffsetInParent < startOffsetInParent) {
            return null;
        }
        return new UsageInfo(parent, startOffsetInParent, endOffsetInParent);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        for (PsiAnchor psiAnchor : this.myElementAnchors) {
            PsiElement element = psiAnchor.retrieve();
            if (element == null) continue;
            buffer.append(element.getText());
            buffer.append("\n");
        }
        return buffer.toString();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PsiFragment)) {
            return false;
        }
        PsiFragment other = (PsiFragment)o;
        return other.getStartOffset() == this.getStartOffset() && other.getEndOffset() == this.getEndOffset() && Comparing.equal((Object)other.getFile(), (Object)this.getFile());
    }

    public int hashCode() {
        int result2 = this.getStartOffset();
        result2 += 31 * result2 + this.getEndOffset();
        PsiFile file = this.getFile();
        if (file != null) {
            result2 += 31 * result2 + file.getName().hashCode();
        }
        return result2;
    }

    public int getCost() {
        return this.myCost;
    }

    public int[][] getOffsets() {
        int[][] result2 = new int[this.myElementAnchors.length][2];
        int idx = 0;
        for (PsiAnchor anchor : this.myElementAnchors) {
            result2[idx][0] = anchor.getStartOffset();
            result2[idx++][1] = anchor.getEndOffset();
        }
        return result2;
    }

    public boolean containsMultipleFragments() {
        return this.myElementAnchors.length > 1;
    }

    @Nullable
    public Language getLanguage() {
        return this.myLanguage;
    }
}

