/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.push.ui;

import com.intellij.dvcs.push.ui.CommitNode;
import com.intellij.dvcs.push.ui.CustomRenderedTreeNode;
import com.intellij.dvcs.push.ui.EditableTreeNode;
import com.intellij.dvcs.push.ui.PushLogTreeUtil;
import com.intellij.dvcs.push.ui.RepositoryNode;
import com.intellij.dvcs.push.ui.RepositoryWithBranchPanel;
import com.intellij.dvcs.push.ui.TooltipNode;
import com.intellij.dvcs.push.ui.VcsBranchEditorListener;
import com.intellij.dvcs.push.ui.VcsCommitInfoBalloon;
import com.intellij.dvcs.push.ui.VcsEditableComponent;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.TextRevisionNumber;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesTreeBrowser;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowser;
import com.intellij.openapi.vcs.changes.ui.EditSourceForDialogAction;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.ui.AncestorListenerAdapter;
import com.intellij.ui.CheckboxTree;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.JBViewport;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.ui.components.labels.LinkListener;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.util.ui.tree.WideSelectionTreeUI;
import com.intellij.vcs.log.Hash;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import javax.swing.AbstractCellEditor;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.ToolTipManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.plaf.TreeUI;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.AbstractLayoutCache;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PushLog
extends JPanel
implements DataProvider {
    private static final String CONTEXT_MENU = "Vcs.Push.ContextMenu";
    private static final String START_EDITING = "startEditing";
    private final ChangesBrowser myChangesBrowser;
    private final CheckboxTree myTree;
    private final MyTreeCellRenderer myTreeCellRenderer;
    private final JScrollPane myScrollPane;
    private final VcsCommitInfoBalloon myBalloon;
    private boolean myShouldRepaint = false;
    private boolean mySyncStrategy;
    @Nullable
    private String mySyncRenderedText;
    private final boolean myAllowSyncStrategy;

    public PushLog(Project project, final CheckedTreeNode root, boolean allowSyncStrategy) {
        this.myAllowSyncStrategy = allowSyncStrategy;
        DefaultTreeModel treeModel = new DefaultTreeModel((TreeNode)root);
        treeModel.nodeStructureChanged((TreeNode)root);
        final AnAction quickDocAction = ActionManager.getInstance().getAction("QuickJavaDoc");
        this.myTreeCellRenderer = new MyTreeCellRenderer();
        this.myTree = new CheckboxTree(this.myTreeCellRenderer, root){

            public boolean isPathEditable(TreePath path) {
                return this.isEditable() && path.getLastPathComponent() instanceof DefaultMutableTreeNode;
            }

            protected void onNodeStateChanged(CheckedTreeNode node) {
                if (node instanceof EditableTreeNode) {
                    ((EditableTreeNode)node).fireOnSelectionChange(node.isChecked());
                }
            }

            public String getToolTipText(MouseEvent event) {
                TreePath path = PushLog.this.myTree.getPathForLocation(event.getX(), event.getY());
                if (path == null) {
                    return "";
                }
                Object node = path.getLastPathComponent();
                if (node == null || !(node instanceof DefaultMutableTreeNode)) {
                    return "";
                }
                if (node instanceof TooltipNode) {
                    return KeymapUtil.createTooltipText((String)(((TooltipNode)node).getTooltip() + "<p style='font-style:italic;color:gray;'>Show commit details"), (AnAction)quickDocAction) + "</p>";
                }
                return "";
            }

            public boolean stopEditing() {
                JComponent editedComponent;
                InputVerifier verifier;
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)PushLog.this.myTree.getLastSelectedPathComponent();
                if (node instanceof EditableTreeNode && (verifier = (editedComponent = (JComponent)node.getUserObject()).getInputVerifier()) != null && !verifier.verify(editedComponent)) {
                    return false;
                }
                boolean result2 = super.stopEditing();
                if (PushLog.this.myShouldRepaint) {
                    PushLog.this.refreshNode((DefaultMutableTreeNode)root);
                }
                PushLog.this.restoreSelection(node);
                return result2;
            }

            public void cancelEditing() {
                DefaultMutableTreeNode lastSelectedPathComponent = (DefaultMutableTreeNode)PushLog.this.myTree.getLastSelectedPathComponent();
                super.cancelEditing();
                if (PushLog.this.myShouldRepaint) {
                    PushLog.this.refreshNode((DefaultMutableTreeNode)root);
                }
                PushLog.this.restoreSelection(lastSelectedPathComponent);
            }
        };
        this.myTree.setUI((TreeUI)((Object)new MyTreeUi()));
        this.myTree.setBorder(new EmptyBorder(2, 0, 0, 0));
        this.myTree.setEditable(true);
        this.myTree.setHorizontalAutoScrollingEnabled(false);
        this.myTree.setShowsRootHandles(root.getChildCount() > 1);
        MyTreeCellEditor treeCellEditor = new MyTreeCellEditor();
        this.myTree.setCellEditor(treeCellEditor);
        treeCellEditor.addCellEditorListener(new CellEditorListener(){

            @Override
            public void editingStopped(ChangeEvent e) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)PushLog.this.myTree.getLastSelectedPathComponent();
                if (node != null && node instanceof EditableTreeNode) {
                    JComponent editedComponent = (JComponent)node.getUserObject();
                    InputVerifier verifier = editedComponent.getInputVerifier();
                    if (verifier != null && !verifier.verify(editedComponent)) {
                        ((EditableTreeNode)((Object)node)).fireOnCancel();
                    } else if (PushLog.this.mySyncStrategy) {
                        PushLog.this.resetEditSync();
                        ContainerUtil.process((List)PushLog.getChildNodesByType((DefaultMutableTreeNode)root, RepositoryNode.class, false), (Processor)new Processor<RepositoryNode>(){

                            public boolean process(RepositoryNode node) {
                                node.fireOnChange();
                                return true;
                            }
                        });
                    } else {
                        ((EditableTreeNode)((Object)node)).fireOnChange();
                    }
                }
                PushLog.this.myTree.firePropertyChange("tree.edit.mode", true, false);
            }

            @Override
            public void editingCanceled(ChangeEvent e) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)PushLog.this.myTree.getLastSelectedPathComponent();
                if (node != null && node instanceof EditableTreeNode) {
                    ((EditableTreeNode)((Object)node)).fireOnCancel();
                }
                PushLog.this.resetEditSync();
                PushLog.this.myTree.firePropertyChange("tree.edit.mode", true, false);
            }
        });
        this.myTree.setInvokesStopCellEditing(true);
        this.myTree.setRootVisible(false);
        TreeUtil.collapseAll((JTree)((Object)this.myTree), (int)1);
        VcsBranchEditorListener linkMouseListener = new VcsBranchEditorListener(this.myTreeCellRenderer);
        linkMouseListener.installOn((Component)((Object)this.myTree));
        this.myBalloon = new VcsCommitInfoBalloon((JTree)((Object)this.myTree));
        this.myTree.getSelectionModel().setSelectionMode(4);
        this.myTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                PushLog.this.updateChangesView();
                PushLog.this.myBalloon.updateCommitDetails();
            }
        });
        this.myTree.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)PushLog.this.myTree.getLastSelectedPathComponent();
                if (node != null && node instanceof RepositoryNode && PushLog.this.myTree.isEditing()) {
                    PushLog.this.myTree.getCellEditor().getTreeCellEditorComponent((JTree)((Object)PushLog.this.myTree), node, true, false, false, PushLog.this.myTree.getRowForPath(TreeUtil.getPathFromRoot((TreeNode)node)));
                }
            }
        });
        this.myTree.getInputMap().put(KeyStroke.getKeyStroke(113, 0), START_EDITING);
        this.myTree.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "");
        MyShowCommitInfoAction showCommitInfoAction = new MyShowCommitInfoAction();
        showCommitInfoAction.registerCustomShortcutSet(quickDocAction.getShortcutSet(), (JComponent)((Object)this.myTree));
        ToolTipManager.sharedInstance().registerComponent((JComponent)((Object)this.myTree));
        PopupHandler.installPopupHandler((JComponent)((Object)this.myTree), (String)"Vcs.Log.ContextMenu", (String)CONTEXT_MENU);
        this.myChangesBrowser = new ChangesBrowser(project, null, Collections.<Change>emptyList(), null, false, true, null, ChangesBrowser.MyUseCase.LOCAL_CHANGES, null);
        this.myChangesBrowser.getDiffAction().registerCustomShortcutSet(this.myChangesBrowser.getDiffAction().getShortcutSet(), (JComponent)((Object)this.myTree));
        EditSourceForDialogAction editSourceAction = new EditSourceForDialogAction(this.myChangesBrowser);
        editSourceAction.registerCustomShortcutSet(CommonShortcuts.getEditSource(), this.myChangesBrowser);
        this.myChangesBrowser.addToolbarAction(editSourceAction);
        this.setDefaultEmptyText();
        Splitter splitter = new Splitter(false, 0.7f);
        final JComponent syncStrategyPanel = this.myAllowSyncStrategy ? this.createStrategyPanel() : null;
        this.myScrollPane = new JBScrollPane((Component)((Object)this.myTree)){

            public void layout() {
                super.layout();
                if (syncStrategyPanel != null) {
                    Rectangle bounds = this.getViewport().getBounds();
                    int height = bounds.height - syncStrategyPanel.getPreferredSize().height;
                    this.getViewport().setBounds(bounds.x, bounds.y, bounds.width, height);
                    syncStrategyPanel.setBounds(bounds.x, bounds.y + height, bounds.width, syncStrategyPanel.getPreferredSize().height);
                }
            }
        };
        if (syncStrategyPanel != null) {
            this.myScrollPane.setViewport((JViewport)((Object)new MyTreeViewPort((Component)((Object)this.myTree), syncStrategyPanel.getPreferredSize().height)));
        }
        this.myScrollPane.getViewport().setScrollMode(0);
        this.myScrollPane.setOpaque(false);
        if (syncStrategyPanel != null) {
            this.myScrollPane.add(syncStrategyPanel);
        }
        splitter.setFirstComponent((JComponent)this.myScrollPane);
        splitter.setSecondComponent((JComponent)this.myChangesBrowser);
        this.setLayout(new BorderLayout());
        this.add((Component)splitter);
        this.myTree.setMinimumSize(new Dimension(200, this.myTree.getPreferredSize().height));
        this.myTree.setRowHeight(0);
    }

    private void restoreSelection(@Nullable DefaultMutableTreeNode node) {
        if (node != null) {
            TreeUtil.selectNode((JTree)((Object)this.myTree), (TreeNode)node);
        }
    }

    private JComponent createStrategyPanel() {
        JPanel labelPanel = new JPanel(new BorderLayout());
        labelPanel.setBackground(this.myTree.getBackground());
        final LinkLabel linkLabel = new LinkLabel("Edit all targets", null);
        linkLabel.setBorder((Border)new EmptyBorder(2, 2, 2, 2));
        linkLabel.setListener((LinkListener)new LinkListener<String>(){

            public void linkSelected(LinkLabel aSource, String aLinkData) {
                if (linkLabel.isEnabled()) {
                    PushLog.this.startSyncEditing();
                }
            }
        }, null);
        this.myTree.addPropertyChangeListener("tree.edit.mode", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Boolean editMode = (Boolean)evt.getNewValue();
                linkLabel.setEnabled(editMode == false);
                linkLabel.setPaintUnderline(editMode == false);
                linkLabel.repaint();
            }
        });
        labelPanel.add((Component)linkLabel, "East");
        return labelPanel;
    }

    private void startSyncEditing() {
        this.mySyncStrategy = true;
        DefaultMutableTreeNode nodeToEdit = this.getFirstNodeToEdit();
        if (nodeToEdit != null) {
            this.myTree.startEditingAtPath(TreeUtil.getPathFromRoot((TreeNode)nodeToEdit));
        }
    }

    @NotNull
    private static List<Change> collectAllChanges(@NotNull List<CommitNode> commitNodes) {
        if (commitNodes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commitNodes", "com/intellij/dvcs/push/ui/PushLog", "collectAllChanges"));
        }
        List<Change> list = CommittedChangesTreeBrowser.zipChanges(PushLog.collectChanges(commitNodes));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/push/ui/PushLog", "collectAllChanges"));
        }
        return list;
    }

    @NotNull
    private static List<CommitNode> collectSelectedCommitNodes(@NotNull List<DefaultMutableTreeNode> selectedNodes) {
        if (selectedNodes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectedNodes", "com/intellij/dvcs/push/ui/PushLog", "collectSelectedCommitNodes"));
        }
        ArrayList nodes = ContainerUtil.newArrayList();
        for (DefaultMutableTreeNode node : selectedNodes) {
            if (node instanceof RepositoryNode) {
                nodes.addAll(PushLog.getChildNodesByType(node, CommitNode.class, true));
                continue;
            }
            if (!(node instanceof CommitNode) || nodes.contains(node)) continue;
            nodes.add((CommitNode)node);
        }
        ArrayList arrayList = nodes;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/push/ui/PushLog", "collectSelectedCommitNodes"));
        }
        return arrayList;
    }

    @NotNull
    private static List<Change> collectChanges(@NotNull List<CommitNode> commitNodes) {
        if (commitNodes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commitNodes", "com/intellij/dvcs/push/ui/PushLog", "collectChanges"));
        }
        ArrayList changes = ContainerUtil.newArrayList();
        for (CommitNode node : commitNodes) {
            changes.addAll(node.getUserObject().getChanges());
        }
        ArrayList arrayList = changes;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/push/ui/PushLog", "collectChanges"));
        }
        return arrayList;
    }

    @NotNull
    private static <T> List<T> getChildNodesByType(@NotNull DefaultMutableTreeNode node, Class<T> type, boolean reverseOrder) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/dvcs/push/ui/PushLog", "getChildNodesByType"));
        }
        ArrayList nodes = ContainerUtil.newArrayList();
        if (node.getChildCount() < 1) {
            ArrayList arrayList = nodes;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/push/ui/PushLog", "getChildNodesByType"));
            }
            return arrayList;
        }
        DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)node.getFirstChild();
        while (childNode != null) {
            if (type.isInstance(childNode)) {
                DefaultMutableTreeNode nodeT = childNode;
                if (reverseOrder) {
                    nodes.add(0, nodeT);
                } else {
                    nodes.add(nodeT);
                }
            }
            childNode = (DefaultMutableTreeNode)node.getChildAfter(childNode);
        }
        ArrayList arrayList = nodes;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/push/ui/PushLog", "getChildNodesByType"));
        }
        return arrayList;
    }

    @NotNull
    private static List<Integer> getSortedRows(@NotNull int[] rows) {
        if (rows == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rows", "com/intellij/dvcs/push/ui/PushLog", "getSortedRows"));
        }
        ArrayList sorted = ContainerUtil.newArrayList();
        for (int row : rows) {
            sorted.add(row);
        }
        Collections.sort(sorted, Collections.reverseOrder());
        ArrayList arrayList = sorted;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/push/ui/PushLog", "getSortedRows"));
        }
        return arrayList;
    }

    private void updateChangesView() {
        List<CommitNode> commitNodes = this.getSelectedCommitNodes();
        if (!commitNodes.isEmpty()) {
            this.myChangesBrowser.getViewer().setEmptyText("No differences");
        } else {
            this.setDefaultEmptyText();
        }
        this.myChangesBrowser.setChangesToDisplay(PushLog.collectAllChanges(commitNodes));
    }

    private void setDefaultEmptyText() {
        this.myChangesBrowser.getViewer().setEmptyText("No commits selected");
    }

    @Nullable
    public Object getData(String id) {
        if (VcsDataKeys.CHANGES.is(id)) {
            List<CommitNode> commitNodes = this.getSelectedCommitNodes();
            return ArrayUtil.toObjectArray(PushLog.collectAllChanges(commitNodes), Change.class);
        }
        if (VcsDataKeys.VCS_REVISION_NUMBERS.is(id)) {
            List<CommitNode> commitNodes = this.getSelectedCommitNodes();
            return ArrayUtil.toObjectArray((Collection)ContainerUtil.map(commitNodes, (Function)new Function<CommitNode, VcsRevisionNumber>(){

                public VcsRevisionNumber fun(CommitNode commitNode) {
                    Hash hash = (Hash)commitNode.getUserObject().getId();
                    return new TextRevisionNumber(hash.asString(), hash.toShortString());
                }
            }), VcsRevisionNumber.class);
        }
        return null;
    }

    @NotNull
    private List<CommitNode> getSelectedCommitNodes() {
        int[] rows = this.myTree.getSelectionRows();
        if (rows != null && rows.length != 0) {
            List<DefaultMutableTreeNode> selectedNodes = this.getNodesForRows(PushLog.getSortedRows(rows));
            List<CommitNode> list = PushLog.collectSelectedCommitNodes(selectedNodes);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/push/ui/PushLog", "getSelectedCommitNodes"));
            }
            return list;
        }
        List list = ContainerUtil.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/push/ui/PushLog", "getSelectedCommitNodes"));
        }
        return list;
    }

    @NotNull
    private List<DefaultMutableTreeNode> getNodesForRows(@NotNull List<Integer> rows) {
        if (rows == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rows", "com/intellij/dvcs/push/ui/PushLog", "getNodesForRows"));
        }
        ArrayList nodes = ContainerUtil.newArrayList();
        for (Integer row : rows) {
            TreePath path = this.myTree.getPathForRow(row);
            Object pathComponent = path == null ? null : path.getLastPathComponent();
            if (!(pathComponent instanceof DefaultMutableTreeNode)) continue;
            nodes.add((DefaultMutableTreeNode)pathComponent);
        }
        ArrayList arrayList = nodes;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/push/ui/PushLog", "getNodesForRows"));
        }
        return arrayList;
    }

    @Override
    protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
        if (e.getKeyCode() == 10 && e.getModifiers() == 0 && pressed) {
            if (this.myTree.isEditing()) {
                this.myTree.stopEditing();
            } else {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.myTree.getLastSelectedPathComponent();
                if (node != null) {
                    this.myTree.startEditingAtPath(TreeUtil.getPathFromRoot((TreeNode)node));
                }
            }
            return true;
        }
        if (this.myAllowSyncStrategy && e.getKeyCode() == 113 && e.getModifiers() == 8 && pressed) {
            this.startSyncEditing();
            return true;
        }
        return super.processKeyBinding(ks, e, condition, pressed);
    }

    @Nullable
    private DefaultMutableTreeNode getFirstNodeToEdit() {
        RepositoryNode selectedNode;
        if (this.myTree.getLastSelectedPathComponent() instanceof RepositoryNode && (selectedNode = (RepositoryNode)this.myTree.getLastSelectedPathComponent()).isEditableNow()) {
            return selectedNode;
        }
        List<RepositoryNode> repositoryNodes = PushLog.getChildNodesByType((DefaultMutableTreeNode)this.myTree.getModel().getRoot(), RepositoryNode.class, false);
        RepositoryNode editableNode = (RepositoryNode)ContainerUtil.find(repositoryNodes, (Condition)new Condition<RepositoryNode>(){

            public boolean value(RepositoryNode repositoryNode) {
                return repositoryNode.isEditableNow();
            }
        });
        if (editableNode != null) {
            TreeUtil.selectNode((JTree)((Object)this.myTree), (TreeNode)((Object)editableNode));
        }
        return editableNode;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myTree;
    }

    @NotNull
    public JTree getTree() {
        CheckboxTree checkboxTree = this.myTree;
        if (checkboxTree == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/push/ui/PushLog", "getTree"));
        }
        return checkboxTree;
    }

    public void selectIfNothingSelected(@NotNull TreeNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/dvcs/push/ui/PushLog", "selectIfNothingSelected"));
        }
        if (this.myTree.isSelectionEmpty()) {
            this.myTree.setSelectionPath(TreeUtil.getPathFromRoot((TreeNode)node));
        }
    }

    public void setChildren(@NotNull DefaultMutableTreeNode parentNode, @NotNull Collection<? extends DefaultMutableTreeNode> childrenNodes) {
        if (parentNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentNode", "com/intellij/dvcs/push/ui/PushLog", "setChildren"));
        }
        if (childrenNodes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "childrenNodes", "com/intellij/dvcs/push/ui/PushLog", "setChildren"));
        }
        parentNode.removeAllChildren();
        for (DefaultMutableTreeNode defaultMutableTreeNode : childrenNodes) {
            parentNode.add(defaultMutableTreeNode);
        }
        if (!this.myTree.isEditing()) {
            this.refreshNode(parentNode);
            TreePath path = TreeUtil.getPathFromRoot((TreeNode)parentNode);
            if (this.myTree.getSelectionModel().isPathSelected(path)) {
                this.updateChangesView();
            }
        } else {
            this.myShouldRepaint = true;
        }
    }

    private void refreshNode(@NotNull DefaultMutableTreeNode parentNode) {
        if (parentNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentNode", "com/intellij/dvcs/push/ui/PushLog", "refreshNode"));
        }
        DefaultTreeModel model = (DefaultTreeModel)this.myTree.getModel();
        model.nodeStructureChanged(parentNode);
        this.expandSelected(parentNode);
        this.myShouldRepaint = false;
    }

    private void expandSelected(@NotNull DefaultMutableTreeNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/dvcs/push/ui/PushLog", "expandSelected"));
        }
        if (node.getChildCount() <= 0) {
            return;
        }
        if (node instanceof RepositoryNode) {
            TreePath path = TreeUtil.getPathFromRoot((TreeNode)node);
            this.myTree.expandPath(path);
            return;
        }
        DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)node.getFirstChild();
        while (childNode != null) {
            if (!(childNode instanceof RepositoryNode)) {
                return;
            }
            TreePath path = TreeUtil.getPathFromRoot((TreeNode)childNode);
            if (((RepositoryNode)((Object)childNode)).isChecked()) {
                this.myTree.expandPath(path);
            }
            childNode = (DefaultMutableTreeNode)node.getChildAfter(childNode);
        }
    }

    private void setSyncText(String value) {
        this.mySyncRenderedText = value;
    }

    public void fireEditorUpdated(@NotNull String currentText) {
        if (currentText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentText", "com/intellij/dvcs/push/ui/PushLog", "fireEditorUpdated"));
        }
        if (this.mySyncStrategy) {
            List<RepositoryNode> repositoryNodes = PushLog.getChildNodesByType((DefaultMutableTreeNode)this.myTree.getModel().getRoot(), RepositoryNode.class, false);
            for (RepositoryNode node : repositoryNodes) {
                if (!node.isEditableNow()) continue;
                node.forceUpdateUiModelWithTypedText(currentText);
            }
            this.setSyncText(currentText);
            this.myTree.repaint();
        }
    }

    private void resetEditSync() {
        if (this.mySyncStrategy) {
            this.mySyncStrategy = false;
            this.mySyncRenderedText = null;
        }
    }

    private static class MyTreeViewPort
    extends JBViewport {
        final int myHeightToReduce;

        public MyTreeViewPort(@Nullable Component view, int heightToReduce) {
            this.setView(view);
            this.myHeightToReduce = heightToReduce;
        }

        public Dimension getExtentSize() {
            Dimension defaultSize = super.getExtentSize();
            return new Dimension(defaultSize.width, defaultSize.height - this.myHeightToReduce);
        }
    }

    private class MyTreeUi
    extends WideSelectionTreeUI {
        private final ComponentListener myTreeSizeListener = new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                MyTreeUi.this.updateSizes();
            }
        };
        private final AncestorListener myTreeAncestorListener = new AncestorListenerAdapter(){

            public void ancestorMoved(AncestorEvent event) {
                super.ancestorMoved(event);
                MyTreeUi.this.updateSizes();
            }
        };

        private MyTreeUi() {
        }

        private void updateSizes() {
            this.treeState.invalidateSizes();
            this.tree.repaint();
        }

        protected void installListeners() {
            super.installListeners();
            this.tree.addComponentListener(this.myTreeSizeListener);
            this.tree.addAncestorListener(this.myTreeAncestorListener);
        }

        protected void uninstallListeners() {
            this.tree.removeComponentListener(this.myTreeSizeListener);
            this.tree.removeAncestorListener(this.myTreeAncestorListener);
            super.uninstallListeners();
        }

        protected AbstractLayoutCache.NodeDimensions createNodeDimensions() {
            return new BasicTreeUI.NodeDimensionsHandler(){

                @Override
                public Rectangle getNodeDimensions(Object value, int row, int depth, boolean expanded, Rectangle size) {
                    Rectangle dimensions = super.getNodeDimensions(value, row, depth, expanded, size);
                    dimensions.width = PushLog.this.myScrollPane != null ? Math.max(PushLog.this.myScrollPane.getViewport().getWidth() - this.getRowX(row, depth), dimensions.width) : Math.max(((PushLog)PushLog.this).myTree.getMinimumSize().width, dimensions.width);
                    return dimensions;
                }
            };
        }
    }

    private class MyTreeCellEditor
    extends AbstractCellEditor
    implements TreeCellEditor {
        private RepositoryWithBranchPanel myValue;

        private MyTreeCellEditor() {
        }

        @Override
        public Component getTreeCellEditorComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row) {
            RepositoryWithBranchPanel panel;
            this.myValue = panel = (RepositoryWithBranchPanel)((Object)((DefaultMutableTreeNode)value).getUserObject());
            PushLog.this.myTree.firePropertyChange("tree.edit.mode", false, true);
            return panel.getTreeCellEditorComponent(tree, value, isSelected, expanded, leaf, row, true);
        }

        @Override
        public boolean isCellEditable(EventObject anEvent) {
            if (anEvent instanceof MouseEvent) {
                MouseEvent me = (MouseEvent)anEvent;
                TreePath path = PushLog.this.myTree.getClosestPathForLocation(me.getX(), me.getY());
                int row = PushLog.this.myTree.getRowForLocation(me.getX(), me.getY());
                PushLog.this.myTree.getCellRenderer().getTreeCellRendererComponent((JTree)((Object)PushLog.this.myTree), path.getLastPathComponent(), false, false, true, row, true);
                Object tag = me.getClickCount() >= 1 ? PushLogTreeUtil.getTagAtForRenderer(PushLog.this.myTreeCellRenderer, me) : null;
                return tag instanceof VcsEditableComponent;
            }
            TreePath treePath = PushLog.this.myTree.getAnchorSelectionPath();
            if (treePath == null) {
                return true;
            }
            Object treeNode = treePath.getLastPathComponent();
            return treeNode instanceof EditableTreeNode && ((EditableTreeNode)treeNode).isEditableNow();
        }

        @Override
        public Object getCellEditorValue() {
            return this.myValue;
        }
    }

    private class MyTreeCellRenderer
    extends CheckboxTree.CheckboxTreeCellRenderer {
        private MyTreeCellRenderer() {
        }

        public void customizeRenderer(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            if (!(value instanceof DefaultMutableTreeNode)) {
                return;
            }
            this.myCheckbox.setBorder(null);
            if (value instanceof RepositoryNode) {
                this.myCheckbox.setVisible(((RepositoryNode)value).isCheckboxVisible());
            }
            Object userObject = ((DefaultMutableTreeNode)value).getUserObject();
            ColoredTreeCellRenderer renderer = this.getTextRenderer();
            if (value instanceof CustomRenderedTreeNode) {
                if (tree.isEditing() && PushLog.this.mySyncStrategy && value instanceof RepositoryNode) {
                    ((RepositoryNode)value).render(renderer, PushLog.this.mySyncRenderedText);
                } else {
                    ((CustomRenderedTreeNode)value).render(renderer);
                }
            } else {
                renderer.append(userObject == null ? "" : userObject.toString());
            }
        }
    }

    private class MyShowCommitInfoAction
    extends DumbAwareAction {
        private MyShowCommitInfoAction() {
        }

        public void actionPerformed(AnActionEvent e) {
            PushLog.this.myBalloon.showCommitDetails();
        }

        public void update(AnActionEvent e) {
            e.getPresentation().setEnabled(PushLog.this.getSelectedCommitNodes().size() == 1);
        }
    }
}

