/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution;

import com.intellij.execution.ExecutionManager;
import com.intellij.execution.ExecutionMode;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunContentManager;
import com.intellij.ide.errorTreeView.NewErrorTreeViewPanel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.pom.NonNavigatable;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.components.JBList;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.MessageView;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.NotNullFunction;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.ErrorTreeView;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExecutionHelper {
    private static final Logger LOG = Logger.getInstance((String)ExecutionHelper.class.getName());

    private ExecutionHelper() {
    }

    public static void showErrors(@NotNull Project myProject, @NotNull List<? extends Exception> errors, @NotNull String tabDisplayName, @Nullable VirtualFile file) {
        if (myProject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "myProject", "com/intellij/execution/ExecutionHelper", "showErrors"));
        }
        if (errors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errors", "com/intellij/execution/ExecutionHelper", "showErrors"));
        }
        if (tabDisplayName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tabDisplayName", "com/intellij/execution/ExecutionHelper", "showErrors"));
        }
        ExecutionHelper.showExceptions(myProject, errors, Collections.emptyList(), tabDisplayName, file);
    }

    public static void showExceptions(final @NotNull Project myProject, final @NotNull List<? extends Exception> errors, final @NotNull List<? extends Exception> warnings, final @NotNull String tabDisplayName, final @Nullable VirtualFile file) {
        if (myProject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "myProject", "com/intellij/execution/ExecutionHelper", "showExceptions"));
        }
        if (errors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errors", "com/intellij/execution/ExecutionHelper", "showExceptions"));
        }
        if (warnings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "warnings", "com/intellij/execution/ExecutionHelper", "showExceptions"));
        }
        if (tabDisplayName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tabDisplayName", "com/intellij/execution/ExecutionHelper", "showExceptions"));
        }
        if (ApplicationManager.getApplication().isUnitTestMode() && !errors.isEmpty()) {
            throw new RuntimeException(errors.get(0));
        }
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                if (myProject.isDisposed()) {
                    return;
                }
                if (errors.isEmpty() && warnings.isEmpty()) {
                    ExecutionHelper.removeContents(null, myProject, tabDisplayName);
                    return;
                }
                ErrorViewPanel errorTreeView = new ErrorViewPanel(myProject);
                try {
                    ExecutionHelper.openMessagesView(errorTreeView, myProject, tabDisplayName);
                }
                catch (NullPointerException e) {
                    StringBuilder builder = new StringBuilder();
                    builder.append("Exceptions occurred:");
                    for (Exception exception : errors) {
                        builder.append("\n");
                        builder.append(exception.getMessage());
                    }
                    builder.append("Warnings occurred:");
                    for (Exception exception : warnings) {
                        builder.append("\n");
                        builder.append(exception.getMessage());
                    }
                    Messages.showErrorDialog((String)builder.toString(), (String)"Execution Error");
                    return;
                }
                ExecutionHelper.addMessages(4, errors, errorTreeView, file, "Unknown Error");
                ExecutionHelper.addMessages(5, warnings, errorTreeView, file, "Unknown Warning");
                ToolWindowManager.getInstance((Project)myProject).getToolWindow(ToolWindowId.MESSAGES_WINDOW).activate(null);
            }
        });
    }

    private static void addMessages(int messageCategory, @NotNull List<? extends Exception> exceptions, @NotNull ErrorViewPanel errorTreeView, @Nullable VirtualFile file, @NotNull String defaultMessage) {
        if (exceptions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exceptions", "com/intellij/execution/ExecutionHelper", "addMessages"));
        }
        if (errorTreeView == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorTreeView", "com/intellij/execution/ExecutionHelper", "addMessages"));
        }
        if (defaultMessage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultMessage", "com/intellij/execution/ExecutionHelper", "addMessages"));
        }
        for (Exception exception : exceptions) {
            String[] messages;
            String message = exception.getMessage();
            String[] stringArray = messages = StringUtil.isNotEmpty((String)message) ? StringUtil.splitByLines((String)message) : ArrayUtil.EMPTY_STRING_ARRAY;
            if (messages.length == 0) {
                messages = new String[]{defaultMessage};
            }
            errorTreeView.addMessage(messageCategory, messages, file, -1, -1, null);
        }
    }

    public static void showOutput(final @NotNull Project myProject, final @NotNull ProcessOutput output, final @NotNull String tabDisplayName, final @Nullable VirtualFile file, final boolean activateWindow) {
        if (myProject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "myProject", "com/intellij/execution/ExecutionHelper", "showOutput"));
        }
        if (output == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "output", "com/intellij/execution/ExecutionHelper", "showOutput"));
        }
        if (tabDisplayName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tabDisplayName", "com/intellij/execution/ExecutionHelper", "showOutput"));
        }
        final String stdout = output.getStdout();
        final String stderr = output.getStderr();
        if (ApplicationManager.getApplication().isUnitTestMode() && !stdout.isEmpty() && !stderr.isEmpty()) {
            throw new RuntimeException("STDOUT:\n" + stdout + "\nSTDERR:\n" + stderr);
        }
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                String[] stderrLines;
                String[] stdoutLines;
                if (myProject.isDisposed()) {
                    return;
                }
                String stdOutTitle = "[Stdout]:";
                String stderrTitle = "[Stderr]:";
                ErrorViewPanel errorTreeView = new ErrorViewPanel(myProject);
                try {
                    ExecutionHelper.openMessagesView(errorTreeView, myProject, tabDisplayName);
                }
                catch (NullPointerException e) {
                    Messages.showErrorDialog((String)("[Stdout]:\n" + (stdout != null ? stdout : "<empty>") + "\n" + "[Stderr]:" + "\n" + (stderr != null ? stderr : "<empty>")), (String)"Process Output");
                    return;
                }
                if (!StringUtil.isEmpty((String)stdout) && (stdoutLines = StringUtil.splitByLines((String)stdout)).length > 0) {
                    if (StringUtil.isEmpty((String)stderr)) {
                        errorTreeView.addMessage(1, stdoutLines, file, -1, -1, null);
                    } else if (file == null) {
                        errorTreeView.addMessage(1, stdoutLines, "[Stdout]:", NonNavigatable.INSTANCE, null, null, null);
                    } else {
                        errorTreeView.addMessage(1, new String[]{"[Stdout]:"}, file, -1, -1, null);
                        errorTreeView.addMessage(1, new String[]{""}, file, -1, -1, null);
                        errorTreeView.addMessage(1, stdoutLines, file, -1, -1, null);
                    }
                }
                if (!StringUtil.isEmpty((String)stderr) && (stderrLines = StringUtil.splitByLines((String)stderr)).length > 0) {
                    if (file == null) {
                        errorTreeView.addMessage(1, stderrLines, "[Stderr]:", NonNavigatable.INSTANCE, null, null, null);
                    } else {
                        errorTreeView.addMessage(1, new String[]{"[Stderr]:"}, file, -1, -1, null);
                        errorTreeView.addMessage(1, ArrayUtil.EMPTY_STRING_ARRAY, file, -1, -1, null);
                        errorTreeView.addMessage(1, stderrLines, file, -1, -1, null);
                    }
                }
                errorTreeView.addMessage(1, new String[]{"Process finished with exit code " + output.getExitCode()}, null, -1, -1, null);
                if (activateWindow) {
                    ToolWindowManager.getInstance((Project)myProject).getToolWindow(ToolWindowId.MESSAGES_WINDOW).activate(null);
                }
            }
        });
    }

    private static void openMessagesView(final @NotNull ErrorViewPanel errorTreeView, final @NotNull Project myProject, final @NotNull String tabDisplayName) {
        if (errorTreeView == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorTreeView", "com/intellij/execution/ExecutionHelper", "openMessagesView"));
        }
        if (myProject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "myProject", "com/intellij/execution/ExecutionHelper", "openMessagesView"));
        }
        if (tabDisplayName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tabDisplayName", "com/intellij/execution/ExecutionHelper", "openMessagesView"));
        }
        CommandProcessor commandProcessor = CommandProcessor.getInstance();
        commandProcessor.executeCommand(myProject, new Runnable(){

            @Override
            public void run() {
                MessageView messageView = (MessageView)ServiceManager.getService((Project)myProject, MessageView.class);
                Content content = ContentFactory.SERVICE.getInstance().createContent((JComponent)errorTreeView, tabDisplayName, true);
                messageView.getContentManager().addContent(content);
                Disposer.register((Disposable)content, (Disposable)errorTreeView);
                messageView.getContentManager().setSelectedContent(content);
                ExecutionHelper.removeContents(content, myProject, tabDisplayName);
            }
        }, "Open message view", null);
    }

    private static void removeContents(@Nullable Content notToRemove, @NotNull Project myProject, @NotNull String tabDisplayName) {
        Content[] contents;
        if (myProject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "myProject", "com/intellij/execution/ExecutionHelper", "removeContents"));
        }
        if (tabDisplayName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tabDisplayName", "com/intellij/execution/ExecutionHelper", "removeContents"));
        }
        MessageView messageView = (MessageView)ServiceManager.getService((Project)myProject, MessageView.class);
        for (Content content : contents = messageView.getContentManager().getContents()) {
            ErrorTreeView listErrorView;
            LOG.assertTrue(content != null);
            if (content.isPinned() || !tabDisplayName.equals(content.getDisplayName()) || content == notToRemove || (listErrorView = (ErrorTreeView)content.getComponent()) == null || !messageView.getContentManager().removeContent(content, true)) continue;
            content.release();
        }
    }

    public static Collection<RunContentDescriptor> findRunningConsoleByTitle(Project project, final @NotNull NotNullFunction<String, Boolean> titleMatcher) {
        if (titleMatcher == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "titleMatcher", "com/intellij/execution/ExecutionHelper", "findRunningConsoleByTitle"));
        }
        return ExecutionHelper.findRunningConsole(project, new NotNullFunction<RunContentDescriptor, Boolean>(){

            @NotNull
            public Boolean fun(RunContentDescriptor selectedContent) {
                Boolean bl = (Boolean)titleMatcher.fun((Object)selectedContent.getDisplayName());
                if (bl == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/ExecutionHelper$4", "fun"));
                }
                return bl;
            }
        });
    }

    public static Collection<RunContentDescriptor> findRunningConsole(@NotNull Project project, @NotNull NotNullFunction<RunContentDescriptor, Boolean> descriptorMatcher) {
        ToolWindow toolWindow;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/ExecutionHelper", "findRunningConsole"));
        }
        if (descriptorMatcher == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptorMatcher", "com/intellij/execution/ExecutionHelper", "findRunningConsole"));
        }
        RunContentManager contentManager = ExecutionManager.getInstance((Project)project).getContentManager();
        RunContentDescriptor selectedContent = contentManager.getSelectedContent();
        if (selectedContent != null && (toolWindow = contentManager.getToolWindowByDescriptor(selectedContent)) != null && toolWindow.isVisible() && ((Boolean)descriptorMatcher.fun((Object)selectedContent)).booleanValue()) {
            return Collections.singletonList(selectedContent);
        }
        ArrayList result2 = ContainerUtil.newArrayList();
        for (RunContentDescriptor runContentDescriptor : contentManager.getAllDescriptors()) {
            if (!((Boolean)descriptorMatcher.fun((Object)runContentDescriptor)).booleanValue()) continue;
            result2.add(runContentDescriptor);
        }
        return result2;
    }

    public static List<RunContentDescriptor> collectConsolesByDisplayName(@NotNull Project project, @NotNull NotNullFunction<String, Boolean> titleMatcher) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/ExecutionHelper", "collectConsolesByDisplayName"));
        }
        if (titleMatcher == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "titleMatcher", "com/intellij/execution/ExecutionHelper", "collectConsolesByDisplayName"));
        }
        SmartList result2 = new SmartList();
        for (RunContentDescriptor runContentDescriptor : ExecutionManager.getInstance((Project)project).getContentManager().getAllDescriptors()) {
            if (!((Boolean)titleMatcher.fun((Object)runContentDescriptor.getDisplayName())).booleanValue()) continue;
            result2.add(runContentDescriptor);
        }
        return result2;
    }

    public static void selectContentDescriptor(@NotNull DataContext dataContext, @NotNull Project project, @NotNull Collection<RunContentDescriptor> consoles, String selectDialogTitle, Consumer<RunContentDescriptor> descriptorConsumer) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/execution/ExecutionHelper", "selectContentDescriptor"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/ExecutionHelper", "selectContentDescriptor"));
        }
        if (consoles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consoles", "com/intellij/execution/ExecutionHelper", "selectContentDescriptor"));
        }
        if (consoles.size() == 1) {
            RunContentDescriptor descriptor = consoles.iterator().next();
            descriptorConsumer.consume((Object)descriptor);
            ExecutionHelper.descriptorToFront(project, descriptor);
        } else if (consoles.size() > 1) {
            JBList list = new JBList(consoles);
            final Icon icon = DefaultRunExecutor.getRunExecutorInstance().getIcon();
            list.setCellRenderer(new ListCellRendererWrapper<RunContentDescriptor>(){

                public void customize(JList list, RunContentDescriptor value, int index, boolean selected, boolean hasFocus) {
                    this.setText(value.getDisplayName());
                    this.setIcon(icon);
                }
            });
            PopupChooserBuilder builder = new PopupChooserBuilder((JList)list);
            builder.setTitle(selectDialogTitle);
            builder.setItemChoosenCallback(new Runnable((JList)list, descriptorConsumer, project){
                final /* synthetic */ JList val$list;
                final /* synthetic */ Consumer val$descriptorConsumer;
                final /* synthetic */ Project val$project;
                {
                    this.val$list = jList;
                    this.val$descriptorConsumer = consumer;
                    this.val$project = project;
                }

                @Override
                public void run() {
                    Object selectedValue = this.val$list.getSelectedValue();
                    if (selectedValue instanceof RunContentDescriptor) {
                        RunContentDescriptor descriptor = (RunContentDescriptor)selectedValue;
                        this.val$descriptorConsumer.consume((Object)descriptor);
                        ExecutionHelper.descriptorToFront(this.val$project, descriptor);
                    }
                }
            }).createPopup().showInBestPositionFor(dataContext);
        }
    }

    private static void descriptorToFront(final @NotNull Project project, final @NotNull RunContentDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/ExecutionHelper", "descriptorToFront"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/execution/ExecutionHelper", "descriptorToFront"));
        }
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                ToolWindow toolWindow = ExecutionManager.getInstance((Project)project).getContentManager().getToolWindowByDescriptor(descriptor);
                if (toolWindow != null) {
                    toolWindow.show(null);
                    toolWindow.getContentManager().setSelectedContent(descriptor.getAttachedContent());
                }
            }
        }, project.getDisposed());
    }

    public static void executeExternalProcess(@Nullable Project myProject, @NotNull ProcessHandler processHandler2, @NotNull ExecutionMode mode, @NotNull GeneralCommandLine cmdline) {
        if (processHandler2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processHandler", "com/intellij/execution/ExecutionHelper", "executeExternalProcess"));
        }
        if (mode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mode", "com/intellij/execution/ExecutionHelper", "executeExternalProcess"));
        }
        if (cmdline == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cmdline", "com/intellij/execution/ExecutionHelper", "executeExternalProcess"));
        }
        ExecutionHelper.executeExternalProcess(myProject, processHandler2, mode, cmdline.getCommandLineString());
    }

    public static void executeExternalProcess(@Nullable Project myProject, final @NotNull ProcessHandler processHandler2, @NotNull ExecutionMode mode, @NotNull String presentableCmdline) {
        String title;
        if (processHandler2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processHandler", "com/intellij/execution/ExecutionHelper", "executeExternalProcess"));
        }
        if (mode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mode", "com/intellij/execution/ExecutionHelper", "executeExternalProcess"));
        }
        if (presentableCmdline == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentableCmdline", "com/intellij/execution/ExecutionHelper", "executeExternalProcess"));
        }
        String string = title = mode.getTitle() != null ? mode.getTitle() : "Please wait...";
        final Runnable process = mode.cancelable() ? ExecutionHelper.createCancelableExecutionProcess(processHandler2, mode.shouldCancelFun()) : (mode.getTimeout() <= 0 ? new Runnable(){

            @Override
            public void run() {
                processHandler2.waitFor();
            }
        } : ExecutionHelper.createTimeLimitedExecutionProcess(processHandler2, mode, presentableCmdline));
        if (mode.withModalProgress()) {
            ProgressManager.getInstance().runProcessWithProgressSynchronously(process, title, mode.cancelable(), myProject, mode.getProgressParentComponent());
        } else if (mode.inBackGround()) {
            Task.Backgroundable task = new Task.Backgroundable(myProject, title, mode.cancelable()){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/execution/ExecutionHelper$9", "run"));
                    }
                    process.run();
                }
            };
            ProgressManager.getInstance().run((Task)task);
        } else {
            String title2 = mode.getTitle2();
            ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
            if (indicator != null && title2 != null) {
                indicator.setText2(title2);
            }
            process.run();
        }
    }

    private static Runnable createCancelableExecutionProcess(final ProcessHandler processHandler2, final Function<Object, Boolean> cancelableFun) {
        return new Runnable(){
            private ProgressIndicator myProgressIndicator;
            private final Semaphore mySemaphore = new Semaphore();
            private final Runnable myWaitThread = new Runnable(){

                @Override
                public void run() {
                    try {
                        processHandler2.waitFor();
                    }
                    finally {
                        mySemaphore.up();
                    }
                }
            };
            private final Runnable myCancelListener = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    while (true) {
                        if (myProgressIndicator != null && (myProgressIndicator.isCanceled() || !myProgressIndicator.isRunning()) || cancelableFun != null && ((Boolean)cancelableFun.fun(null)).booleanValue() || processHandler2.isProcessTerminated()) {
                            if (processHandler2.isProcessTerminated()) break;
                            try {
                                processHandler2.destroyProcess();
                                break;
                            }
                            finally {
                                mySemaphore.up();
                            }
                        }
                        try {
                            2 var1_1 = this;
                            synchronized (var1_1) {
                                this.wait(1000L);
                                continue;
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            continue;
                        }
                        break;
                    }
                }
            };

            @Override
            public void run() {
                this.myProgressIndicator = ProgressManager.getInstance().getProgressIndicator();
                if (this.myProgressIndicator != null && StringUtil.isEmpty((String)this.myProgressIndicator.getText())) {
                    this.myProgressIndicator.setText("Please wait...");
                }
                LOG.assertTrue(this.myProgressIndicator != null || cancelableFun != null, (Object)"Cancelable process must have an opportunity to be canceled!");
                this.mySemaphore.down();
                ApplicationManager.getApplication().executeOnPooledThread(this.myWaitThread);
                ApplicationManager.getApplication().executeOnPooledThread(this.myCancelListener);
                this.mySemaphore.waitFor();
            }
        };
    }

    private static Runnable createTimeLimitedExecutionProcess(final ProcessHandler processHandler2, final ExecutionMode mode, final @NotNull String presentableCmdline) {
        if (presentableCmdline == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentableCmdline", "com/intellij/execution/ExecutionHelper", "createTimeLimitedExecutionProcess"));
        }
        return new Runnable(){
            private final Semaphore mySemaphore = new Semaphore();
            private final Runnable myProcessThread = new Runnable(){

                @Override
                public void run() {
                    try {
                        boolean finished = processHandler2.waitFor((long)(1000 * mode.getTimeout()));
                        if (!finished) {
                            mode.getTimeoutCallback().consume((Object)mode, (Object)presentableCmdline);
                            processHandler2.destroyProcess();
                        }
                    }
                    finally {
                        mySemaphore.up();
                    }
                }
            };

            @Override
            public void run() {
                this.mySemaphore.down();
                ApplicationManager.getApplication().executeOnPooledThread(this.myProcessThread);
                this.mySemaphore.waitFor();
            }
        };
    }

    public static class ErrorViewPanel
    extends NewErrorTreeViewPanel {
        public ErrorViewPanel(Project project) {
            super(project, "reference.toolWindows.messages");
        }

        @Override
        protected boolean canHideWarnings() {
            return false;
        }
    }
}

