/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.impl;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.RunnerRegistry;
import com.intellij.execution.configurations.JavaCommandLine;
import com.intellij.execution.configurations.JavaCommandLineState;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.ModuleRunProfile;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.process.CapturingProcessAdapter;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.JavaPatchableProgramRunner;
import com.intellij.execution.runners.ProcessProxy;
import com.intellij.execution.runners.ProcessProxyFactory;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.runners.RunConfigurationWithSuppressedDefaultRunAction;
import com.intellij.execution.runners.RunContentBuilder;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.unscramble.AnalyzeStacktraceUtil;
import com.intellij.unscramble.ThreadDumpConsoleFactory;
import com.intellij.unscramble.ThreadDumpParser;
import com.intellij.unscramble.ThreadState;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.text.DateFormatUtil;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class DefaultJavaProgramRunner
extends JavaPatchableProgramRunner {
    private static final String ourWiseThreadDumpProperty = "idea.java.run.wise.thread.dump";
    @NonNls
    public static final String DEFAULT_JAVA_RUNNER_ID = "Run";

    public boolean canRun(@NotNull String executorId, @NotNull RunProfile profile) {
        if (executorId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executorId", "com/intellij/execution/impl/DefaultJavaProgramRunner", "canRun"));
        }
        if (profile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "profile", "com/intellij/execution/impl/DefaultJavaProgramRunner", "canRun"));
        }
        return executorId.equals(DefaultRunExecutor.EXECUTOR_ID) && profile instanceof ModuleRunProfile && !(profile instanceof RunConfigurationWithSuppressedDefaultRunAction);
    }

    public void patch(JavaParameters javaParameters, RunnerSettings settings, RunProfile runProfile, boolean beforeExecution) throws ExecutionException {
        DefaultJavaProgramRunner.runCustomPatchers((JavaParameters)javaParameters, (Executor)DefaultRunExecutor.getRunExecutorInstance(), (RunProfile)runProfile);
    }

    protected RunContentDescriptor doExecute(@NotNull RunProfileState state, @NotNull ExecutionEnvironment env) throws ExecutionException {
        ExecutionResult executionResult;
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/execution/impl/DefaultJavaProgramRunner", "doExecute"));
        }
        if (env == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "env", "com/intellij/execution/impl/DefaultJavaProgramRunner", "doExecute"));
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        boolean shouldAddDefaultActions = true;
        if (state instanceof JavaCommandLine) {
            JavaParameters parameters = ((JavaCommandLine)state).getJavaParameters();
            this.patch(parameters, env.getRunnerSettings(), env.getRunProfile(), true);
            ProcessProxy proxy = ProcessProxyFactory.getInstance().createCommandLineProxy((JavaCommandLine)state);
            executionResult = state.execute(env.getExecutor(), (ProgramRunner)this);
            if (proxy != null && executionResult != null) {
                proxy.attach(executionResult.getProcessHandler());
            }
            if (state instanceof JavaCommandLineState && !((JavaCommandLineState)state).shouldAddJavaProgramRunnerActions()) {
                shouldAddDefaultActions = false;
            }
        } else {
            executionResult = state.execute(env.getExecutor(), (ProgramRunner)this);
        }
        if (executionResult == null) {
            return null;
        }
        this.onProcessStarted(env.getRunnerSettings(), executionResult);
        RunContentBuilder contentBuilder = new RunContentBuilder(executionResult, env);
        if (shouldAddDefaultActions) {
            DefaultJavaProgramRunner.addDefaultActions(contentBuilder, executionResult);
        }
        return contentBuilder.showRunContent(env.getContentToReuse());
    }

    private static void addDefaultActions(@NotNull RunContentBuilder contentBuilder, @NotNull ExecutionResult executionResult) {
        if (contentBuilder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentBuilder", "com/intellij/execution/impl/DefaultJavaProgramRunner", "addDefaultActions"));
        }
        if (executionResult == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executionResult", "com/intellij/execution/impl/DefaultJavaProgramRunner", "addDefaultActions"));
        }
        ExecutionConsole executionConsole = executionResult.getExecutionConsole();
        final JComponent consoleComponent = executionConsole != null ? executionConsole.getComponent() : null;
        final ControlBreakAction controlBreakAction = new ControlBreakAction(executionResult.getProcessHandler());
        if (consoleComponent != null) {
            controlBreakAction.registerCustomShortcutSet(controlBreakAction.getShortcutSet(), consoleComponent);
            final ProcessHandler processHandler2 = executionResult.getProcessHandler();
            assert (processHandler2 != null) : executionResult;
            processHandler2.addProcessListener((ProcessListener)new ProcessAdapter(){

                public void processTerminated(ProcessEvent event) {
                    processHandler2.removeProcessListener((ProcessListener)this);
                    controlBreakAction.unregisterCustomShortcutSet(consoleComponent);
                }
            });
        }
        contentBuilder.addAction(controlBreakAction);
        contentBuilder.addAction(new SoftExitAction(executionResult.getProcessHandler()));
    }

    @NotNull
    public String getRunnerId() {
        if (DEFAULT_JAVA_RUNNER_ID == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/impl/DefaultJavaProgramRunner", "getRunnerId"));
        }
        return DEFAULT_JAVA_RUNNER_ID;
    }

    public static ProgramRunner getInstance() {
        return RunnerRegistry.getInstance().findRunnerById(DEFAULT_JAVA_RUNNER_ID);
    }

    protected static class SoftExitAction
    extends LauncherBasedAction {
        public SoftExitAction(ProcessHandler processHandler2) {
            super(ExecutionBundle.message((String)"run.configuration.exit.action.name", (Object[])new Object[0]), null, AllIcons.Actions.Exit, processHandler2);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/execution/impl/DefaultJavaProgramRunner$SoftExitAction", "actionPerformed"));
            }
            ProcessProxy proxy = ProcessProxyFactory.getInstance().getAttachedProxy(this.myProcessHandler);
            if (proxy != null) {
                proxy.sendStop();
            }
        }
    }

    private static class WiseDumpThreadsListener {
        private final Project myProject;
        private final ProcessHandler myProcessHandler;
        private final CapturingProcessAdapter myListener;

        public WiseDumpThreadsListener(Project project, ProcessHandler processHandler2) {
            this.myProject = project;
            this.myProcessHandler = processHandler2;
            this.myListener = new CapturingProcessAdapter();
            this.myProcessHandler.addProcessListener((ProcessListener)this.myListener);
        }

        public void after() {
            if (this.myProject == null) {
                this.myProcessHandler.removeProcessListener((ProcessListener)this.myListener);
                return;
            }
            ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

                @Override
                public void run() {
                    String stdout;
                    if (WiseDumpThreadsListener.this.myProcessHandler.isProcessTerminated() || WiseDumpThreadsListener.this.myProcessHandler.isProcessTerminating()) {
                        return;
                    }
                    List<ThreadState> threadStates = null;
                    long start = System.currentTimeMillis();
                    while (System.currentTimeMillis() - start < 1000L && ((threadStates = ThreadDumpParser.parse(stdout = WiseDumpThreadsListener.this.myListener.getOutput().getStdout())) == null || threadStates.isEmpty())) {
                        TimeoutUtil.sleep((long)50L);
                        threadStates = null;
                    }
                    WiseDumpThreadsListener.this.myProcessHandler.removeProcessListener((ProcessListener)WiseDumpThreadsListener.this.myListener);
                    if (threadStates != null && !threadStates.isEmpty()) {
                        WiseDumpThreadsListener.this.showThreadDump(WiseDumpThreadsListener.this.myListener.getOutput().getStdout(), threadStates);
                    }
                }
            });
        }

        private void showThreadDump(final String out, final List<ThreadState> threadStates) {
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    AnalyzeStacktraceUtil.addConsole(WiseDumpThreadsListener.this.myProject, threadStates.size() > 1 ? new ThreadDumpConsoleFactory(WiseDumpThreadsListener.this.myProject, threadStates) : null, "<Stacktrace> " + DateFormatUtil.formatDateTime((long)System.currentTimeMillis()), out);
                }
            }, ModalityState.NON_MODAL);
        }
    }

    protected static class ControlBreakAction
    extends LauncherBasedAction {
        public ControlBreakAction(ProcessHandler processHandler2) {
            super(ExecutionBundle.message((String)"run.configuration.dump.threads.action.name", (Object[])new Object[0]), null, AllIcons.Actions.Dump, processHandler2);
            this.setShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(3, 128)));
        }

        @Override
        protected boolean isVisible() {
            return super.isVisible() && ProcessProxyFactory.getInstance().isBreakGenLibraryAvailable();
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/execution/impl/DefaultJavaProgramRunner$ControlBreakAction", "actionPerformed"));
            }
            ProcessProxy proxy = ProcessProxyFactory.getInstance().getAttachedProxy(this.myProcessHandler);
            if (proxy != null) {
                WiseDumpThreadsListener wiseListener = Boolean.TRUE.equals(Boolean.getBoolean(DefaultJavaProgramRunner.ourWiseThreadDumpProperty)) ? new WiseDumpThreadsListener((Project)CommonDataKeys.PROJECT.getData(e.getDataContext()), this.myProcessHandler) : null;
                proxy.sendBreak();
                if (wiseListener != null) {
                    wiseListener.after();
                }
            }
        }
    }

    private static abstract class LauncherBasedAction
    extends AnAction {
        protected final ProcessHandler myProcessHandler;

        protected LauncherBasedAction(String text, String description, Icon icon, ProcessHandler processHandler2) {
            super(text, description, icon);
            this.myProcessHandler = processHandler2;
        }

        public void update(@NotNull AnActionEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/execution/impl/DefaultJavaProgramRunner$LauncherBasedAction", "update"));
            }
            Presentation presentation = event.getPresentation();
            if (!this.isVisible()) {
                presentation.setVisible(false);
                presentation.setEnabled(false);
                return;
            }
            presentation.setVisible(true);
            presentation.setEnabled(!this.myProcessHandler.isProcessTerminated());
        }

        protected boolean isVisible() {
            return ProcessProxyFactory.getInstance().getAttachedProxy(this.myProcessHandler) != null;
        }
    }
}

