/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.startup;

import com.intellij.execution.Executor;
import com.intellij.execution.ProgramRunnerUtil;
import com.intellij.execution.RunManagerAdapter;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.RunnerRegistry;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.execution.startup.ProjectStartupTaskManager;
import com.intellij.ide.startup.StartupManagerEx;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.ui.MessageType;
import com.intellij.util.Alarm;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class ProjectStartupRunner
implements StartupActivity {
    public static final int DELAY_MILLIS = 200;

    public void runActivity(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/startup/ProjectStartupRunner", "runActivity"));
        }
        final ProjectStartupTaskManager projectStartupTaskManager = ProjectStartupTaskManager.getInstance(project);
        if (projectStartupTaskManager.isEmpty()) {
            return;
        }
        RunManagerImpl.getInstanceImpl(project).addRunManagerListener(new RunManagerAdapter(){

            @Override
            public void runConfigurationRemoved(@NotNull RunnerAndConfigurationSettings settings) {
                if (settings == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/execution/startup/ProjectStartupRunner$1", "runConfigurationRemoved"));
                }
                projectStartupTaskManager.delete(settings.getUniqueID());
            }

            @Override
            public void runConfigurationChanged(@NotNull RunnerAndConfigurationSettings settings, String existingId) {
                if (settings == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/execution/startup/ProjectStartupRunner$1", "runConfigurationChanged"));
                }
                if (existingId != null) {
                    projectStartupTaskManager.rename(existingId, settings);
                }
                projectStartupTaskManager.checkOnChange(settings);
            }

            @Override
            public void runConfigurationAdded(@NotNull RunnerAndConfigurationSettings settings) {
                if (settings == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/execution/startup/ProjectStartupRunner$1", "runConfigurationAdded"));
                }
                projectStartupTaskManager.checkOnChange(settings);
            }
        });
        Alarm alarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)project);
        alarm.addRequest(ProjectStartupRunner.createRequest(project, alarm), 200);
    }

    private static Runnable createRequest(final Project project, final Alarm alarm) {
        return new Runnable(){

            @Override
            public void run() {
                if (!((StartupManagerEx)StartupManager.getInstance((Project)project)).postStartupActivityPassed()) {
                    alarm.addRequest(ProjectStartupRunner.createRequest(project, alarm), 200);
                } else {
                    ProjectStartupRunner.runActivities(project);
                }
            }
        };
    }

    private static void runActivities(final Project project) {
        ProjectStartupTaskManager projectStartupTaskManager = ProjectStartupTaskManager.getInstance(project);
        ArrayList<RunnerAndConfigurationSettings> configurations = new ArrayList<RunnerAndConfigurationSettings>(projectStartupTaskManager.getLocalConfigurations());
        configurations.addAll(projectStartupTaskManager.getSharedConfigurations());
        final Executor executor = DefaultRunExecutor.getRunExecutorInstance();
        for (final RunnerAndConfigurationSettings configuration : configurations) {
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (!ProjectStartupRunner.canBeRun(configuration)) {
                        ProjectStartupTaskManager.NOTIFICATION_GROUP.createNotification("Project Startup Tasks:  Run Configuration '" + configuration.getName() + "' can not be started with 'Run' action.", MessageType.ERROR).notify(project);
                        return;
                    }
                    ProgramRunnerUtil.executeConfiguration(project, configuration, executor);
                    ProjectStartupTaskManager.NOTIFICATION_GROUP.createNotification("Project Startup Tasks:  started '" + configuration.getName() + "'", MessageType.INFO).notify(project);
                }
            }, ModalityState.any());
        }
    }

    public static boolean canBeRun(@NotNull RunnerAndConfigurationSettings configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/execution/startup/ProjectStartupRunner", "canBeRun"));
        }
        return RunnerRegistry.getInstance().getRunner(DefaultRunExecutor.EXECUTOR_ID, (RunProfile)configuration.getConfiguration()) != null;
    }
}

