/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.sm.runner.history.actions;

import com.intellij.execution.DefaultExecutionTarget;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.ExecutionTargetProvider;
import com.intellij.execution.Executor;
import com.intellij.execution.ExecutorRegistry;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.RunnerRegistry;
import com.intellij.execution.TestStateStorage;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.ConfigurationTypeUtil;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.execution.impl.RunnerAndConfigurationSettingsImpl;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionEnvironmentBuilder;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.testframework.sm.runner.SMRunnerConsolePropertiesProvider;
import com.intellij.execution.testframework.sm.runner.SMTRunnerConsoleProperties;
import com.intellij.execution.testframework.sm.runner.history.ImportedTestRunnableState;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Arrays;
import java.util.Comparator;
import javax.swing.Icon;
import org.jdom.Document;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractImportTestsAction
extends AnAction {
    private static final Logger LOG = Logger.getInstance((String)("#" + AbstractImportTestsAction.class.getName()));
    public static final String TEST_HISTORY_SIZE = "test_history_size";
    private SMTRunnerConsoleProperties myProperties;

    public AbstractImportTestsAction(@Nullable String text, @Nullable String description, @Nullable Icon icon) {
        super(text, description, icon);
    }

    public AbstractImportTestsAction(SMTRunnerConsoleProperties properties, @Nullable String text, @Nullable String description, @Nullable Icon icon) {
        this(text, description, icon);
        this.myProperties = properties;
    }

    public static int getHistorySize() {
        int historySize;
        try {
            historySize = Math.max(0, Integer.parseInt(PropertiesComponent.getInstance().getValue(TEST_HISTORY_SIZE, "10")));
        }
        catch (NumberFormatException e) {
            historySize = 10;
        }
        return historySize;
    }

    public void update(AnActionEvent e) {
        e.getPresentation().setEnabledAndVisible(e.getProject() != null);
    }

    @Nullable
    public abstract VirtualFile getFile(@NotNull Project var1);

    public void actionPerformed(AnActionEvent e) {
        Project project = e.getProject();
        LOG.assertTrue(project != null);
        VirtualFile file = this.getFile(project);
        if (file != null) {
            try {
                RunConfiguration initialConfiguration;
                ProgramRunner runner;
                ImportRunProfile profile = new ImportRunProfile(file, project);
                SMTRunnerConsoleProperties properties = profile.getProperties();
                if (properties == null) {
                    properties = this.myProperties;
                    LOG.info("Failed to detect test framework in " + file.getPath() + "; use " + (properties != null ? properties.getTestFrameworkName() + " from toolbar" : "no properties"));
                }
                Executor executor = properties != null ? properties.getExecutor() : ExecutorRegistry.getInstance().getExecutorById(DefaultRunExecutor.EXECUTOR_ID);
                ExecutionEnvironmentBuilder builder = ExecutionEnvironmentBuilder.create((Project)project, (Executor)executor, (RunProfile)profile);
                ExecutionTarget target = profile.getTarget();
                if (target != null) {
                    builder = builder.target(target);
                }
                ProgramRunner programRunner = runner = (initialConfiguration = profile.getInitialConfiguration()) != null ? RunnerRegistry.getInstance().getRunner(executor.getId(), (RunProfile)initialConfiguration) : null;
                if (runner != null) {
                    builder = builder.runner(runner);
                }
                builder.buildAndExecute();
            }
            catch (ExecutionException e1) {
                Messages.showErrorDialog((Project)project, (String)e1.getMessage(), (String)"Import Failed");
            }
        }
    }

    public static void adjustHistory(Project project) {
        int historySize = AbstractImportTestsAction.getHistorySize();
        File[] files = TestStateStorage.getTestHistoryRoot(project).listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".xml");
            }
        });
        if (files != null && files.length >= historySize + 1) {
            Arrays.sort(files, new Comparator<File>(){

                @Override
                public int compare(File o1, File o2) {
                    long l2;
                    long l1 = o1.lastModified();
                    if (l1 == (l2 = o2.lastModified())) {
                        return FileUtil.compareFiles((File)o1, (File)o2);
                    }
                    return l1 < l2 ? -1 : 1;
                }
            });
            FileUtil.delete((File)files[0]);
        }
    }

    public static class ImportRunProfile
    implements RunProfile {
        private final VirtualFile myFile;
        private final Project myProject;
        private RunConfiguration myConfiguration;
        private boolean myImported;
        private SMTRunnerConsoleProperties myProperties;
        private String myTargetId;

        public ImportRunProfile(VirtualFile file, Project project) {
            this.myFile = file;
            this.myProject = project;
            try {
                Document document = JDOMUtil.loadDocument((File)VfsUtilCore.virtualToIoFile((VirtualFile)this.myFile));
                Element config = document.getRootElement().getChild("config");
                if (config != null) {
                    ConfigurationType configurationType;
                    String configTypeId = config.getAttributeValue("configId");
                    if (configTypeId != null && (configurationType = ConfigurationTypeUtil.findConfigurationType((String)configTypeId)) != null) {
                        this.myConfiguration = configurationType.getConfigurationFactories()[0].createTemplateConfiguration(project);
                        this.myConfiguration.setName(config.getAttributeValue("name"));
                        this.myConfiguration.readExternal(config);
                        Executor executor = ExecutorRegistry.getInstance().getExecutorById(DefaultRunExecutor.EXECUTOR_ID);
                        if (executor != null && this.myConfiguration instanceof SMRunnerConsolePropertiesProvider) {
                            this.myProperties = ((SMRunnerConsolePropertiesProvider)this.myConfiguration).createTestConsoleProperties(executor);
                        }
                    }
                    this.myTargetId = config.getAttributeValue("target");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public ExecutionTarget getTarget() {
            if (this.myTargetId != null) {
                if (DefaultExecutionTarget.INSTANCE.getId().equals(this.myTargetId)) {
                    return DefaultExecutionTarget.INSTANCE;
                }
                RunnerAndConfigurationSettingsImpl settings = new RunnerAndConfigurationSettingsImpl(RunManagerImpl.getInstanceImpl(this.myProject), this.myConfiguration, false);
                for (ExecutionTargetProvider provider : (ExecutionTargetProvider[])Extensions.getExtensions((ExtensionPointName)ExecutionTargetProvider.EXTENSION_NAME)) {
                    for (ExecutionTarget target : provider.getTargets(this.myProject, (RunnerAndConfigurationSettings)settings)) {
                        if (!this.myTargetId.equals(target.getId())) continue;
                        return target;
                    }
                }
                return null;
            }
            return DefaultExecutionTarget.INSTANCE;
        }

        @Nullable
        public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment environment) throws ExecutionException {
            if (executor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/intellij/execution/testframework/sm/runner/history/actions/AbstractImportTestsAction$ImportRunProfile", "getState"));
            }
            if (environment == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "environment", "com/intellij/execution/testframework/sm/runner/history/actions/AbstractImportTestsAction$ImportRunProfile", "getState"));
            }
            if (!this.myImported) {
                this.myImported = true;
                return new ImportedTestRunnableState(this, VfsUtilCore.virtualToIoFile((VirtualFile)this.myFile));
            }
            if (this.myConfiguration != null) {
                try {
                    return this.myConfiguration.getState(executor, environment);
                }
                catch (Throwable e) {
                    if (this.myTargetId != null && this.getTarget() == null) {
                        throw new ExecutionException("The target " + this.myTargetId + " does not exist");
                    }
                    LOG.info(e);
                    throw new ExecutionException("Unable to run the configuration: settings are corrupted");
                }
            }
            throw new ExecutionException("Unable to run the configuration: failed to detect test framework");
        }

        public String getName() {
            return this.myImported && this.myConfiguration != null ? this.myConfiguration.getName() : this.myFile.getNameWithoutExtension();
        }

        @Nullable
        public Icon getIcon() {
            return this.myProperties != null ? this.myProperties.getConfiguration().getIcon() : null;
        }

        public SMTRunnerConsoleProperties getProperties() {
            return this.myProperties;
        }

        public RunConfiguration getInitialConfiguration() {
            return this.myConfiguration;
        }

        public Project getProject() {
            return this.myProject;
        }
    }
}

