/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.externalSystem;

import com.intellij.externalSystem.JavaProjectData;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.manage.AbstractProjectDataService;
import com.intellij.openapi.externalSystem.util.DisposeAwareProjectChange;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.roots.LanguageLevelProjectExtension;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.pom.java.LanguageLevel;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaProjectDataService
extends AbstractProjectDataService<JavaProjectData, Project> {
    @NotNull
    public Key<JavaProjectData> getTargetDataKey() {
        Key<JavaProjectData> key = JavaProjectData.KEY;
        if (key == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/externalSystem/JavaProjectDataService", "getTargetDataKey"));
        }
        return key;
    }

    public void importData(@NotNull Collection<DataNode<JavaProjectData>> toImport, @Nullable ProjectData projectData, @NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider) {
        Sdk newJdk;
        JavaSdkVersion currentVersion;
        if (toImport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toImport", "com/intellij/externalSystem/JavaProjectDataService", "importData"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/externalSystem/JavaProjectDataService", "importData"));
        }
        if (modelsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelsProvider", "com/intellij/externalSystem/JavaProjectDataService", "importData"));
        }
        if (toImport.isEmpty() || projectData == null) {
            return;
        }
        if (toImport.size() != 1) {
            throw new IllegalArgumentException(String.format("Expected to get a single project but got %d: %s", toImport.size(), toImport));
        }
        DataNode<JavaProjectData> javaProjectDataNode = toImport.iterator().next();
        DataNode projectDataNode = ExternalSystemApiUtil.findParent(javaProjectDataNode, (Key)ProjectKeys.PROJECT);
        assert (projectDataNode != null);
        if (!ExternalSystemApiUtil.isOneToOneMapping((Project)project, (DataNode)projectDataNode)) {
            return;
        }
        JavaProjectData javaProjectData = (JavaProjectData)((Object)javaProjectDataNode.getData());
        JavaSdkVersion version = javaProjectData.getJdkVersion();
        JavaSdk javaSdk = JavaSdk.getInstance();
        ProjectRootManager rootManager = ProjectRootManager.getInstance((Project)project);
        Sdk sdk = rootManager.getProjectSdk();
        if (sdk instanceof JavaSdk && ((currentVersion = javaSdk.getVersion(sdk)) == null || !currentVersion.isAtLeast(version)) && (newJdk = JavaProjectDataService.findJdk(version)) != null) {
            rootManager.setProjectSdk(sdk);
            LanguageLevel level = version.getMaxLanguageLevel();
            LanguageLevelProjectExtension ext = LanguageLevelProjectExtension.getInstance((Project)project);
            if (level.compareTo((Enum)ext.getLanguageLevel()) < 0) {
                ext.setLanguageLevel(level);
            }
        }
        this.setLanguageLevel(javaProjectData.getLanguageLevel(), project);
    }

    @Nullable
    private static Sdk findJdk(@NotNull JavaSdkVersion version) {
        if (version == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "com/intellij/externalSystem/JavaProjectDataService", "findJdk"));
        }
        JavaSdk javaSdk = JavaSdk.getInstance();
        List javaSdks = ProjectJdkTable.getInstance().getSdksOfType((SdkTypeId)javaSdk);
        Sdk candidate = null;
        for (Sdk sdk : javaSdks) {
            JavaSdkVersion v = javaSdk.getVersion(sdk);
            if (v == version) {
                return sdk;
            }
            if (candidate != null || v == null || !version.getMaxLanguageLevel().isAtLeast(version.getMaxLanguageLevel())) continue;
            candidate = sdk;
        }
        return candidate;
    }

    public void setLanguageLevel(final @NotNull LanguageLevel languageLevel, @NotNull Project project) {
        if (languageLevel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageLevel", "com/intellij/externalSystem/JavaProjectDataService", "setLanguageLevel"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/externalSystem/JavaProjectDataService", "setLanguageLevel"));
        }
        final LanguageLevelProjectExtension languageLevelExtension = LanguageLevelProjectExtension.getInstance((Project)project);
        if (languageLevelExtension.getLanguageLevel().isAtLeast(languageLevel)) {
            return;
        }
        ExternalSystemApiUtil.executeProjectChangeAction((DisposeAwareProjectChange)new DisposeAwareProjectChange((ComponentManager)project){

            public void execute() {
                languageLevelExtension.setLanguageLevel(languageLevel);
            }
        });
    }
}

