/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.preview.PreviewPanelProvider;
import com.intellij.openapi.preview.PreviewProviderId;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.usages.impl.UsageViewImpl;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UsagesPreviewPanelProvider
extends PreviewPanelProvider<Pair<UsageViewImpl, ? extends JTable>, Boolean> {
    public static final PreviewProviderId<Pair<UsageViewImpl, ? extends JTable>, Boolean> ID = PreviewProviderId.create("Usages");
    private JComponent myComponent;
    private Collection<UsageViewImpl> myViews = new ArrayList<UsageViewImpl>();

    public UsagesPreviewPanelProvider(Project project) {
        super(ID);
        this.myComponent = new JPanel(new BorderLayout()){

            @Override
            public String toString() {
                return "UsagesPreviewPanel";
            }
        };
    }

    public void dispose() {
        this.myComponent.removeAll();
        for (UsageViewImpl view : this.myViews) {
            Disposer.dispose((Disposable)view);
        }
    }

    @Override
    @NotNull
    protected JComponent getComponent() {
        JComponent jComponent = this.myComponent;
        if (jComponent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/UsagesPreviewPanelProvider", "getComponent"));
        }
        return jComponent;
    }

    @Override
    @NotNull
    protected String getTitle(@NotNull Pair<UsageViewImpl, ? extends JTable> content) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/find/UsagesPreviewPanelProvider", "getTitle"));
        }
        String string = ((UsageViewImpl)content.first).getPresentation().getTabText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/UsagesPreviewPanelProvider", "getTitle"));
        }
        return string;
    }

    @Override
    @Nullable
    protected Icon getIcon(@NotNull Pair<UsageViewImpl, ? extends JTable> content) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/find/UsagesPreviewPanelProvider", "getIcon"));
        }
        return AllIcons.Actions.Find;
    }

    @Override
    public float getMenuOrder() {
        return 2.0f;
    }

    @Override
    public void showInStandardPlace(@NotNull Pair<UsageViewImpl, ? extends JTable> content) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/find/UsagesPreviewPanelProvider", "showInStandardPlace"));
        }
    }

    @Override
    public boolean supportsStandardPlace() {
        return false;
    }

    @Override
    public boolean isModified(Pair<UsageViewImpl, ? extends JTable> content, boolean beforeReuse) {
        return beforeReuse;
    }

    @Override
    public void release(@NotNull Pair<UsageViewImpl, ? extends JTable> content) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/find/UsagesPreviewPanelProvider", "release"));
        }
        this.myViews.remove(content.first);
        Disposer.dispose((Disposable)((Disposable)content.first));
        this.myComponent.remove((Component)content.second);
    }

    @Override
    public boolean contentsAreEqual(@NotNull Pair<UsageViewImpl, ? extends JTable> content1, @NotNull Pair<UsageViewImpl, ? extends JTable> content2) {
        if (content1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content1", "com/intellij/find/UsagesPreviewPanelProvider", "contentsAreEqual"));
        }
        if (content2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content2", "com/intellij/find/UsagesPreviewPanelProvider", "contentsAreEqual"));
        }
        return ((UsageViewImpl)content1.getFirst()).getPresentation().equals((Object)((UsageViewImpl)content2.getFirst()).getPresentation());
    }

    @Override
    protected Boolean initComponent(Pair<UsageViewImpl, ? extends JTable> content, boolean requestFocus) {
        this.myComponent.removeAll();
        this.myComponent.add((Component)content.second);
        this.myViews.add((UsageViewImpl)content.first);
        return Boolean.TRUE;
    }
}

