/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.PasteProvider;
import com.intellij.ide.actions.CopyReferenceAction;
import com.intellij.ide.actions.QualifiedNameProvider;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.actions.PasteAction;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.Producer;
import java.awt.datatransfer.Transferable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PasteReferenceProvider
implements PasteProvider {
    public void performPaste(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/ide/actions/PasteReferenceProvider", "performPaste"));
        }
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        if (project == null || editor == null) {
            return;
        }
        String fqn = PasteReferenceProvider.getCopiedFqn(dataContext);
        QualifiedNameProvider theProvider = null;
        PsiElement element = null;
        for (QualifiedNameProvider provider : (QualifiedNameProvider[])Extensions.getExtensions(QualifiedNameProvider.EP_NAME)) {
            element = provider.qualifiedNameToElement(fqn, project);
            if (element == null) continue;
            theProvider = provider;
            break;
        }
        if (theProvider != null) {
            PasteReferenceProvider.insert(fqn, element, editor, theProvider);
        }
    }

    public boolean isPastePossible(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/ide/actions/PasteReferenceProvider", "isPastePossible"));
        }
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        return project != null && editor != null && PasteReferenceProvider.getCopiedFqn(dataContext) != null;
    }

    public boolean isPasteEnabled(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/ide/actions/PasteReferenceProvider", "isPasteEnabled"));
        }
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        String fqn = PasteReferenceProvider.getCopiedFqn(dataContext);
        if (project == null || fqn == null) {
            return false;
        }
        for (QualifiedNameProvider provider : (QualifiedNameProvider[])Extensions.getExtensions(QualifiedNameProvider.EP_NAME)) {
            if (provider.qualifiedNameToElement(fqn, project) == null) continue;
            return true;
        }
        return false;
    }

    private static void insert(final String fqn, final PsiElement element, final Editor editor, final QualifiedNameProvider provider) {
        final Project project = editor.getProject();
        if (project == null) {
            return;
        }
        final PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
        documentManager.commitDocument(editor.getDocument());
        PsiFile file = documentManager.getPsiFile(editor.getDocument());
        if (!FileModificationService.getInstance().prepareFileForWrite(file)) {
            return;
        }
        CommandProcessor.getInstance().executeCommand(project, new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        Document document = editor.getDocument();
                        documentManager.doPostponedOperationsAndUnblockDocument(document);
                        documentManager.commitDocument(document);
                        EditorModificationUtil.deleteSelectedText((Editor)editor);
                        provider.insertQualifiedName(fqn, element, editor, project);
                    }
                });
            }
        }, IdeBundle.message((String)"command.pasting.reference", (Object[])new Object[0]), null);
    }

    @Nullable
    private static String getCopiedFqn(DataContext context) {
        Producer producer = (Producer)PasteAction.TRANSFERABLE_PROVIDER.getData(context);
        if (producer != null) {
            Transferable transferable = (Transferable)producer.produce();
            if (transferable != null) {
                try {
                    return (String)transferable.getTransferData(CopyReferenceAction.ourFlavor);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return null;
        }
        return (String)CopyPasteManager.getInstance().getContents(CopyReferenceAction.ourFlavor);
    }
}

