/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.projectView.actions.MoveModulesToGroupAction;
import com.intellij.ide.projectView.actions.MoveModulesToSubGroupAction;
import com.intellij.ide.projectView.impl.ModuleGroup;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MoveModuleToGroup
extends ActionGroup {
    private final ModuleGroup myModuleGroup;

    public MoveModuleToGroup(ModuleGroup moduleGroup) {
        this.myModuleGroup = moduleGroup;
        this.setPopup(true);
    }

    public void update(AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        Module[] modules = (Module[])LangDataKeys.MODULE_CONTEXT_ARRAY.getData(dataContext);
        boolean active = project != null && modules != null && modules.length != 0;
        Presentation presentation = e.getPresentation();
        presentation.setVisible(active);
        presentation.setText(this.myModuleGroup.presentableText());
    }

    @NotNull
    public AnAction[] getChildren(@Nullable AnActionEvent e) {
        if (e == null) {
            if (EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/projectView/impl/MoveModuleToGroup", "getChildren"));
            }
            return EMPTY_ARRAY;
        }
        ArrayList<ModuleGroup> children2 = new ArrayList<ModuleGroup>(this.myModuleGroup.childGroups(e.getDataContext()));
        Collections.sort(children2, new Comparator<ModuleGroup>(){

            @Override
            public int compare(ModuleGroup moduleGroup1, ModuleGroup moduleGroup2) {
                assert (moduleGroup1.getGroupPath().length == moduleGroup2.getGroupPath().length);
                return moduleGroup1.toString().compareToIgnoreCase(moduleGroup2.toString());
            }
        });
        ArrayList<Object> result2 = new ArrayList<Object>();
        result2.add((Object)new MoveModulesToGroupAction(this.myModuleGroup, IdeBundle.message((String)"action.move.module.to.this.group", (Object[])new Object[0])));
        result2.add((Object)new MoveModulesToSubGroupAction(this.myModuleGroup));
        result2.add(Separator.getInstance());
        for (ModuleGroup child : children2) {
            result2.add((Object)new MoveModuleToGroup(child));
        }
        AnAction[] anActionArray = result2.toArray(new AnAction[result2.size()]);
        if (anActionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/projectView/impl/MoveModuleToGroup", "getChildren"));
        }
        return anActionArray;
    }
}

