/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.scratch;

import com.intellij.openapi.fileTypes.FileTypeEvent;
import com.intellij.openapi.fileTypes.FileTypeListener;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.util.PairConsumer;
import com.intellij.util.containers.ConcurrentIntObjectMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class LightDirectoryIndex<T> {
    private final ConcurrentIntObjectMap<T> myInfoCache;
    private final T myDefValue;

    public LightDirectoryIndex(@NotNull MessageBusConnection connection, @NotNull T defValue) {
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/ide/scratch/LightDirectoryIndex", "<init>"));
        }
        if (defValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defValue", "com/intellij/ide/scratch/LightDirectoryIndex", "<init>"));
        }
        this.myInfoCache = ContainerUtil.createConcurrentIntObjectMap();
        this.myDefValue = defValue;
        this.reinitRoots();
        connection.subscribe(FileTypeManager.TOPIC, (Object)new FileTypeListener.Adapter(){

            public void fileTypesChanged(@NotNull FileTypeEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/ide/scratch/LightDirectoryIndex$1", "fileTypesChanged"));
                }
                LightDirectoryIndex.this.reinitRoots();
            }
        });
        connection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(){

            public void before(@NotNull List<? extends VFileEvent> events) {
                if (events == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/intellij/ide/scratch/LightDirectoryIndex$2", "before"));
                }
            }

            public void after(@NotNull List<? extends VFileEvent> events) {
                if (events == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/intellij/ide/scratch/LightDirectoryIndex$2", "after"));
                }
                for (VFileEvent vFileEvent : events) {
                    VirtualFile file = vFileEvent.getFile();
                    if (file != null && !file.isDirectory()) continue;
                    LightDirectoryIndex.this.reinitRoots();
                    break;
                }
            }
        });
    }

    public void reinitRoots() {
        this.myInfoCache.clear();
        this.collectRoots(new PairConsumer<VirtualFile, T>(){

            public void consume(VirtualFile file, T info) {
                LightDirectoryIndex.this.cacheInfo(file, info);
            }
        });
    }

    protected abstract void collectRoots(@NotNull PairConsumer<VirtualFile, T> var1);

    @NotNull
    public T getInfoForFile(@NotNull VirtualFile file) {
        VirtualFile dir;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/ide/scratch/LightDirectoryIndex", "getInfoForFile"));
        }
        if (!file.isDirectory()) {
            T info = this.getCachedInfo(file);
            if (info != null) {
                T t = info;
                if (t == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/scratch/LightDirectoryIndex", "getInfoForFile"));
                }
                return t;
            }
            dir = file.getParent();
        } else {
            dir = file;
        }
        int count = 0;
        for (VirtualFile root = dir; root != null; root = root.getParent()) {
            if (++count > 1000) {
                throw new IllegalStateException("Possible loop in tree, started at " + dir.getName());
            }
            T info = this.getCachedInfo(root);
            if (info == null) continue;
            if (!dir.equals(root)) {
                this.cacheInfos(dir, root, info);
            }
            T t = info;
            if (t == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/scratch/LightDirectoryIndex", "getInfoForFile"));
            }
            return t;
        }
        T t = this.cacheInfos(dir, null, this.myDefValue);
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/scratch/LightDirectoryIndex", "getInfoForFile"));
        }
        return t;
    }

    @NotNull
    private T cacheInfos(VirtualFile dir, @Nullable VirtualFile stopAt, @NotNull T info) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/ide/scratch/LightDirectoryIndex", "cacheInfos"));
        }
        while (dir != null) {
            this.cacheInfo(dir, info);
            if (dir.equals(stopAt)) break;
            dir = dir.getParent();
        }
        T t = info;
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/scratch/LightDirectoryIndex", "cacheInfos"));
        }
        return t;
    }

    private void cacheInfo(VirtualFile file, T info) {
        this.myInfoCache.put(((VirtualFileWithId)file).getId(), info);
    }

    private T getCachedInfo(VirtualFile file) {
        return (T)this.myInfoCache.get(((VirtualFileWithId)file).getId());
    }
}

