/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf.darcula.ui;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.plaf.basic.BasicTextFieldUI;

public abstract class TextFieldWithPopupHandlerUI
extends BasicTextFieldUI {
    protected final JTextField myTextField;

    public TextFieldWithPopupHandlerUI(JTextField textField) {
        this.myTextField = textField;
        this.installListeners();
    }

    protected abstract SearchAction getActionUnder(MouseEvent var1);

    protected abstract void showSearchPopup();

    @Override
    protected void installListeners() {
        final TextFieldWithPopupHandlerUI ui = this;
        this.myTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                TextFieldWithPopupHandlerUI.this.myTextField.repaint();
            }

            @Override
            public void focusLost(FocusEvent e) {
                TextFieldWithPopupHandlerUI.this.myTextField.repaint();
            }
        });
        this.myTextField.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                if (ui.getComponent() != null && TextFieldWithPopupHandlerUI.isSearchField(TextFieldWithPopupHandlerUI.this.myTextField)) {
                    if (ui.getActionUnder(e) != null) {
                        TextFieldWithPopupHandlerUI.this.myTextField.setCursor(Cursor.getPredefinedCursor(12));
                    } else {
                        TextFieldWithPopupHandlerUI.this.myTextField.setCursor(Cursor.getPredefinedCursor(2));
                    }
                }
            }
        });
        this.myTextField.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                SearchAction action;
                if (TextFieldWithPopupHandlerUI.isSearchField(TextFieldWithPopupHandlerUI.this.myTextField) && (action = ui.getActionUnder(e)) != null) {
                    switch (action) {
                        case POPUP: {
                            ui.showSearchPopup();
                            break;
                        }
                        case CLEAR: {
                            Object listener = TextFieldWithPopupHandlerUI.this.myTextField.getClientProperty("JTextField.Search.CancelAction");
                            if (listener instanceof ActionListener) {
                                ((ActionListener)listener).actionPerformed(new ActionEvent(this, 1001, "action"));
                            }
                            TextFieldWithPopupHandlerUI.this.myTextField.setText("");
                        }
                    }
                    e.consume();
                }
            }
        });
    }

    public static boolean isSearchField(Component c) {
        return c instanceof JTextField && "search".equals(((JTextField)c).getClientProperty("JTextField.variant"));
    }

    public static boolean isSearchFieldWithHistoryPopup(Component c) {
        return TextFieldWithPopupHandlerUI.isSearchField(c) && ((JTextField)c).getClientProperty("JTextField.Search.FindPopup") instanceof JPopupMenu;
    }

    public static enum SearchAction {
        POPUP,
        CLEAR;

    }
}

