/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.intellij.CommonBundle;
import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryAction;
import com.intellij.ide.DataManager;
import com.intellij.ide.DeleteProvider;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.DeleteUtil;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.project.DumbModePermission;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.ex.MessagesEx;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.WritingAccessProvider;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.safeDelete.SafeDeleteDialog;
import com.intellij.refactoring.safeDelete.SafeDeleteProcessor;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.io.ReadOnlyAttributeUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeleteHandler {
    private DeleteHandler() {
    }

    public static void deletePsiElement(PsiElement[] elementsToDelete, Project project) {
        DeleteHandler.deletePsiElement(elementsToDelete, project, true);
    }

    public static void deletePsiElement(PsiElement[] elementsToDelete, final Project project, boolean needConfirmation) {
        if (elementsToDelete == null || elementsToDelete.length == 0) {
            return;
        }
        final PsiElement[] elements = PsiTreeUtil.filterAncestors((PsiElement[])elementsToDelete);
        boolean safeDeleteApplicable = true;
        for (int i = 0; i < elements.length && safeDeleteApplicable; ++i) {
            PsiElement element = elements[i];
            safeDeleteApplicable = SafeDeleteProcessor.validElement(element);
        }
        boolean dumb = DumbService.getInstance((Project)project).isDumb();
        if (safeDeleteApplicable && !dumb) {
            final Ref exit = Ref.create((Object)false);
            SafeDeleteDialog dialog = new SafeDeleteDialog(project, elements, new SafeDeleteDialog.Callback(){

                @Override
                public void run(final SafeDeleteDialog dialog) {
                    if (!CommonRefactoringUtil.checkReadOnlyStatusRecursively((Project)project, Arrays.asList(elements), (boolean)true)) {
                        return;
                    }
                    SafeDeleteProcessor processor2 = SafeDeleteProcessor.createInstance(project, new Runnable(){

                        @Override
                        public void run() {
                            exit.set((Object)true);
                            dialog.close(0);
                        }
                    }, elements, dialog.isSearchInComments(), dialog.isSearchForTextOccurences(), true);
                    DumbService.allowStartingDumbModeInside((DumbModePermission)DumbModePermission.MAY_START_BACKGROUND, (Runnable)processor2);
                }
            }){

                @Override
                protected boolean isDelete() {
                    return true;
                }
            };
            if (needConfirmation && (!dialog.showAndGet() || ((Boolean)exit.get()).booleanValue())) {
                return;
            }
        } else {
            int result2;
            String warningMessage = DeleteUtil.generateWarningMessage(IdeBundle.message((String)"prompt.delete.elements", (Object[])new Object[0]), elements);
            boolean anyDirectories = false;
            String directoryName = null;
            for (PsiElement psiElement : elementsToDelete) {
                if (!(psiElement instanceof PsiDirectory) || PsiUtilBase.isSymLink((PsiFileSystemItem)((PsiDirectory)psiElement))) continue;
                anyDirectories = true;
                directoryName = ((PsiDirectory)psiElement).getName();
                break;
            }
            if (anyDirectories) {
                warningMessage = elements.length == 1 ? warningMessage + IdeBundle.message((String)"warning.delete.all.files.and.subdirectories", (Object[])new Object[]{directoryName}) : warningMessage + IdeBundle.message((String)"warning.delete.all.files.and.subdirectories.in.the.selected.directory", (Object[])new Object[0]);
            }
            if (safeDeleteApplicable && dumb) {
                warningMessage = warningMessage + "\n\nWarning:\n  Safe delete is not available while " + ApplicationNamesInfo.getInstance().getFullProductName() + " updates indices,\n  no usages will be checked.";
            }
            if (needConfirmation && (result2 = Messages.showOkCancelDialog((Project)project, (String)warningMessage, (String)IdeBundle.message((String)"title.delete", (Object[])new Object[0]), (String)ApplicationBundle.message((String)"button.delete", (Object[])new Object[0]), (String)CommonBundle.getCancelButtonText(), (Icon)Messages.getQuestionIcon())) != 0) {
                return;
            }
        }
        CommandProcessor.getInstance().executeCommand(project, new Runnable(){

            @Override
            public void run() {
                if (!CommonRefactoringUtil.checkReadOnlyStatusRecursively((Project)project, Arrays.asList(elements), (boolean)false)) {
                    return;
                }
                if (CommonDataKeys.EDITOR.getData(DataManager.getInstance().getDataContext()) == null) {
                    CommandProcessor.getInstance().markCurrentCommandAsGlobal(project);
                }
                for (final PsiElement elementToDelete : elements) {
                    boolean success;
                    int _result;
                    VirtualFile virtualFile;
                    PsiFile file;
                    if (!elementToDelete.isValid()) continue;
                    if (elementToDelete instanceof PsiDirectory) {
                        VirtualFile virtualFile2 = ((PsiDirectory)elementToDelete).getVirtualFile();
                        if (virtualFile2.isInLocalFileSystem() && !virtualFile2.is(VFileProperty.SYMLINK)) {
                            ArrayList readOnlyFiles = new ArrayList();
                            CommonRefactoringUtil.collectReadOnlyFiles((VirtualFile)virtualFile2, readOnlyFiles);
                            if (!readOnlyFiles.isEmpty()) {
                                VirtualFile file2;
                                String message = IdeBundle.message((String)"prompt.directory.contains.read.only.files", (Object[])new Object[]{virtualFile2.getPresentableUrl()});
                                int _result2 = Messages.showYesNoDialog((Project)project, (String)message, (String)IdeBundle.message((String)"title.delete", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon());
                                if (_result2 != 0) continue;
                                boolean success2 = true;
                                Iterator iterator = readOnlyFiles.iterator();
                                while (iterator.hasNext() && (success2 = DeleteHandler.clearReadOnlyFlag(file2 = (VirtualFile)iterator.next(), project))) {
                                }
                                if (!success2) {
                                    continue;
                                }
                            }
                        }
                    } else if (!(elementToDelete.isWritable() || elementToDelete instanceof PsiFileSystemItem && PsiUtilBase.isSymLink((PsiFileSystemItem)((PsiFileSystemItem)elementToDelete)) || (file = elementToDelete.getContainingFile()) == null || !(virtualFile = file.getVirtualFile()).isInLocalFileSystem() || (_result = ((MessagesEx.MessageInfo)((MessagesEx.MessageInfo)MessagesEx.fileIsReadOnly(project, virtualFile).setTitle(IdeBundle.message((String)"title.delete", (Object[])new Object[0]))).appendMessage(IdeBundle.message((String)"prompt.delete.it.anyway", (Object[])new Object[0]))).askYesNo()) == 0 && (success = DeleteHandler.clearReadOnlyFlag(virtualFile, project)))) continue;
                    try {
                        elementToDelete.checkDelete();
                    }
                    catch (IncorrectOperationException ex) {
                        Messages.showMessageDialog((Project)project, (String)ex.getMessage(), (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
                        continue;
                    }
                    ApplicationManager.getApplication().runWriteAction(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                elementToDelete.delete();
                            }
                            catch (IncorrectOperationException ex) {
                                ApplicationManager.getApplication().invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        Messages.showMessageDialog((Project)project, (String)ex.getMessage(), (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
                                    }
                                });
                            }
                        }
                    });
                }
            }
        }, RefactoringBundle.message((String)"safe.delete.command", (Object[])new Object[]{RefactoringUIUtil.calculatePsiElementDescriptionList(elements)}), null);
    }

    private static boolean clearReadOnlyFlag(final VirtualFile virtualFile, final Project project) {
        final boolean[] success = new boolean[1];
        CommandProcessor.getInstance().executeCommand(project, new Runnable(){

            @Override
            public void run() {
                Runnable action = new Runnable(){

                    @Override
                    public void run() {
                        try {
                            ReadOnlyAttributeUtil.setReadOnlyAttribute((VirtualFile)virtualFile, (boolean)false);
                            success[0] = true;
                        }
                        catch (IOException e1) {
                            Messages.showMessageDialog((Project)project, (String)e1.getMessage(), (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
                        }
                    }
                };
                ApplicationManager.getApplication().runWriteAction(action);
            }
        }, "", null);
        return success[0];
    }

    public static boolean shouldEnableDeleteAction(PsiElement[] elements) {
        if (elements == null || elements.length == 0) {
            return false;
        }
        for (PsiElement element : elements) {
            VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)element);
            if (virtualFile == null) {
                return false;
            }
            if (WritingAccessProvider.isPotentiallyWritable((VirtualFile)virtualFile, (Project)element.getProject())) continue;
            return false;
        }
        return true;
    }

    public static class DefaultDeleteProvider
    implements DeleteProvider {
        public boolean canDeleteElement(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/ide/util/DeleteHandler$DefaultDeleteProvider", "canDeleteElement"));
            }
            if (CommonDataKeys.PROJECT.getData(dataContext) == null) {
                return false;
            }
            PsiElement[] elements = DefaultDeleteProvider.getPsiElements(dataContext);
            return elements != null && DeleteHandler.shouldEnableDeleteAction(elements);
        }

        @Nullable
        private static PsiElement[] getPsiElements(DataContext dataContext) {
            PsiElement[] elements = (PsiElement[])LangDataKeys.PSI_ELEMENT_ARRAY.getData(dataContext);
            if (elements == null) {
                Object data = CommonDataKeys.PSI_ELEMENT.getData(dataContext);
                if (data != null) {
                    elements = new PsiElement[]{(PsiElement)data};
                } else {
                    Object data1 = CommonDataKeys.PSI_FILE.getData(dataContext);
                    if (data1 != null) {
                        elements = new PsiElement[]{(PsiFile)data1};
                    }
                }
            }
            return elements;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void deleteElement(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/ide/util/DeleteHandler$DefaultDeleteProvider", "deleteElement"));
            }
            PsiElement[] elements = DefaultDeleteProvider.getPsiElements(dataContext);
            if (elements == null) {
                return;
            }
            Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
            if (project == null) {
                return;
            }
            LocalHistoryAction a = LocalHistory.getInstance().startAction(IdeBundle.message((String)"progress.deleting", (Object[])new Object[0]));
            try {
                DeleteHandler.deletePsiElement(elements, project);
            }
            finally {
                a.finish();
            }
        }
    }
}

