/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.newProjectWizard;

import com.intellij.ide.util.newProjectWizard.AddModuleWizard;
import com.intellij.ide.util.newProjectWizard.WizardArrowUI;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.ide.wizard.CommitStepException;
import com.intellij.ide.wizard.Step;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.ValidationInfo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddModuleWizardPro
extends AddModuleWizard {
    protected JPanel myStepsPanel;

    public AddModuleWizardPro(Project project, @NotNull ModulesProvider modulesProvider, @Nullable String defaultPath) {
        if (modulesProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modulesProvider", "com/intellij/ide/util/newProjectWizard/AddModuleWizardPro", "<init>"));
        }
        super(project, modulesProvider, defaultPath);
        this.getWizardContext().addContextListener(new WizardContext.Listener(){

            public void buttonsUpdateRequested() {
                AddModuleWizardPro.this.updateStepsPanel();
            }

            public void nextStepRequested() {
                AddModuleWizardPro.this.updateStepsPanel();
            }
        });
    }

    protected void updateButtons() {
        super.updateButtons();
        if (this.isLastStep()) {
            this.getNextButton().setText("Done");
        }
        this.getPreviousButton().setVisible(false);
        this.getCancelButton().setVisible(false);
    }

    public AddModuleWizardPro(Component parent, Project project, @NotNull ModulesProvider modulesProvider) {
        if (modulesProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modulesProvider", "com/intellij/ide/util/newProjectWizard/AddModuleWizardPro", "<init>"));
        }
        super(parent, project, modulesProvider);
    }

    protected void createDefaultActions() {
        super.createDefaultActions();
    }

    protected JComponent createCenterPanel() {
        this.myStepsPanel = new JPanel(){

            @Override
            public void addNotify() {
                super.addNotify();
                ((ModuleWizardStep)AddModuleWizardPro.this.getNextStepObject()).updateDataModel();
                AddModuleWizardPro.this.updateStepsPanel();
                new AnAction(){

                    public void actionPerformed(AnActionEvent e) {
                        if (!AddModuleWizardPro.this.isLastStep()) {
                            AddModuleWizardPro.this.doNextAction();
                        }
                    }
                }.registerCustomShortcutSet((ShortcutSet)CustomShortcutSet.fromString((String[])new String[]{"control TAB"}), AddModuleWizardPro.this.getContentPanel(), AddModuleWizardPro.this.getDisposable());
                new AnAction(){

                    public void actionPerformed(AnActionEvent e) {
                        AddModuleWizardPro.this.doPreviousAction();
                    }
                }.registerCustomShortcutSet((ShortcutSet)CustomShortcutSet.fromString((String[])new String[]{"control shift TAB"}), AddModuleWizardPro.this.getContentPanel(), AddModuleWizardPro.this.getDisposable());
                new AnAction(){

                    public void actionPerformed(AnActionEvent e) {
                        AddModuleWizardPro.this.myCurrentStep = AddModuleWizardPro.this.mySteps.size() - 1;
                        AddModuleWizardPro.this.doOKAction();
                    }
                }.registerCustomShortcutSet((ShortcutSet)CustomShortcutSet.fromString((String[])new String[]{"control shift ENTER"}), AddModuleWizardPro.this.getContentPanel(), AddModuleWizardPro.this.getDisposable());
            }

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                Component c = this.getComponent(this.getComponentCount() - 1);
                int y = c.getBounds().y + c.getBounds().height + 4;
                g.translate(0, y);
                AddModuleWizardPro.this.myIcon.paintIcon(g);
                g.translate(0, -y);
            }
        };
        this.myStepsPanel.setLayout(new BoxLayout(this.myStepsPanel, 1){

            @Override
            public void layoutContainer(Container target) {
                super.layoutContainer(target);
                int maxWidth = -1;
                for (Component c : target.getComponents()) {
                    maxWidth = Math.max(maxWidth, c.getWidth());
                }
                for (Component c : target.getComponents()) {
                    Rectangle b = c.getBounds();
                    c.setBounds(b.x, b.y, maxWidth, b.height);
                }
            }
        });
        this.myStepsPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 4));
        this.updateStepsPanel();
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.myStepsPanel, "West");
        panel.add((Component)this.myContentPanel, "Center");
        return panel;
    }

    @Override
    public void doNextAction() {
        super.doNextAction();
        this.updateStepsPanel();
    }

    @Override
    protected void doPreviousAction() {
        super.doPreviousAction();
        this.updateStepsPanel();
    }

    @Nullable
    protected ValidationInfo doValidate() {
        ValidationInfo result2 = super.doValidate();
        this.updateStepsPanel();
        return result2;
    }

    private void updateStepsPanel() {
        this.myStepsPanel.removeAll();
        int index = 0;
        ButtonGroup group = new ButtonGroup();
        while (index != -1) {
            final int ind = index;
            ModuleWizardStep step = (ModuleWizardStep)this.mySteps.get(index);
            JRadioButton rb = new JRadioButton(step.getName(), index == this.myCurrentStep);
            rb.setFocusable(false);
            rb.setUI(new WizardArrowUI(rb, index < this.myCurrentStep));
            this.myStepsPanel.add(rb);
            group.add(rb);
            rb.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ModuleWizardStep step = (ModuleWizardStep)AddModuleWizardPro.this.getCurrentStepObject();
                    if (ind > AddModuleWizardPro.this.getCurrentStep() && !AddModuleWizardPro.this.commitStepData(step)) {
                        AddModuleWizardPro.this.updateStepsPanel();
                        return;
                    }
                    step.onStepLeaving();
                    Step currentStep = (Step)AddModuleWizardPro.this.mySteps.get(AddModuleWizardPro.this.myCurrentStep);
                    try {
                        currentStep._commit(false);
                    }
                    catch (CommitStepException exc) {
                        Messages.showErrorDialog((Component)AddModuleWizardPro.this.myContentPanel, (String)exc.getMessage());
                        return;
                    }
                    AddModuleWizardPro.this.myCurrentStep = ind;
                    AddModuleWizardPro.this.updateStep();
                }
            });
            int next = this.getNextStep(index);
            index = index == next ? -1 : next;
        }
        Enumeration<AbstractButton> buttons = group.getElements();
        while (buttons.hasMoreElements()) {
            JRadioButton b = (JRadioButton)buttons.nextElement();
            b.setUI(new WizardArrowUI(b, index < this.myCurrentStep));
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AddModuleWizardPro.this.myStepsPanel.revalidate();
                AddModuleWizardPro.this.myStepsPanel.repaint();
            }
        });
    }
}

