/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.projectWizard;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ui.configuration.ProjectJdksConfigurable;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.MultiLineLabelUI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.plaf.LabelUI;

public class ProjectJdkStep
extends ModuleWizardStep {
    private final WizardContext myContext;
    protected final ProjectJdksConfigurable myProjectJdksConfigurable;
    private final JComponent myJDKsComponent;

    public ProjectJdkStep(WizardContext context) {
        this.myContext = context;
        this.myProjectJdksConfigurable = new ProjectJdksConfigurable(ProjectManager.getInstance().getDefaultProject());
        this.myProjectJdksConfigurable.reset();
        this.myJDKsComponent = this.myProjectJdksConfigurable.createComponent();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myJDKsComponent;
    }

    public String getHelpId() {
        return "reference.dialogs.new.project.fromScratch.sdk";
    }

    public JComponent getComponent() {
        JLabel label = new JLabel(IdeBundle.message((String)"prompt.please.select.project.jdk", (Object[])new Object[0]));
        label.setUI((LabelUI)new MultiLineLabelUI());
        JPanel panel = new JPanel(new GridBagLayout()){

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(-1, 200);
            }
        };
        panel.add((Component)label, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.myJDKsComponent.setBorder(BorderFactory.createEmptyBorder(4, 0, 0, 0));
        panel.add((Component)this.myJDKsComponent, new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    public void updateDataModel() {
        this.myContext.setProjectJdk(this.getJdk());
    }

    public Sdk getJdk() {
        return this.myProjectJdksConfigurable.getSelectedJdk();
    }

    public Icon getIcon() {
        return this.myContext.getStepIcon();
    }

    public boolean validate() throws ConfigurationException {
        int result2;
        Sdk jdk = this.myProjectJdksConfigurable.getSelectedJdk();
        if (jdk == null && !ApplicationManager.getApplication().isUnitTestMode() && (result2 = Messages.showOkCancelDialog((String)IdeBundle.message((String)"prompt.confirm.project.no.jdk", (Object[])new Object[0]), (String)IdeBundle.message((String)"title.no.jdk.specified", (Object[])new Object[0]), (Icon)Messages.getWarningIcon())) != 0) {
            return false;
        }
        this.myProjectJdksConfigurable.apply();
        return true;
    }

    public String getName() {
        return "Project JDK";
    }

    public void disposeUIResources() {
        super.disposeUIResources();
        this.myProjectJdksConfigurable.disposeUIResources();
    }
}

