/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic;

import com.intellij.internal.statistic.AbstractApplicationUsagesCollector;
import com.intellij.internal.statistic.CollectUsagesException;
import com.intellij.internal.statistic.beans.GroupDescriptor;
import com.intellij.internal.statistic.beans.UsageDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public abstract class UsagesCollector {
    private static final Logger LOG = Logger.getInstance(UsagesCollector.class);
    private static final Object LOCK = new Object();
    public static final ExtensionPointName<UsagesCollector> EP_NAME = ExtensionPointName.create((String)"com.intellij.statistics.usagesCollector");

    @NotNull
    public abstract Set<UsageDescriptor> getUsages() throws CollectUsagesException;

    @NotNull
    public abstract GroupDescriptor getGroupId();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doPersistProjectUsages(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/internal/statistic/UsagesCollector", "doPersistProjectUsages"));
        }
        Object object = LOCK;
        synchronized (object) {
            if (!project.isInitialized() || DumbService.isDumb((Project)project)) {
                return;
            }
            for (UsagesCollector usagesCollector : (UsagesCollector[])EP_NAME.getExtensions()) {
                if (!(usagesCollector instanceof AbstractApplicationUsagesCollector)) continue;
                ((AbstractApplicationUsagesCollector)usagesCollector).persistProjectUsages(project);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public static Map<GroupDescriptor, Set<UsageDescriptor>> getAllUsages(@NotNull Set<String> disabledGroups) {
        if (disabledGroups == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "disabledGroups", "com/intellij/internal/statistic/UsagesCollector", "getAllUsages"));
        }
        Object object = LOCK;
        // MONITORENTER : object
        LinkedHashMap<GroupDescriptor, Set<UsageDescriptor>> usageDescriptors = new LinkedHashMap<GroupDescriptor, Set<UsageDescriptor>>();
        UsagesCollector[] usagesCollectorArray = (UsagesCollector[])EP_NAME.getExtensions();
        int n = usagesCollectorArray.length;
        int n2 = 0;
        while (true) {
            if (n2 >= n) {
                LinkedHashMap<GroupDescriptor, Set<UsageDescriptor>> linkedHashMap = usageDescriptors;
                // MONITOREXIT : object
                if (linkedHashMap != null) return linkedHashMap;
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/internal/statistic/UsagesCollector", "getAllUsages"));
            }
            UsagesCollector usagesCollector = usagesCollectorArray[n2];
            GroupDescriptor groupDescriptor = usagesCollector.getGroupId();
            if (!disabledGroups.contains(groupDescriptor.getId())) {
                try {
                    usageDescriptors.put(groupDescriptor, usagesCollector.getUsages());
                }
                catch (CollectUsagesException e) {
                    LOG.info((Throwable)e);
                }
            }
            ++n2;
        }
    }
}

