/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.persistence;

import com.intellij.internal.statistic.beans.ConvertUsagesUtil;
import com.intellij.internal.statistic.beans.GroupDescriptor;
import com.intellij.internal.statistic.configurable.SendPeriod;
import com.intellij.internal.statistic.persistence.BasicSentUsagesPersistenceComponent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.components.NamedComponent;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.util.text.StringUtil;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="UsagesStatistic", storages={@Storage(file="$APP_CONFIG$/usage.statistics.xml", roamingType=RoamingType.DISABLED)})
public class UsageStatisticsPersistenceComponent
extends BasicSentUsagesPersistenceComponent
implements NamedComponent,
PersistentStateComponent<Element> {
    @NonNls
    private boolean isAllowed = false;
    @NonNls
    private boolean isShowNotification = true;
    @NotNull
    private SendPeriod myPeriod = SendPeriod.WEEKLY;
    @NonNls
    private static final String DATA_ATTR = "data";
    @NonNls
    private static final String GROUP_TAG = "group";
    @NonNls
    private static final String GROUP_ID_ATTR = "id";
    @NonNls
    private static final String GROUP_PRIORITY_ATTR = "priority";
    @NonNls
    private static final String LAST_TIME_ATTR = "time";
    @NonNls
    private static final String IS_ALLOWED_ATTR = "allowed";
    @NonNls
    private static final String PERIOD_ATTR = "period";
    @NonNls
    private static final String SHOW_NOTIFICATION_ATTR = "show-notification";

    public static UsageStatisticsPersistenceComponent getInstance() {
        return (UsageStatisticsPersistenceComponent)ApplicationManager.getApplication().getComponent(UsageStatisticsPersistenceComponent.class);
    }

    public UsageStatisticsPersistenceComponent() {
        if (ApplicationManagerEx.getApplicationEx().isInternal()) {
            this.isShowNotification = false;
        }
    }

    public void loadState(Element element) {
        List groupsList = element.getChildren(GROUP_TAG);
        for (Object project : groupsList) {
            Element groupElement = (Element)project;
            String groupId = groupElement.getAttributeValue(GROUP_ID_ATTR);
            double groupPriority = UsageStatisticsPersistenceComponent.getPriority(groupElement.getAttributeValue(GROUP_PRIORITY_ATTR));
            String valueData = groupElement.getAttributeValue(DATA_ATTR);
            if (StringUtil.isEmptyOrSpaces((String)groupId) || StringUtil.isEmptyOrSpaces((String)valueData)) continue;
            try {
                this.getSentUsages().putAll(ConvertUsagesUtil.convertValueString(GroupDescriptor.create(groupId, groupPriority), valueData));
            }
            catch (AssertionError assertionError) {}
        }
        try {
            this.setSentTime(Long.parseLong(element.getAttributeValue(LAST_TIME_ATTR)));
        }
        catch (NumberFormatException e) {
            this.setSentTime(0L);
        }
        String isAllowedValue = element.getAttributeValue(IS_ALLOWED_ATTR);
        this.setAllowed(!StringUtil.isEmptyOrSpaces((String)isAllowedValue) && Boolean.parseBoolean(isAllowedValue));
        String isShowNotificationValue = element.getAttributeValue(SHOW_NOTIFICATION_ATTR);
        this.setShowNotification(StringUtil.isEmptyOrSpaces((String)isShowNotificationValue) || Boolean.parseBoolean(isShowNotificationValue));
        this.setPeriod(UsageStatisticsPersistenceComponent.parsePeriod(element.getAttributeValue(PERIOD_ATTR)));
    }

    public Element getState() {
        Element element = new Element("state");
        for (Map.Entry entry : ConvertUsagesUtil.sortDescriptorsByPriority(this.getSentUsages()).entrySet()) {
            Element projectElement = new Element(GROUP_TAG);
            projectElement.setAttribute(GROUP_ID_ATTR, entry.getKey().getId());
            projectElement.setAttribute(GROUP_PRIORITY_ATTR, Double.toString(entry.getKey().getPriority()));
            projectElement.setAttribute(DATA_ATTR, ConvertUsagesUtil.convertValueMap(entry.getValue()));
            element.addContent(projectElement);
        }
        element.setAttribute(LAST_TIME_ATTR, String.valueOf(this.getLastTimeSent()));
        element.setAttribute(IS_ALLOWED_ATTR, String.valueOf(this.isAllowed()));
        element.setAttribute(SHOW_NOTIFICATION_ATTR, String.valueOf(this.isShowNotification()));
        element.setAttribute(PERIOD_ATTR, this.myPeriod.getName());
        return element;
    }

    @NotNull
    public SendPeriod getPeriod() {
        SendPeriod sendPeriod = this.myPeriod;
        if (sendPeriod == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/internal/statistic/persistence/UsageStatisticsPersistenceComponent", "getPeriod"));
        }
        return sendPeriod;
    }

    public void setPeriod(@NotNull SendPeriod period) {
        if (period == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", PERIOD_ATTR, "com/intellij/internal/statistic/persistence/UsageStatisticsPersistenceComponent", "setPeriod"));
        }
        this.myPeriod = period;
    }

    @NotNull
    private static SendPeriod parsePeriod(@Nullable String periodAttrValue) {
        if (SendPeriod.DAILY.getName().equals(periodAttrValue)) {
            SendPeriod sendPeriod = SendPeriod.DAILY;
            if (sendPeriod == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/internal/statistic/persistence/UsageStatisticsPersistenceComponent", "parsePeriod"));
            }
            return sendPeriod;
        }
        if (SendPeriod.MONTHLY.getName().equals(periodAttrValue)) {
            SendPeriod sendPeriod = SendPeriod.MONTHLY;
            if (sendPeriod == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/internal/statistic/persistence/UsageStatisticsPersistenceComponent", "parsePeriod"));
            }
            return sendPeriod;
        }
        SendPeriod sendPeriod = SendPeriod.WEEKLY;
        if (sendPeriod == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/internal/statistic/persistence/UsageStatisticsPersistenceComponent", "parsePeriod"));
        }
        return sendPeriod;
    }

    public void setAllowed(boolean allowed) {
        this.isAllowed = allowed;
    }

    @Override
    public boolean isAllowed() {
        return this.isAllowed;
    }

    public void setShowNotification(boolean showNotification2) {
        this.isShowNotification = showNotification2;
    }

    @Override
    public boolean isShowNotification() {
        return this.isShowNotification;
    }

    private static double getPriority(String priority) {
        if (StringUtil.isEmptyOrSpaces((String)priority)) {
            return 0.0;
        }
        return Double.parseDouble(priority);
    }

    @NonNls
    @NotNull
    public String getComponentName() {
        if ("SentUsagesPersistenceComponent" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/internal/statistic/persistence/UsageStatisticsPersistenceComponent", "getComponentName"));
        }
        return "SentUsagesPersistenceComponent";
    }
}

