/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notification;

import com.intellij.icons.AllIcons;
import com.intellij.ide.actions.ContextHelpAction;
import com.intellij.notification.EventLog;
import com.intellij.notification.EventLogConsole;
import com.intellij.notification.impl.NotificationsConfigurable;
import com.intellij.notification.impl.NotificationsConfigurationImpl;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actions.ScrollToTheEndToolbarAction;
import com.intellij.openapi.editor.actions.ToggleUseSoftWrapsToolbarAction;
import com.intellij.openapi.editor.impl.softwrap.SoftWrapAppliancePlaces;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.SimpleToolWindowPanel;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowFactory;
import com.intellij.ui.AncestorListenerAdapter;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import javax.swing.JComponent;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class EventLogToolWindowFactory
implements ToolWindowFactory,
DumbAware {
    public void createToolWindowContent(@NotNull Project project, @NotNull ToolWindow toolWindow) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/notification/EventLogToolWindowFactory", "createToolWindowContent"));
        }
        if (toolWindow == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWindow", "com/intellij/notification/EventLogToolWindowFactory", "createToolWindowContent"));
        }
        EventLog.getProjectComponent(project).initDefaultContent();
    }

    static void createContent(Project project, ToolWindow toolWindow, EventLogConsole console, String title) {
        ContentManager contentManager = toolWindow.getContentManager();
        Content generalContent = contentManager.getContent(0);
        if (generalContent != null && contentManager.getContentCount() == 1) {
            generalContent.setDisplayName("General");
        }
        Editor editor = console.getConsoleEditor();
        SimpleToolWindowPanel panel = new SimpleToolWindowPanel(false, true){

            public Object getData(@NonNls String dataId) {
                return PlatformDataKeys.HELP_ID.is(dataId) ? "reference.toolwindows.event.log" : super.getData(dataId);
            }
        };
        panel.setContent(editor.getComponent());
        panel.addAncestorListener((AncestorListener)((Object)new LogShownTracker(project)));
        ActionToolbar toolbar = EventLogToolWindowFactory.createToolbar(project, editor, console);
        toolbar.setTargetComponent(editor.getContentComponent());
        panel.setToolbar(toolbar.getComponent());
        Content content = ContentFactory.SERVICE.getInstance().createContent((JComponent)panel, title, false);
        contentManager.addContent(content);
        contentManager.setSelectedContent(content);
    }

    private static ActionToolbar createToolbar(Project project, Editor editor, EventLogConsole console) {
        DefaultActionGroup group = new DefaultActionGroup();
        group.add((AnAction)new EditNotificationSettings(project));
        group.add((AnAction)new DisplayBalloons());
        group.add((AnAction)new ToggleSoftWraps(editor));
        group.add((AnAction)new ScrollToTheEndToolbarAction(editor));
        group.add(ActionManager.getInstance().getAction("MarkNotificationsAsRead"));
        group.add((AnAction)new EventLogConsole.ClearLogAction(console));
        group.add((AnAction)new ContextHelpAction("reference.toolwindows.event.log"));
        return ActionManager.getInstance().createActionToolbar("unknown", (ActionGroup)group, false);
    }

    private static class LogShownTracker
    extends AncestorListenerAdapter {
        private final Project myProject;

        public LogShownTracker(Project project) {
            this.myProject = project;
        }

        public void ancestorAdded(AncestorEvent event) {
            ToolWindow log = EventLog.getEventLog(this.myProject);
            if (log != null && log.isVisible()) {
                EventLog.getLogModel(this.myProject).logShown();
            }
        }
    }

    private static class ToggleSoftWraps
    extends ToggleUseSoftWrapsToolbarAction {
        private final Editor myEditor;

        public ToggleSoftWraps(Editor editor) {
            super(SoftWrapAppliancePlaces.CONSOLE);
            this.myEditor = editor;
        }

        @Override
        protected Editor getEditor(AnActionEvent e) {
            return this.myEditor;
        }
    }

    private static class EditNotificationSettings
    extends DumbAwareAction {
        private final Project myProject;

        public EditNotificationSettings(Project project) {
            super("Settings", "Edit notification settings", AllIcons.General.Settings);
            this.myProject = project;
        }

        public void actionPerformed(AnActionEvent e) {
            ShowSettingsUtil.getInstance().editConfigurable(this.myProject, (Configurable)new NotificationsConfigurable());
        }
    }

    private static class DisplayBalloons
    extends ToggleAction
    implements DumbAware {
        public DisplayBalloons() {
            super("Show balloons", "Enable or suppress notification balloons", AllIcons.General.Balloon);
        }

        public boolean isSelected(AnActionEvent e) {
            return NotificationsConfigurationImpl.getInstanceImpl().SHOW_BALLOONS;
        }

        public void setSelected(AnActionEvent e, boolean state) {
            NotificationsConfigurationImpl.getInstanceImpl().SHOW_BALLOONS = state;
        }
    }
}

