/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application;

import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.ConfigImportSettings;
import com.intellij.openapi.application.ImportOldConfigsPanel;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.AppUIUtil;
import com.intellij.util.Function;
import com.intellij.util.PlatformUtils;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.SmartList;
import com.intellij.util.ThreeState;
import java.awt.Dialog;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.PropertyResourceBundle;
import javax.swing.JOptionPane;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigImportHelper {
    @NonNls
    public static final String CONFIG_IMPORTED_IN_CURRENT_SESSION_KEY = "intellij.config.imported.in.current.session";
    @NonNls
    private static final String BUILD_NUMBER_FILE = SystemInfo.isMac ? "/Resources/build.txt" : "build.txt";
    @NonNls
    private static final String PLUGINS_PATH = "plugins";
    @NonNls
    private static final String BIN_FOLDER = "bin";
    @NonNls
    private static final String CONFIG_RELATED_PATH = SystemInfo.isMac ? "" : "config/";
    @NonNls
    private static final String OPTIONS_XML = "options/options.xml";

    private ConfigImportHelper() {
    }

    public static void importConfigsTo(@NotNull String newConfigPath) {
        block3: {
            ImportOldConfigsPanel dialog;
            File installationHome;
            if (newConfigPath == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newConfigPath", "com/intellij/openapi/application/ConfigImportHelper", "importConfigsTo"));
            }
            ConfigImportSettings settings = ConfigImportHelper.getConfigImportSettings();
            File newConfigDir = new File(newConfigPath);
            File oldConfigDir = ConfigImportHelper.findOldConfigDir(newConfigDir, settings.getCustomPathsSelector());
            do {
                dialog = new ImportOldConfigsPanel(oldConfigDir, settings);
                dialog.setModalityType(Dialog.ModalityType.TOOLKIT_MODAL);
                AppUIUtil.updateWindowIcon(dialog);
                dialog.setVisible(true);
                if (!dialog.isImportEnabled()) break block3;
            } while (!ConfigImportHelper.validateOldConfigDir(installationHome = dialog.getSelectedFile(), oldConfigDir = ConfigImportHelper.getOldConfigDir(installationHome, settings), settings));
            assert (oldConfigDir != null);
            ConfigImportHelper.doImport(newConfigDir, oldConfigDir, settings, installationHome);
            settings.importFinished(newConfigPath);
            System.setProperty(CONFIG_IMPORTED_IN_CURRENT_SESSION_KEY, Boolean.TRUE.toString());
        }
    }

    @NotNull
    private static ConfigImportSettings getConfigImportSettings() {
        block5: {
            ConfigImportSettings configImportSettings;
            try {
                Class<?> customProviderClass = Class.forName("com.intellij.openapi.application." + PlatformUtils.getPlatformPrefix() + "ConfigImportSettings");
                if (!ConfigImportSettings.class.isAssignableFrom(customProviderClass)) break block5;
                configImportSettings = (ConfigImportSettings)ReflectionUtil.newInstance(customProviderClass);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            if (configImportSettings == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/ConfigImportHelper", "getConfigImportSettings"));
            }
            return configImportSettings;
        }
        ConfigImportSettings configImportSettings = new ConfigImportSettings();
        if (configImportSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/ConfigImportHelper", "getConfigImportSettings"));
        }
        return configImportSettings;
    }

    @Nullable
    private static File findOldConfigDir(@NotNull File configDir, @Nullable String customPathSelector) {
        if (configDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configDir", "com/intellij/openapi/application/ConfigImportHelper", "findOldConfigDir"));
        }
        File selectorDir = CONFIG_RELATED_PATH.isEmpty() ? configDir : configDir.getParentFile();
        File parent = selectorDir.getParentFile();
        if (parent == null || !parent.exists()) {
            return null;
        }
        File maxFile = null;
        long lastModified = 0L;
        String selector = PathManager.getPathsSelector() != null ? PathManager.getPathsSelector() : selectorDir.getName();
        final String prefix = ConfigImportHelper.getPrefixFromSelector(selector);
        final String customPrefix = customPathSelector != null ? ConfigImportHelper.getPrefixFromSelector(customPathSelector) : null;
        for (File file : parent.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(@NotNull File file, @NotNull String name) {
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/application/ConfigImportHelper$1", "accept"));
                }
                if (name == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/application/ConfigImportHelper$1", "accept"));
                }
                return StringUtil.startsWithIgnoreCase((String)name, (String)prefix) || customPrefix != null && StringUtil.startsWithIgnoreCase((String)name, (String)customPrefix);
            }
        })) {
            long modified;
            File options = new File(file, CONFIG_RELATED_PATH + OPTIONS_XML);
            if (!options.exists() || (modified = options.lastModified()) <= lastModified) continue;
            lastModified = modified;
            maxFile = file;
        }
        return maxFile != null ? new File(maxFile, CONFIG_RELATED_PATH) : null;
    }

    private static String getPrefixFromSelector(String selector) {
        return (SystemInfo.isMac ? "" : ".") + selector.replaceAll("\\d", "");
    }

    private static void doImport(@NotNull File newConfigDir, @NotNull File oldConfigDir, ConfigImportSettings settings, File installationHome) {
        if (newConfigDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newConfigDir", "com/intellij/openapi/application/ConfigImportHelper", "doImport"));
        }
        if (oldConfigDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldConfigDir", "com/intellij/openapi/application/ConfigImportHelper", "doImport"));
        }
        try {
            ConfigImportHelper.copy(oldConfigDir, newConfigDir, settings, installationHome);
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), ApplicationBundle.message((String)"error.unable.to.import.settings", (Object[])new Object[]{e.getMessage()}), ApplicationBundle.message((String)"title.settings.import.failed", (Object[])new Object[0]), 2);
        }
    }

    private static boolean validateOldConfigDir(@Nullable File installationHome, @Nullable File oldConfigDir, @NotNull ConfigImportSettings settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/openapi/application/ConfigImportHelper", "validateOldConfigDir"));
        }
        if (oldConfigDir == null) {
            if (installationHome != null) {
                JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), ApplicationBundle.message((String)"error.invalid.installation.home", (Object[])new Object[]{installationHome.getAbsolutePath(), settings.getProductName(ThreeState.YES)}));
            }
            return false;
        }
        if (!oldConfigDir.exists()) {
            JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), ApplicationBundle.message((String)"error.no.settings.path", (Object[])new Object[]{oldConfigDir.getAbsolutePath()}), ApplicationBundle.message((String)"title.settings.import.failed", (Object[])new Object[0]), 2);
            return false;
        }
        return true;
    }

    private static void copy(@NotNull File src, @NotNull File dest, ConfigImportSettings settings, File oldInstallationHome) throws IOException {
        if (src == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "src", "com/intellij/openapi/application/ConfigImportHelper", "copy"));
        }
        if (dest == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dest", "com/intellij/openapi/application/ConfigImportHelper", "copy"));
        }
        src = src.getCanonicalFile();
        dest = dest.getCanonicalFile();
        if (!src.isDirectory()) {
            throw new IOException(ApplicationBundle.message((String)"config.import.invalid.directory.error", (Object[])new Object[]{src.getAbsolutePath()}));
        }
        if (!dest.isDirectory()) {
            throw new IOException(ApplicationBundle.message((String)"config.import.invalid.directory.error", (Object[])new Object[]{dest.getAbsolutePath()}));
        }
        if (FileUtil.filesEqual((File)src, (File)dest)) {
            return;
        }
        FileUtil.ensureExists((File)dest);
        File[] childFiles = src.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(@NotNull File dir, @NotNull String name) {
                if (dir == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "com/intellij/openapi/application/ConfigImportHelper$2", "accept"));
                }
                if (name == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/application/ConfigImportHelper$2", "accept"));
                }
                return !StringUtil.startsWithChar((CharSequence)name, (char)'.') && !name.equals(ConfigImportHelper.PLUGINS_PATH);
            }
        });
        if (childFiles == null || childFiles.length == 0) {
            return;
        }
        for (File from : childFiles) {
            File to = new File(dest, from.getName());
            if (from.isDirectory()) {
                FileUtil.copyDir((File)from, (File)to, (boolean)false);
                continue;
            }
            FileUtil.copy((File)from, (File)to);
        }
        File plugins2 = new File(src, PLUGINS_PATH);
        if (!ConfigImportHelper.loadOldPlugins(plugins2, dest) && SystemInfo.isMac) {
            File oldPluginsDir = ConfigImportHelper.getOldPath(oldInstallationHome, settings, "idea.plugins.path", new Function<String, String>(){

                public String fun(String pathSelector) {
                    return PathManager.getDefaultPluginPathFor((String)pathSelector);
                }
            });
            if (oldPluginsDir == null) {
                oldPluginsDir = new File(PathManager.getDefaultPluginPathFor((String)src.getName()));
            }
            ConfigImportHelper.loadOldPlugins(oldPluginsDir, dest);
        }
    }

    private static boolean loadOldPlugins(File plugins2, File dest) throws IOException {
        if (plugins2.exists()) {
            SmartList descriptors = new SmartList();
            PluginManagerCore.loadDescriptors(plugins2, (List<IdeaPluginDescriptorImpl>)descriptors, null, 0);
            SmartList oldPlugins = new SmartList();
            for (IdeaPluginDescriptorImpl descriptor : descriptors) {
                if (!descriptor.isEnabled() || descriptor.isBundled()) continue;
                oldPlugins.add(descriptor.getPluginId().getIdString());
            }
            if (!oldPlugins.isEmpty()) {
                PluginManagerCore.savePluginsList((Collection<String>)oldPlugins, false, new File(dest, "installed.txt"));
            }
            return true;
        }
        return false;
    }

    @Nullable
    public static File getOldConfigDir(@Nullable File oldInstallHome, ConfigImportSettings settings) {
        if (oldInstallHome == null) {
            return null;
        }
        if (new File(oldInstallHome, OPTIONS_XML).exists()) {
            return oldInstallHome;
        }
        if (new File(oldInstallHome, CONFIG_RELATED_PATH + OPTIONS_XML).exists()) {
            return new File(oldInstallHome, CONFIG_RELATED_PATH);
        }
        int oldBuildNumber = ConfigImportHelper.getBuildNumber(oldInstallHome);
        if (oldBuildNumber != -1 && oldBuildNumber <= 600) {
            return new File(oldInstallHome, "config");
        }
        return ConfigImportHelper.getOldPath(oldInstallHome, settings, "idea.config.path", new Function<String, String>(){

            public String fun(String pathsSelector) {
                return PathManager.getDefaultConfigPathFor((String)pathsSelector);
            }
        });
    }

    private static File getOldPath(File oldInstallHome, ConfigImportSettings settings, String propertyName, Function<String, String> fromPathSelector) {
        File[] launchFileCandidates;
        for (File candidate : launchFileCandidates = ConfigImportHelper.getLaunchFilesCandidates(oldInstallHome, settings)) {
            File probableConfig;
            String configDir;
            if (!candidate.exists() || (configDir = PathManager.substituteVars((String)ConfigImportHelper.getPropertyFromLaxFile(candidate, propertyName), (String)oldInstallHome.getPath())) == null || !(probableConfig = new File(configDir)).exists()) continue;
            return probableConfig;
        }
        for (File candidate : launchFileCandidates) {
            String configDir;
            File probableConfig;
            String pathsSelector;
            if (!candidate.exists() || (pathsSelector = ConfigImportHelper.getPropertyFromLaxFile(candidate, "idea.paths.selector")) == null || !(probableConfig = new File(configDir = (String)fromPathSelector.fun((Object)pathsSelector))).exists()) continue;
            return probableConfig;
        }
        return null;
    }

    private static File[] getLaunchFilesCandidates(@NotNull File instHome, @NotNull ConfigImportSettings settings) {
        if (instHome == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instHome", "com/intellij/openapi/application/ConfigImportHelper", "getLaunchFilesCandidates"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/openapi/application/ConfigImportHelper", "getLaunchFilesCandidates"));
        }
        File bin = new File(instHome, BIN_FOLDER);
        ArrayList<File> files = new ArrayList<File>();
        if (SystemInfo.isMac) {
            files.add(new File(new File(instHome, "Contents"), "Info.plist"));
            files.add(new File(new File(new File(bin, "idea.app"), "Contents"), "Info.plist"));
            files.add(new File(new File(new File(instHome, "idea.app"), "Contents"), "Info.plist"));
        }
        files.add(new File(bin, "idea.properties"));
        String executableName = StringUtil.toLowerCase((String)settings.getExecutableName());
        ConfigImportHelper.addLaunchExecutableScriptsCandidates(files, executableName, bin);
        files.addAll(settings.getCustomLaunchFilesCandidates(instHome, bin));
        if (!"idea".equals(executableName)) {
            ConfigImportHelper.addLaunchExecutableScriptsCandidates(files, "idea", bin);
        }
        return files.toArray(new File[files.size()]);
    }

    private static void addLaunchExecutableScriptsCandidates(List<File> files, String executableName, File binFolder) {
        files.add(new File(binFolder, executableName + ".lax"));
        files.add(new File(binFolder, executableName + ".bat"));
        files.add(new File(binFolder, executableName + ".sh"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static String getPropertyFromLaxFile(@NotNull File file, @NotNull String propertyName) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/application/ConfigImportHelper", "getPropertyFromLaxFile"));
        }
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "com/intellij/openapi/application/ConfigImportHelper", "getPropertyFromLaxFile"));
        }
        if (file.getName().endsWith(".properties")) {
            try {
                PropertyResourceBundle bundle;
                BufferedInputStream fis = new BufferedInputStream(new FileInputStream(file));
                try {
                    bundle = new PropertyResourceBundle(fis);
                }
                finally {
                    ((InputStream)fis).close();
                }
                if (bundle.containsKey(propertyName)) {
                    return bundle.getString(propertyName);
                }
                return null;
            }
            catch (IOException e) {
                return null;
            }
        }
        String fileContent = ConfigImportHelper.getContent(file);
        String propertyValue = ConfigImportHelper.findProperty(propertyName, fileContent);
        if (!StringUtil.isEmpty((String)propertyValue)) {
            return propertyValue;
        }
        return null;
    }

    @Nullable
    private static String findProperty(String propertyName, String fileContent) {
        String param = propertyName + "=";
        int idx = fileContent.indexOf(param);
        if (idx == -1) {
            param = "<key>" + propertyName + "</key>";
            idx = fileContent.indexOf(param);
            if (idx == -1) {
                return null;
            }
            if ((idx = fileContent.indexOf("<string>", idx)) == -1) {
                return null;
            }
            return ConfigImportHelper.fixDirName(fileContent.substring(idx += "<string>".length(), fileContent.indexOf("</string>", idx)), true);
        }
        String configDir = "";
        if (fileContent.length() > (idx += param.length())) {
            if (fileContent.charAt(idx) == '\"') {
                ++idx;
                while (fileContent.length() > idx && fileContent.charAt(idx) != '\"' && fileContent.charAt(idx) != '\n' && fileContent.charAt(idx) != '\r') {
                    configDir = configDir + fileContent.charAt(idx);
                    ++idx;
                }
            } else {
                while (fileContent.length() > idx && !Character.isSpaceChar(fileContent.charAt(idx)) && fileContent.charAt(idx) != '\n' && fileContent.charAt(idx) != '\r') {
                    configDir = configDir + fileContent.charAt(idx);
                    ++idx;
                }
            }
        }
        if ((configDir = ConfigImportHelper.fixDirName(configDir, true)).length() > 0) {
            configDir = new File(configDir).getPath();
        }
        return configDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static String getContent(File file) {
        try {
            StringBuilder content = new StringBuilder();
            BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
            try {
                String line;
                while ((line = reader.readLine()) != null) {
                    content.append(line);
                    content.append('\n');
                }
            }
            finally {
                reader.close();
            }
            return content.toString();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String fixDirName(String dir, boolean replaceUserHome) {
        if (StringUtil.startsWithChar((CharSequence)dir, (char)'\"') && StringUtil.endsWithChar((CharSequence)dir, (char)'\"')) {
            dir = dir.substring(1, dir.length() - 1);
        }
        if (replaceUserHome) {
            dir = FileUtil.expandUserHome((String)dir);
        }
        return dir;
    }

    public static boolean isInstallationHomeOrConfig(@NotNull String installationHome, @NotNull ConfigImportSettings settings) {
        File[] files;
        String[] mainJarNames;
        if (installationHome == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "installationHome", "com/intellij/openapi/application/ConfigImportHelper", "isInstallationHomeOrConfig"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/openapi/application/ConfigImportHelper", "isInstallationHomeOrConfig"));
        }
        if (new File(installationHome, OPTIONS_XML).exists()) {
            return true;
        }
        if (new File(installationHome, CONFIG_RELATED_PATH + OPTIONS_XML).exists()) {
            return true;
        }
        if (!new File(installationHome, BIN_FOLDER).exists()) {
            return false;
        }
        File libFolder = new File(installationHome, "lib");
        boolean quickTest = false;
        for (String name : mainJarNames = settings.getMainJarNames()) {
            String mainJarName = StringUtil.toLowerCase((String)name) + ".jar";
            if (!new File(libFolder, mainJarName).exists()) continue;
            quickTest = true;
            break;
        }
        if (!quickTest) {
            return false;
        }
        for (File file : files = ConfigImportHelper.getLaunchFilesCandidates(new File(installationHome), settings)) {
            if (!file.exists()) continue;
            return true;
        }
        return false;
    }

    private static int getBuildNumber(File installDirectory) {
        File buildTxt = new File(installDirectory = installDirectory.getAbsoluteFile(), BUILD_NUMBER_FILE);
        if (!buildTxt.exists() || buildTxt.isDirectory()) {
            buildTxt = new File(new File(installDirectory, BIN_FOLDER), BUILD_NUMBER_FILE);
        }
        if (buildTxt.exists() && !buildTxt.isDirectory()) {
            int buildNumber = -1;
            String buildNumberText = ConfigImportHelper.getContent(buildTxt);
            if (buildNumberText != null) {
                try {
                    if (buildNumberText.length() > 1) {
                        buildNumberText = buildNumberText.trim();
                        buildNumber = Integer.parseInt(buildNumberText);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return buildNumber;
        }
        return -1;
    }
}

