/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.highlighting;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diff.impl.ComparisonPolicy;
import com.intellij.openapi.diff.impl.ContentChangeListener;
import com.intellij.openapi.diff.impl.fragments.FragmentHighlighter;
import com.intellij.openapi.diff.impl.fragments.FragmentHighlighterImpl;
import com.intellij.openapi.diff.impl.fragments.FragmentList;
import com.intellij.openapi.diff.impl.fragments.FragmentListImpl;
import com.intellij.openapi.diff.impl.fragments.LineFragment;
import com.intellij.openapi.diff.impl.highlighting.EditorPlaceHolder;
import com.intellij.openapi.diff.impl.highlighting.FragmentSide;
import com.intellij.openapi.diff.impl.processing.DiffPolicy;
import com.intellij.openapi.diff.impl.processing.HighlightMode;
import com.intellij.openapi.diff.impl.processing.TextCompareProcessor;
import com.intellij.openapi.diff.impl.splitter.LineBlocks;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.diff.FilesTooBigForDiffException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SimpleDiffPanelState
implements Disposable {
    protected ComparisonPolicy myComparisonPolicy;
    protected DiffPolicy myDiffPolicy;
    protected HighlightMode myHighlightMode;
    protected final EditorPlaceHolder myAppender1;
    protected final EditorPlaceHolder myAppender2;
    protected FragmentList myFragmentList;
    protected final Project myProject;

    public SimpleDiffPanelState(Project project, ContentChangeListener changeListener, @NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/openapi/diff/impl/highlighting/SimpleDiffPanelState", "<init>"));
        }
        this.myComparisonPolicy = ComparisonPolicy.DEFAULT;
        this.myFragmentList = FragmentList.EMPTY;
        this.myAppender1 = this.createEditorWrapper(project, changeListener, FragmentSide.SIDE1);
        this.myAppender2 = this.createEditorWrapper(project, changeListener, FragmentSide.SIDE2);
        this.myProject = project;
        this.myDiffPolicy = DiffPolicy.LINES_WO_FORMATTING;
        this.myHighlightMode = HighlightMode.BY_WORD;
        Disposer.register((Disposable)parentDisposable, (Disposable)this);
    }

    private EditorPlaceHolder createEditorWrapper(Project project, ContentChangeListener changeListener, FragmentSide side) {
        EditorPlaceHolder editorWrapper = new EditorPlaceHolder(side, project, this);
        editorWrapper.addListener(changeListener);
        return editorWrapper;
    }

    public void setComparisonPolicy(@NotNull ComparisonPolicy comparisonPolicy) {
        if (comparisonPolicy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comparisonPolicy", "com/intellij/openapi/diff/impl/highlighting/SimpleDiffPanelState", "setComparisonPolicy"));
        }
        this.myComparisonPolicy = comparisonPolicy;
    }

    public void setDiffPolicy(DiffPolicy diffPolicy) {
        this.myDiffPolicy = diffPolicy;
    }

    public DiffPolicy getDiffPolicy() {
        return this.myDiffPolicy;
    }

    public ComparisonPolicy getComparisonPolicy() {
        return this.myComparisonPolicy;
    }

    public HighlightMode getHighlightMode() {
        return this.myHighlightMode;
    }

    public void setHighlightMode(HighlightMode highlightMode) {
        this.myHighlightMode = highlightMode;
    }

    public void dispose() {
    }

    private LineBlocks addMarkup(final List<LineFragment> lines) {
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                FragmentHighlighterImpl fragmentHighlighter = new FragmentHighlighterImpl(SimpleDiffPanelState.this.myAppender1, SimpleDiffPanelState.this.myAppender2);
                Iterator iterator = lines.iterator();
                while (iterator.hasNext()) {
                    LineFragment line = (LineFragment)iterator.next();
                    fragmentHighlighter.setIsLast(!iterator.hasNext());
                    line.highlight((FragmentHighlighter)fragmentHighlighter);
                }
            }
        });
        ArrayList<LineFragment> allLineFragments = new ArrayList<LineFragment>();
        for (LineFragment lineFragment : lines) {
            allLineFragments.add(lineFragment);
            lineFragment.addAllDescendantsTo(allLineFragments);
        }
        this.myFragmentList = FragmentListImpl.fromList(allLineFragments);
        return LineBlocks.fromLineFragments(allLineFragments);
    }

    private void resetMarkup() {
        ApplicationManager.getApplication().runWriteAction((Runnable)new ResetMarkupRunnable(this));
    }

    @Nullable
    public LineBlocks updateEditors() throws FilesTooBigForDiffException {
        this.resetMarkup();
        if (this.myAppender1.getEditor() == null || this.myAppender2.getEditor() == null) {
            return null;
        }
        return this.addMarkup(new TextCompareProcessor(this.myComparisonPolicy, this.myDiffPolicy, this.myHighlightMode).process(this.myAppender1.getText(), this.myAppender2.getText()));
    }

    public Project getProject() {
        return this.myProject;
    }

    public FragmentList getFragmentList() {
        return this.myFragmentList;
    }

    private static class ResetMarkupRunnable
    implements Runnable {
        private final SimpleDiffPanelState myState;

        public ResetMarkupRunnable(SimpleDiffPanelState state) {
            this.myState = state;
        }

        @Override
        public void run() {
            this.myState.myAppender1.resetHighlighters();
            this.myState.myAppender2.resetHighlighters();
        }
    }
}

