/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.colors.impl;

import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.colors.impl.AbstractColorsScheme;
import com.intellij.openapi.editor.colors.impl.EditorColorsSchemeImpl;
import com.intellij.openapi.editor.colors.impl.ReadOnlyColorsScheme;
import com.intellij.openapi.editor.markup.TextAttributes;
import java.awt.Color;
import java.awt.Font;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultColorsScheme
extends AbstractColorsScheme
implements ReadOnlyColorsScheme {
    private String myName;

    public DefaultColorsScheme() {
        super(null);
    }

    @Nullable
    public TextAttributes getAttributes(TextAttributesKey key) {
        if (key == null) {
            return null;
        }
        TextAttributes attrs = (TextAttributes)this.myAttributesMap.get(key);
        if (attrs == null) {
            if (key.getFallbackAttributeKey() != null && (attrs = this.getFallbackAttributes(key.getFallbackAttributeKey())) != null && !attrs.isFallbackEnabled()) {
                return attrs;
            }
            attrs = key.getDefaultAttributes();
        }
        return attrs;
    }

    @Nullable
    public Color getColor(ColorKey key) {
        if (key == null) {
            return null;
        }
        Color color = (Color)this.myColorsMap.get(key);
        return color != null ? color : key.getDefaultColor();
    }

    @Override
    public void readExternal(Element parentNode) {
        super.readExternal(parentNode);
        this.myName = parentNode.getAttributeValue("name");
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/colors/impl/DefaultColorsScheme", "getName"));
        }
        return string;
    }

    public void setAttributes(TextAttributesKey key, TextAttributes attributes) {
    }

    public void setColor(ColorKey key, Color color) {
    }

    @Override
    public void setFont(EditorFontType key, Font font) {
    }

    @Override
    public Object clone() {
        EditorColorsSchemeImpl newScheme = new EditorColorsSchemeImpl(this);
        this.copyTo(newScheme);
        newScheme.setName("Default");
        return newScheme;
    }
}

