/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.autoimport;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.externalSystem.ExternalSystemAutoImportAware;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTask;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskState;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskType;
import com.intellij.openapi.externalSystem.service.execution.ProgressExecutionMode;
import com.intellij.openapi.externalSystem.service.internal.ExternalSystemProcessingManager;
import com.intellij.openapi.externalSystem.service.project.ExternalProjectRefreshCallback;
import com.intellij.openapi.externalSystem.service.project.manage.ProjectDataManager;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemSettings;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemConstants;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.util.Alarm;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.messages.MessageBus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalSystemAutoImporter
implements BulkFileListener,
DocumentListener {
    @NotNull
    private final ConcurrentMap<ProjectSystemId, Set<String>> myFilesToRefresh;
    @NotNull
    private final Alarm myVfsAlarm;
    @NotNull
    private final ReadWriteLock myVfsLock;
    @NotNull
    private final Set<Document> myDocumentsToSave;
    @NotNull
    private final Alarm myDocumentAlarm;
    @NotNull
    private final ReadWriteLock myDocumentLock;
    @NotNull
    private final Runnable myFilesRequest;
    @NotNull
    private final Runnable myDocumentsSaveRequest;
    @NotNull
    private final ExternalProjectRefreshCallback myRefreshCallback;
    @NotNull
    private final Project myProject;
    @NotNull
    private final ProjectDataManager myProjectDataManager;
    @NotNull
    private final MyEntry[] myAutoImportAware;

    public ExternalSystemAutoImporter(@NotNull Project project, @NotNull ProjectDataManager projectDataManager, @NotNull MyEntry[] autoImportAware) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/service/project/autoimport/ExternalSystemAutoImporter", "<init>"));
        }
        if (projectDataManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectDataManager", "com/intellij/openapi/externalSystem/service/project/autoimport/ExternalSystemAutoImporter", "<init>"));
        }
        if (autoImportAware == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "autoImportAware", "com/intellij/openapi/externalSystem/service/project/autoimport/ExternalSystemAutoImporter", "<init>"));
        }
        this.myFilesToRefresh = ContainerUtil.newConcurrentMap();
        this.myVfsLock = new ReentrantReadWriteLock();
        this.myDocumentsToSave = ContainerUtilRt.newHashSet();
        this.myDocumentLock = new ReentrantReadWriteLock();
        this.myFilesRequest = new Runnable(){

            @Override
            public void run() {
                ExternalSystemAutoImporter.this.refreshFilesIfNecessary();
            }
        };
        this.myDocumentsSaveRequest = new Runnable(){

            @Override
            public void run() {
                ExternalSystemAutoImporter.this.saveDocumentsIfNecessary();
            }
        };
        this.myRefreshCallback = new ExternalProjectRefreshCallback(){

            @Override
            public void onSuccess(@Nullable DataNode<ProjectData> externalProject) {
                if (externalProject != null) {
                    ExternalSystemAutoImporter.this.myProjectDataManager.importData(externalProject, ExternalSystemAutoImporter.this.myProject, true);
                }
            }

            @Override
            public void onFailure(@NotNull String errorMessage, @Nullable String errorDetails) {
                if (errorMessage == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorMessage", "com/intellij/openapi/externalSystem/service/project/autoimport/ExternalSystemAutoImporter$3", "onFailure"));
                }
            }
        };
        this.myProject = project;
        this.myProjectDataManager = projectDataManager;
        this.myAutoImportAware = autoImportAware;
        this.myVfsAlarm = new Alarm(Alarm.ThreadToUse.SHARED_THREAD, (Disposable)project);
        this.myDocumentAlarm = new Alarm(Alarm.ThreadToUse.SHARED_THREAD, (Disposable)project);
    }

    public static void letTheMagicBegin(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/service/project/autoimport/ExternalSystemAutoImporter", "letTheMagicBegin"));
        }
        ArrayList autoImportAware = ContainerUtilRt.newArrayList();
        Collection managers = ExternalSystemApiUtil.getAllManagers();
        for (ExternalSystemManager manager : managers) {
            AbstractExternalSystemSettings systemSettings = (AbstractExternalSystemSettings)manager.getSettingsProvider().fun((Object)project);
            ExternalSystemAutoImportAware defaultImportAware = ExternalSystemAutoImporter.createDefault(systemSettings);
            ExternalSystemAutoImportAware aware = manager instanceof ExternalSystemAutoImportAware ? ExternalSystemAutoImporter.combine(defaultImportAware, (ExternalSystemAutoImportAware)manager) : defaultImportAware;
            autoImportAware.add(new MyEntry(manager.getSystemId(), systemSettings, aware));
        }
        MyEntry[] entries = autoImportAware.toArray(new MyEntry[autoImportAware.size()]);
        ExternalSystemAutoImporter autoImporter = new ExternalSystemAutoImporter(project, (ProjectDataManager)ServiceManager.getService(ProjectDataManager.class), entries);
        MessageBus messageBus = project.getMessageBus();
        messageBus.connect((Disposable)project).subscribe(VirtualFileManager.VFS_CHANGES, (Object)autoImporter);
        EditorFactory.getInstance().getEventMulticaster().addDocumentListener((DocumentListener)autoImporter, (Disposable)project);
    }

    @NotNull
    private static ExternalSystemAutoImportAware combine(final @NotNull ExternalSystemAutoImportAware aware1, final @NotNull ExternalSystemAutoImportAware aware2) {
        if (aware1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aware1", "com/intellij/openapi/externalSystem/service/project/autoimport/ExternalSystemAutoImporter", "combine"));
        }
        if (aware2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aware2", "com/intellij/openapi/externalSystem/service/project/autoimport/ExternalSystemAutoImporter", "combine"));
        }
        ExternalSystemAutoImportAware externalSystemAutoImportAware = new ExternalSystemAutoImportAware(){

            @Nullable
            public String getAffectedExternalProjectPath(@NotNull String changedFileOrDirPath, @NotNull Project project) {
                if (changedFileOrDirPath == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changedFileOrDirPath", "com/intellij/openapi/externalSystem/service/project/autoimport/ExternalSystemAutoImporter$4", "getAffectedExternalProjectPath"));
                }
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/service/project/autoimport/ExternalSystemAutoImporter$4", "getAffectedExternalProjectPath"));
                }
                String projectPath = aware1.getAffectedExternalProjectPath(changedFileOrDirPath, project);
                return projectPath == null ? aware2.getAffectedExternalProjectPath(changedFileOrDirPath, project) : projectPath;
            }
        };
        if (externalSystemAutoImportAware == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/autoimport/ExternalSystemAutoImporter", "combine"));
        }
        return externalSystemAutoImportAware;
    }

    @NotNull
    private static ExternalSystemAutoImportAware createDefault(final @NotNull AbstractExternalSystemSettings<?, ?, ?> systemSettings) {
        if (systemSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "systemSettings", "com/intellij/openapi/externalSystem/service/project/autoimport/ExternalSystemAutoImporter", "createDefault"));
        }
        ExternalSystemAutoImportAware externalSystemAutoImportAware = new ExternalSystemAutoImportAware(){

            @Nullable
            public String getAffectedExternalProjectPath(@NotNull String changedFileOrDirPath, @NotNull Project project) {
                if (changedFileOrDirPath == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changedFileOrDirPath", "com/intellij/openapi/externalSystem/service/project/autoimport/ExternalSystemAutoImporter$5", "getAffectedExternalProjectPath"));
                }
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/service/project/autoimport/ExternalSystemAutoImporter$5", "getAffectedExternalProjectPath"));
                }
                return systemSettings.getLinkedProjectSettings(changedFileOrDirPath) == null ? null : changedFileOrDirPath;
            }
        };
        if (externalSystemAutoImportAware == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/autoimport/ExternalSystemAutoImporter", "createDefault"));
        }
        return externalSystemAutoImportAware;
    }

    public void beforeDocumentChange(DocumentEvent event) {
    }

    public void documentChanged(DocumentEvent event) {
        Document document = event.getDocument();
        FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
        VirtualFile file = fileDocumentManager.getFile(document);
        if (file == null) {
            return;
        }
        String path = ExternalSystemApiUtil.getLocalFileSystemPath((VirtualFile)file);
        for (MyEntry entry : this.myAutoImportAware) {
            if (entry.aware.getAffectedExternalProjectPath(path, this.myProject) == null) continue;
            this.scheduleDocumentSave(document);
            return;
        }
    }

    private void scheduleDocumentSave(@NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/externalSystem/service/project/autoimport/ExternalSystemAutoImporter", "scheduleDocumentSave"));
        }
        Lock lock = this.myDocumentLock.readLock();
        lock.lock();
        try {
            this.myDocumentsToSave.add(document);
            if (this.myDocumentAlarm.getActiveRequestCount() <= 0) {
                this.myDocumentAlarm.addRequest(this.myDocumentsSaveRequest, 100);
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveDocumentsIfNecessary() {
        if (ApplicationManager.getApplication().isDisposed()) {
            return;
        }
        final FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
        Lock lock = this.myDocumentLock.writeLock();
        HashSet toKeep = ContainerUtilRt.newHashSet();
        final HashSet toSave = ContainerUtilRt.newHashSet();
        lock.lock();
        try {
            this.myDocumentAlarm.cancelAllRequests();
            for (Document document : this.myDocumentsToSave) {
                if (fileDocumentManager.isDocumentUnsaved(document)) {
                    toSave.add(document);
                    continue;
                }
                toKeep.add(document);
            }
            this.myDocumentsToSave.clear();
            if (!toSave.isEmpty()) {
                ExternalSystemAutoImporter.invokeLaterIfNeeded(new Runnable(){

                    @Override
                    public void run() {
                        for (Document document : toSave) {
                            fileDocumentManager.saveDocument(document);
                        }
                    }
                });
            }
            if (!toKeep.isEmpty()) {
                this.myDocumentsToSave.addAll(toKeep);
                this.myDocumentAlarm.addRequest(this.myDocumentsSaveRequest, 100);
            }
        }
        finally {
            lock.unlock();
        }
    }

    private static void invokeLaterIfNeeded(Runnable runnable2) {
        if (ApplicationManager.getApplication().isDispatchThread()) {
            runnable2.run();
        } else {
            ApplicationManager.getApplication().invokeLater(runnable2);
        }
    }

    public void before(@NotNull List<? extends VFileEvent> events) {
        if (events == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/intellij/openapi/externalSystem/service/project/autoimport/ExternalSystemAutoImporter", "before"));
        }
    }

    public void after(@NotNull List<? extends VFileEvent> events) {
        if (events == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/intellij/openapi/externalSystem/service/project/autoimport/ExternalSystemAutoImporter", "after"));
        }
        boolean scheduleRefresh = false;
        block0: for (VFileEvent vFileEvent : events) {
            String changedPath = vFileEvent.getPath();
            for (MyEntry entry : this.myAutoImportAware) {
                ExternalProjectSettings projectSettings;
                String projectPath = entry.aware.getAffectedExternalProjectPath(changedPath, this.myProject);
                if (projectPath == null || (projectSettings = entry.systemSettings.getLinkedProjectSettings(projectPath)) == null || !projectSettings.isUseAutoImport()) continue;
                this.addPath(entry.externalSystemId, projectPath);
                scheduleRefresh = true;
                continue block0;
            }
        }
        if (scheduleRefresh) {
            this.myVfsAlarm.cancelAllRequests();
            this.myVfsAlarm.addRequest(this.myFilesRequest, ExternalSystemConstants.AUTO_IMPORT_DELAY_MILLIS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addPath(@NotNull ProjectSystemId externalSystemId, @NotNull String path) {
        if (externalSystemId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalSystemId", "com/intellij/openapi/externalSystem/service/project/autoimport/ExternalSystemAutoImporter", "addPath"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/externalSystem/service/project/autoimport/ExternalSystemAutoImporter", "addPath"));
        }
        Lock lock = this.myVfsLock.readLock();
        lock.lock();
        try {
            Set paths = (Set)this.myFilesToRefresh.get(externalSystemId);
            while (paths == null) {
                this.myFilesToRefresh.putIfAbsent(externalSystemId, ContainerUtilRt.newHashSet());
                paths = (Set)this.myFilesToRefresh.get(externalSystemId);
            }
            paths.add(path);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshFilesIfNecessary() {
        if (this.myFilesToRefresh.isEmpty() || this.myProject.isDisposed()) {
            return;
        }
        HashMap copy = ContainerUtilRt.newHashMap();
        Lock fileLock = this.myVfsLock.writeLock();
        fileLock.lock();
        try {
            copy.putAll(this.myFilesToRefresh);
            this.myFilesToRefresh.clear();
        }
        finally {
            fileLock.unlock();
        }
        FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
        LocalFileSystem fileSystem = LocalFileSystem.getInstance();
        Lock documentLock = this.myDocumentLock.writeLock();
        documentLock.lock();
        try {
            for (Set paths : copy.values()) {
                for (String string : paths) {
                    Document document;
                    VirtualFile file = fileSystem.findFileByPath(string);
                    if (file == null || (document = fileDocumentManager.getCachedDocument(file)) == null) continue;
                    this.myDocumentsToSave.remove(document);
                }
            }
        }
        finally {
            documentLock.unlock();
        }
        boolean scheduleRefresh = false;
        ExternalSystemProcessingManager processingManager = (ExternalSystemProcessingManager)ServiceManager.getService(ExternalSystemProcessingManager.class);
        for (Map.Entry entry : copy.entrySet()) {
            for (String path : (Set)entry.getValue()) {
                ExternalSystemTaskState taskState;
                ExternalSystemTask resolveTask = processingManager.findTask(ExternalSystemTaskType.RESOLVE_PROJECT, (ProjectSystemId)entry.getKey(), path);
                ExternalSystemTaskState externalSystemTaskState = taskState = resolveTask == null ? null : resolveTask.getState();
                if (taskState == null || taskState.isStopped()) {
                    ExternalSystemUtil.refreshProject(this.myProject, (ProjectSystemId)entry.getKey(), path, this.myRefreshCallback, false, ProgressExecutionMode.IN_BACKGROUND_ASYNC, false);
                    continue;
                }
                if (taskState == ExternalSystemTaskState.NOT_STARTED) continue;
                scheduleRefresh = true;
                this.addPath((ProjectSystemId)entry.getKey(), path);
            }
        }
        if (scheduleRefresh) {
            this.myVfsAlarm.cancelAllRequests();
            this.myVfsAlarm.addRequest(this.myFilesRequest, ExternalSystemConstants.AUTO_IMPORT_DELAY_MILLIS);
        }
    }

    private static class MyEntry {
        @NotNull
        public final ProjectSystemId externalSystemId;
        @NotNull
        public final AbstractExternalSystemSettings<?, ?, ?> systemSettings;
        @NotNull
        public final ExternalSystemAutoImportAware aware;

        MyEntry(@NotNull ProjectSystemId externalSystemId, @NotNull AbstractExternalSystemSettings<?, ?, ?> systemSettings, @NotNull ExternalSystemAutoImportAware aware) {
            if (externalSystemId == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalSystemId", "com/intellij/openapi/externalSystem/service/project/autoimport/ExternalSystemAutoImporter$MyEntry", "<init>"));
            }
            if (systemSettings == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "systemSettings", "com/intellij/openapi/externalSystem/service/project/autoimport/ExternalSystemAutoImporter$MyEntry", "<init>"));
            }
            if (aware == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aware", "com/intellij/openapi/externalSystem/service/project/autoimport/ExternalSystemAutoImporter$MyEntry", "<init>"));
            }
            this.externalSystemId = externalSystemId;
            this.systemSettings = systemSettings;
            this.aware = aware;
        }
    }
}

