/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.manage;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.task.TaskData;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalSystemKeymapExtension;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.KeymapManagerListener;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalSystemShortcutsManager
implements Disposable {
    private static final String ACTION_ID_PREFIX = "ExternalSystem_";
    @NotNull
    private final Project myProject;
    private ExternalSystemKeyMapListener myKeyMapListener;
    private final List<Listener> myListeners;

    public ExternalSystemShortcutsManager(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/service/project/manage/ExternalSystemShortcutsManager", "<init>"));
        }
        this.myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myProject = project;
    }

    public void init() {
        this.myKeyMapListener = new ExternalSystemKeyMapListener();
    }

    public String getActionId(@Nullable String projectPath, @Nullable String taskName) {
        StringBuilder result2 = new StringBuilder(ACTION_ID_PREFIX);
        result2.append(this.myProject.getLocationHash());
        if (projectPath != null) {
            String portablePath = FileUtil.toSystemIndependentName((String)projectPath);
            File file = new File(portablePath);
            result2.append(file.isFile() && file.getParentFile() != null ? file.getParentFile().getName() : file.getName());
            result2.append(Integer.toHexString(portablePath.hashCode()));
            if (taskName != null) {
                result2.append(taskName);
            }
        }
        return result2.toString();
    }

    public String getDescription(@Nullable String projectPath, @Nullable String taskName) {
        Shortcut[] shortcuts = this.getShortcuts(projectPath, taskName);
        if (shortcuts.length == 0) {
            return "";
        }
        return KeymapUtil.getShortcutsText((Shortcut[])shortcuts);
    }

    public boolean hasShortcuts(@Nullable String projectPath, @Nullable String taskName) {
        return this.getShortcuts(projectPath, taskName).length > 0;
    }

    public boolean hasShortcuts(@NotNull String actionId) {
        if (actionId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionId", "com/intellij/openapi/externalSystem/service/project/manage/ExternalSystemShortcutsManager", "hasShortcuts"));
        }
        Keymap activeKeymap = KeymapManager.getInstance().getActiveKeymap();
        return activeKeymap.getShortcuts(actionId).length > 0;
    }

    @NotNull
    private Shortcut[] getShortcuts(@Nullable String projectPath, @Nullable String taskName) {
        String actionId = this.getActionId(projectPath, taskName);
        if (actionId == null) {
            if (Shortcut.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/manage/ExternalSystemShortcutsManager", "getShortcuts"));
            }
            return Shortcut.EMPTY_ARRAY;
        }
        Keymap activeKeymap = KeymapManager.getInstance().getActiveKeymap();
        Shortcut[] shortcutArray = activeKeymap.getShortcuts(actionId);
        if (shortcutArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/manage/ExternalSystemShortcutsManager", "getShortcuts"));
        }
        return shortcutArray;
    }

    private void fireShortcutsUpdated() {
        for (Listener listener : this.myListeners) {
            listener.shortcutsUpdated();
        }
    }

    public void addListener(Listener listener) {
        this.myListeners.add(listener);
    }

    public void scheduleKeymapUpdate(Collection<DataNode<TaskData>> taskData) {
        ExternalSystemKeymapExtension.updateActions(this.myProject, taskData);
    }

    public void scheduleRunConfigurationKeymapUpdate(@NotNull ProjectSystemId externalSystemId) {
        if (externalSystemId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalSystemId", "com/intellij/openapi/externalSystem/service/project/manage/ExternalSystemShortcutsManager", "scheduleRunConfigurationKeymapUpdate"));
        }
        ExternalSystemKeymapExtension.updateRunConfigurationActions(this.myProject, externalSystemId);
    }

    public void dispose() {
        if (this.myKeyMapListener != null) {
            this.myKeyMapListener.stopListen();
        }
        ExternalSystemKeymapExtension.clearActions(this.myProject);
    }

    private class ExternalSystemKeyMapListener
    implements KeymapManagerListener,
    Keymap.Listener {
        private Keymap myCurrentKeymap;

        private ExternalSystemKeyMapListener() {
            KeymapManager keymapManager = KeymapManager.getInstance();
            if (keymapManager != null) {
                this.listenTo(keymapManager.getActiveKeymap());
                keymapManager.addKeymapManagerListener((KeymapManagerListener)this, (Disposable)ExternalSystemShortcutsManager.this);
            }
        }

        public void activeKeymapChanged(Keymap keymap) {
            this.listenTo(keymap);
            ExternalSystemShortcutsManager.this.fireShortcutsUpdated();
        }

        private void listenTo(Keymap keymap) {
            if (this.myCurrentKeymap != null) {
                this.myCurrentKeymap.removeShortcutChangeListener((Keymap.Listener)this);
            }
            this.myCurrentKeymap = keymap;
            if (this.myCurrentKeymap != null) {
                this.myCurrentKeymap.addShortcutChangeListener((Keymap.Listener)this);
            }
        }

        public void onShortcutChanged(String actionId) {
            ExternalSystemShortcutsManager.this.fireShortcutsUpdated();
        }

        private void stopListen() {
            this.listenTo(null);
        }
    }

    public static interface Listener {
        public void shortcutsUpdated();
    }
}

