/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileTypes;

import com.intellij.ide.highlighter.custom.AbstractCustomLexer;
import com.intellij.ide.highlighter.custom.tokens.BraceTokenParser;
import com.intellij.ide.highlighter.custom.tokens.TokenParser;
import com.intellij.ide.highlighter.custom.tokens.WhitespaceParser;
import com.intellij.lexer.Lexer;
import com.intellij.lexer.MergingLexerAdapter;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterBase;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.CustomHighlighterTokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class PlainTextSyntaxHighlighterFactory
extends SyntaxHighlighterFactory {
    @NotNull
    public SyntaxHighlighter getSyntaxHighlighter(Project project, VirtualFile virtualFile) {
        SyntaxHighlighterBase syntaxHighlighterBase = new SyntaxHighlighterBase(){

            @NotNull
            public Lexer getHighlightingLexer() {
                Lexer lexer = PlainTextSyntaxHighlighterFactory.createPlainTextLexer();
                if (lexer == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileTypes/PlainTextSyntaxHighlighterFactory$1", "getHighlightingLexer"));
                }
                return lexer;
            }

            @NotNull
            public TextAttributesKey[] getTokenHighlights(IElementType tokenType) {
                if (EMPTY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileTypes/PlainTextSyntaxHighlighterFactory$1", "getTokenHighlights"));
                }
                return EMPTY;
            }
        };
        if (syntaxHighlighterBase == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileTypes/PlainTextSyntaxHighlighterFactory", "getSyntaxHighlighter"));
        }
        return syntaxHighlighterBase;
    }

    public static Lexer createPlainTextLexer() {
        ArrayList<TokenParser> tokenParsers = new ArrayList<TokenParser>();
        tokenParsers.add(new WhitespaceParser());
        tokenParsers.addAll(BraceTokenParser.getBraces());
        tokenParsers.addAll(BraceTokenParser.getParens());
        tokenParsers.addAll(BraceTokenParser.getBrackets());
        tokenParsers.addAll(BraceTokenParser.getAngleBrackets());
        return new MergingLexerAdapter((Lexer)new AbstractCustomLexer(tokenParsers), TokenSet.create((IElementType[])new IElementType[]{CustomHighlighterTokenType.CHARACTER}));
    }
}

