/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.keymap.impl.ui;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.MouseShortcut;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.keymap.KeyMapBundle;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.keymap.impl.ShortcutRestrictions;
import com.intellij.openapi.keymap.impl.ui.Group;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NotNull;

class MouseShortcutDialog
extends DialogWrapper {
    private final Keymap myKeymap;
    private final String myActionId;
    private final Group myMainGroup;
    private final JRadioButton myRbSingleClick;
    private final JRadioButton myRbDoubleClick;
    private final JLabel myLblPreview;
    private final MyClickPad myClickPad;
    private final JTextArea myTarConflicts;
    private int myButton;
    @JdkConstants.InputEventMask
    private int myModifiers;

    public MouseShortcutDialog(JComponent parentComponent, MouseShortcut shortcut, @NotNull Keymap keymap, @NotNull String actiondId, @NotNull Group mainGroup, @NotNull ShortcutRestrictions restrictions) {
        if (keymap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keymap", "com/intellij/openapi/keymap/impl/ui/MouseShortcutDialog", "<init>"));
        }
        if (actiondId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actiondId", "com/intellij/openapi/keymap/impl/ui/MouseShortcutDialog", "<init>"));
        }
        if (mainGroup == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mainGroup", "com/intellij/openapi/keymap/impl/ui/MouseShortcutDialog", "<init>"));
        }
        if (restrictions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "restrictions", "com/intellij/openapi/keymap/impl/ui/MouseShortcutDialog", "<init>"));
        }
        super((Component)parentComponent, true);
        this.setTitle(KeyMapBundle.message((String)"mouse.shortcut.dialog.title", (Object[])new Object[0]));
        this.myKeymap = keymap;
        this.myActionId = actiondId;
        this.myMainGroup = mainGroup;
        this.myRbSingleClick = new JRadioButton(KeyMapBundle.message((String)"mouse.shortcut.dialog.single.click.radio", (Object[])new Object[0]));
        this.myRbDoubleClick = new JRadioButton(KeyMapBundle.message((String)"mouse.shortcut.dialog.double.click.radio", (Object[])new Object[0]));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.myRbSingleClick);
        buttonGroup.add(this.myRbDoubleClick);
        this.myLblPreview = new JLabel(" ");
        this.myClickPad = new MyClickPad();
        this.myTarConflicts = new JTextArea();
        this.myTarConflicts.setFocusable(false);
        this.myTarConflicts.setEditable(false);
        this.myTarConflicts.setBackground(UIUtil.getPanelBackground());
        this.myTarConflicts.setLineWrap(true);
        this.myTarConflicts.setWrapStyleWord(true);
        if (shortcut != null) {
            if (shortcut.getClickCount() == 1) {
                this.myRbSingleClick.setSelected(true);
            } else {
                this.myRbDoubleClick.setSelected(true);
            }
            this.myButton = shortcut.getButton();
            this.myModifiers = shortcut.getModifiers();
        } else {
            this.myRbSingleClick.setSelected(true);
            this.myButton = -1;
            this.myModifiers = -1;
        }
        this.myRbDoubleClick.setEnabled(restrictions.allowMouseDoubleClick);
        this.updatePreviewAndConflicts();
        this.init();
    }

    public MouseShortcut getMouseShortcut() {
        if (this.myButton > 3 && this.myButton != 143 && this.myButton != 142 && this.getClickCount() == 2) {
            return null;
        }
        if (this.myButton != -1 && this.myModifiers != -1) {
            return new MouseShortcut(this.myButton, this.myModifiers, this.getClickCount());
        }
        return null;
    }

    protected String getHelpId() {
        return "preferences.mouse.shortcut";
    }

    protected JComponent createCenterPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        JPanel clickCountPanel = new JPanel(new GridBagLayout());
        clickCountPanel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)KeyMapBundle.message((String)"mouse.shortcut.dialog.click.count.border", (Object[])new Object[0]), (boolean)true));
        panel.add((Component)clickCountPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        clickCountPanel.add((Component)this.myRbSingleClick, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 10), 0, 0));
        clickCountPanel.add((Component)this.myRbDoubleClick, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MouseShortcutDialog.this.updatePreviewAndConflicts();
            }
        };
        this.myRbSingleClick.addActionListener(listener);
        this.myRbDoubleClick.addActionListener(listener);
        JPanel clickPadPanel = new JPanel(new BorderLayout());
        panel.add((Component)clickPadPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 4, 0), 0, 0));
        clickPadPanel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)KeyMapBundle.message((String)"mouse.shortcut.dialog.click.pad.border", (Object[])new Object[0]), (boolean)true));
        this.myClickPad.setPreferredSize((Dimension)JBUI.size((int)260, (int)60));
        clickPadPanel.add((Component)this.myClickPad, "Center");
        JPanel previewPanel = new JPanel(new GridBagLayout());
        previewPanel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)KeyMapBundle.message((String)"mouse.shortcut.dialog.shortcut.preview.border", (Object[])new Object[0]), (boolean)true));
        panel.add((Component)previewPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 4, 0), 0, 0));
        previewPanel.add((Component)this.myLblPreview, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 2, 2, 2), 0, 0));
        JPanel conflictsPanel = new JPanel(new GridBagLayout());
        conflictsPanel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)KeyMapBundle.message((String)"mouse.shortcut.dialog.conflicts.border", (Object[])new Object[0]), (boolean)true));
        panel.add((Component)conflictsPanel, new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.myTarConflicts.setPreferredSize((Dimension)JBUI.size((int)260, (int)60));
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)this.myTarConflicts);
        scrollPane.setBorder(null);
        conflictsPanel.add((Component)scrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    private int getClickCount() {
        return this.myRbSingleClick.isSelected() ? 1 : 2;
    }

    private void updatePreviewAndConflicts() {
        String[] actionIds;
        if (this.myButton == -1 || this.myModifiers == -1) {
            return;
        }
        this.myTarConflicts.setText(null);
        this.myLblPreview.setText(KeymapUtil.getMouseShortcutText((int)this.myButton, (int)this.myModifiers, (int)this.getClickCount()) + " ");
        MouseShortcut mouseShortcut = new MouseShortcut(this.myButton, this.myModifiers, this.getClickCount());
        if (this.myButton > 3 && this.getClickCount() == 2) {
            this.myTarConflicts.setForeground((Color)JBColor.RED);
            this.myTarConflicts.setText(KeyMapBundle.message((String)"mouse.shortcut.dialog.side.buttons.with.double.click", (Object[])new Object[]{this.myButton}));
            return;
        }
        StringBuilder buffer = new StringBuilder();
        block0: for (String actionId : actionIds = this.myKeymap.getActionIds(mouseShortcut)) {
            Shortcut[] shortcuts;
            String actionPath;
            if (actionId.equals(this.myActionId) || (actionPath = this.myMainGroup.getActionQualifiedPath(actionId)) == null) continue;
            for (Shortcut shortcut1 : shortcuts = this.myKeymap.getShortcuts(actionId)) {
                MouseShortcut shortcut;
                if (!(shortcut1 instanceof MouseShortcut) || (shortcut = (MouseShortcut)shortcut1).getButton() != mouseShortcut.getButton() || shortcut.getModifiers() != mouseShortcut.getModifiers()) continue;
                if (buffer.length() > 1) {
                    buffer.append('\n');
                }
                buffer.append('[');
                buffer.append(actionPath);
                buffer.append(']');
                continue block0;
            }
        }
        if (buffer.length() == 0) {
            this.myTarConflicts.setForeground(UIUtil.getTextAreaForeground());
            this.myTarConflicts.setText(KeyMapBundle.message((String)"mouse.shortcut.dialog.no.conflicts.area", (Object[])new Object[0]));
        } else {
            this.myTarConflicts.setForeground((Color)JBColor.RED);
            this.myTarConflicts.setText(KeyMapBundle.message((String)"mouse.shortcut.dialog.assigned.to.area", (Object[])new Object[]{buffer.toString()}));
        }
    }

    private class MyClickPad
    extends JLabel {
        public MyClickPad() {
            super(KeyMapBundle.message((String)"mouse.shortcut.label", (Object[])new Object[0]), AllIcons.General.Mouse, 0);
            MouseAdapter adapter = new MouseAdapter(){

                @Override
                public void mouseWheelMoved(MouseWheelEvent e) {
                    this.mouseReleased(e);
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    Component component = SwingUtilities.getDeepestComponentAt(e.getComponent(), e.getX(), e.getY());
                    if (component == MyClickPad.this) {
                        e.consume();
                        MouseShortcutDialog.this.myButton = MouseShortcut.getButton((MouseEvent)e);
                        MouseShortcutDialog.this.myModifiers = e.getModifiersEx();
                        MouseShortcutDialog.this.updatePreviewAndConflicts();
                    }
                }
            };
            Window window = MouseShortcutDialog.this.getPeer().getWindow();
            window.addMouseListener(adapter);
            window.addMouseWheelListener(adapter);
        }
    }
}

