/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.module.impl.scopes;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.impl.ModuleScopeProvider;
import com.intellij.openapi.module.impl.scopes.ModuleWithDependenciesScope;
import com.intellij.openapi.module.impl.scopes.ModuleWithDependentsScope;
import com.intellij.openapi.module.impl.scopes.ModuleWithDependentsTestScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.ConcurrentIntObjectMap;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.NotNull;

public class ModuleScopeProviderImpl
implements ModuleScopeProvider {
    private final Module myModule;
    private final ConcurrentIntObjectMap<GlobalSearchScope> myScopeCache;
    private ModuleWithDependentsTestScope myModuleTestsWithDependentsScope;

    public ModuleScopeProviderImpl(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/openapi/module/impl/scopes/ModuleScopeProviderImpl", "<init>"));
        }
        this.myScopeCache = ContainerUtil.createConcurrentIntObjectMap();
        this.myModule = module;
    }

    @NotNull
    private GlobalSearchScope getCachedScope(@ModuleWithDependenciesScope.ScopeConstant int options) {
        GlobalSearchScope scope = (GlobalSearchScope)this.myScopeCache.get(options);
        if (scope == null) {
            scope = new ModuleWithDependenciesScope(this.myModule, options);
            this.myScopeCache.put(options, (Object)scope);
        }
        GlobalSearchScope globalSearchScope = scope;
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/scopes/ModuleScopeProviderImpl", "getCachedScope"));
        }
        return globalSearchScope;
    }

    @Override
    @NotNull
    public GlobalSearchScope getModuleScope() {
        GlobalSearchScope globalSearchScope = this.getCachedScope(9);
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/scopes/ModuleScopeProviderImpl", "getModuleScope"));
        }
        return globalSearchScope;
    }

    @Override
    @NotNull
    public GlobalSearchScope getModuleScope(boolean includeTests) {
        GlobalSearchScope globalSearchScope = this.getCachedScope(1 | (includeTests ? 8 : 0));
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/scopes/ModuleScopeProviderImpl", "getModuleScope"));
        }
        return globalSearchScope;
    }

    @Override
    @NotNull
    public GlobalSearchScope getModuleWithLibrariesScope() {
        GlobalSearchScope globalSearchScope = this.getCachedScope(11);
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/scopes/ModuleScopeProviderImpl", "getModuleWithLibrariesScope"));
        }
        return globalSearchScope;
    }

    @Override
    @NotNull
    public GlobalSearchScope getModuleWithDependenciesScope() {
        GlobalSearchScope globalSearchScope = this.getCachedScope(13);
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/scopes/ModuleScopeProviderImpl", "getModuleWithDependenciesScope"));
        }
        return globalSearchScope;
    }

    @Override
    @NotNull
    public GlobalSearchScope getModuleContentScope() {
        GlobalSearchScope globalSearchScope = this.getCachedScope(32);
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/scopes/ModuleScopeProviderImpl", "getModuleContentScope"));
        }
        return globalSearchScope;
    }

    @Override
    @NotNull
    public GlobalSearchScope getModuleContentWithDependenciesScope() {
        GlobalSearchScope globalSearchScope = this.getCachedScope(36);
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/scopes/ModuleScopeProviderImpl", "getModuleContentWithDependenciesScope"));
        }
        return globalSearchScope;
    }

    @Override
    @NotNull
    public GlobalSearchScope getModuleWithDependenciesAndLibrariesScope(boolean includeTests) {
        GlobalSearchScope globalSearchScope = this.getCachedScope(7 | (includeTests ? 8 : 0));
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/scopes/ModuleScopeProviderImpl", "getModuleWithDependenciesAndLibrariesScope"));
        }
        return globalSearchScope;
    }

    @Override
    @NotNull
    public GlobalSearchScope getModuleWithDependentsScope() {
        ModuleWithDependentsScope moduleWithDependentsScope = this.getModuleTestsWithDependentsScope().getBaseScope();
        if (moduleWithDependentsScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/scopes/ModuleScopeProviderImpl", "getModuleWithDependentsScope"));
        }
        return moduleWithDependentsScope;
    }

    @NotNull
    public ModuleWithDependentsTestScope getModuleTestsWithDependentsScope() {
        ModuleWithDependentsTestScope scope = this.myModuleTestsWithDependentsScope;
        if (scope == null) {
            this.myModuleTestsWithDependentsScope = scope = new ModuleWithDependentsTestScope(this.myModule);
        }
        ModuleWithDependentsTestScope moduleWithDependentsTestScope = scope;
        if (moduleWithDependentsTestScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/scopes/ModuleScopeProviderImpl", "getModuleTestsWithDependentsScope"));
        }
        return moduleWithDependentsTestScope;
    }

    @Override
    @NotNull
    public GlobalSearchScope getModuleRuntimeScope(boolean includeTests) {
        GlobalSearchScope globalSearchScope = this.getCachedScope(6 | (includeTests ? 8 : 0));
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/module/impl/scopes/ModuleScopeProviderImpl", "getModuleRuntimeScope"));
        }
        return globalSearchScope;
    }

    @Override
    public void clearCache() {
        this.myScopeCache.clear();
        this.myModuleTestsWithDependentsScope = null;
    }
}

