/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.util.ExecUtil;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileSystemTree;
import com.intellij.openapi.fileChooser.actions.FileChooserAction;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.impl.JavaSdkImpl;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.Component;
import java.awt.event.InputEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JdkPopupAction
extends AnAction {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.fileChooser.actions.JDKPopupAction");

    public JdkPopupAction() {
        super("Show Quick list", "", AllIcons.General.AddJdk);
    }

    public void update(AnActionEvent e) {
        FileSystemTree tree;
        boolean enabled = JdkPopupAction.isEnabledInCurrentOS();
        if (enabled && ((tree = (FileSystemTree)FileSystemTree.DATA_KEY.getData(e.getDataContext())) == null || Boolean.TRUE != tree.getData(JavaSdkImpl.KEY))) {
            enabled = false;
        }
        e.getPresentation().setEnabled(enabled);
        e.getPresentation().setVisible(enabled);
    }

    public void actionPerformed(final AnActionEvent e) {
        boolean showInMiddle;
        JComponent component;
        Object source;
        InputEvent inputEvent = e.getInputEvent();
        Object object = source = inputEvent != null ? inputEvent.getSource() : null;
        if (source instanceof JComponent) {
            component = (JComponent)source;
            showInMiddle = false;
        } else {
            Component c = (Component)e.getData(PlatformDataKeys.CONTEXT_COMPONENT);
            component = c instanceof JComponent ? (JComponent)c : null;
            showInMiddle = true;
        }
        if (!JdkPopupAction.isEnabledInCurrentOS() || component == null) {
            return;
        }
        ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable(){

            @Override
            public void run() {
                final ArrayList jdkLocations = JdkPopupAction.retrieveJDKLocations();
                if (jdkLocations.isEmpty()) {
                    return;
                }
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JdkPopupAction.showPopupMenu(e, jdkLocations, showInMiddle, component);
                    }
                });
            }
        }, "Looking for JDK locations...", false, e.getProject(), component);
    }

    private static boolean isEnabledInCurrentOS() {
        return SystemInfo.isWindows;
    }

    private static void showPopupMenu(AnActionEvent e, final ArrayList<Pair<File, String>> jdkLocations, boolean showInMiddle, JComponent component) {
        ActionPopupMenu menu = ActionManager.getInstance().createActionPopupMenu(e.getPlace(), new ActionGroup(){

            @NotNull
            public AnAction[] getChildren(@Nullable AnActionEvent e) {
                ArrayList<1> result2 = new ArrayList<1>();
                for (final Pair homes : jdkLocations) {
                    result2.add(new FileChooserAction("", null, null){

                        @Override
                        protected void update(FileSystemTree fileChooser, AnActionEvent e) {
                            e.getPresentation().setText((String)homes.getSecond(), false);
                            boolean selected = false;
                            VirtualFile selectedFile = fileChooser.getSelectedFile();
                            if (selectedFile != null) {
                                selected = ((File)homes.getFirst()).getAbsolutePath().equals(VfsUtilCore.virtualToIoFile((VirtualFile)selectedFile).getAbsolutePath());
                            }
                            e.getPresentation().setIcon(selected ? AllIcons.Diff.CurrentLine : null);
                        }

                        @Override
                        protected void actionPerformed(FileSystemTree fileChooser, AnActionEvent e) {
                            fileChooser.select(VfsUtil.findFileByIoFile((File)((File)homes.getFirst()), (boolean)true), null);
                        }
                    });
                }
                AnAction[] anActionArray = result2.toArray(new AnAction[result2.size()]);
                if (anActionArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/projectRoots/JdkPopupAction$2", "getChildren"));
                }
                return anActionArray;
            }
        });
        JPopupMenu menuComponent = menu.getComponent();
        if (showInMiddle) {
            menuComponent.show(component, (component.getWidth() - menuComponent.getWidth()) / 2, (component.getHeight() - menuComponent.getHeight()) / 2);
        } else {
            menuComponent.show(component, 0, component.getHeight());
        }
    }

    private static ArrayList<Pair<File, String>> retrieveJDKLocations() {
        ArrayList<Pair<File, String>> jdkLocations = new ArrayList<Pair<File, String>>();
        Collection homePaths = JavaSdk.getInstance().suggestHomePaths();
        for (String path : homePaths) {
            try {
                File file = new File(path);
                File javaExe = new File(new File(file, "bin"), "java.exe");
                ProcessOutput output = ExecUtil.execAndGetOutput((GeneralCommandLine)new GeneralCommandLine(new String[]{javaExe.getAbsolutePath(), "-version"}));
                List lines = output.getStderrLines();
                if (lines.isEmpty()) {
                    lines = output.getStdoutLines();
                }
                StringBuilder stringBuilder = new StringBuilder();
                if (lines.size() == 3) {
                    stringBuilder.append("JDK ");
                    String line = (String)lines.get(1);
                    int pos = line.indexOf("(build ");
                    if (pos != -1) {
                        stringBuilder.append(line.substring(pos + 7, line.length() - 1));
                    }
                    if ((pos = (line = (String)lines.get(2)).indexOf(" (build")) != -1) {
                        String substring = line.substring(0, pos);
                        stringBuilder.append(" (").append(substring).append(")");
                    }
                } else {
                    stringBuilder.append(file.getName());
                }
                jdkLocations.add((Pair<File, String>)Pair.create((Object)file, (Object)stringBuilder.toString()));
            }
            catch (ExecutionException e) {
                LOG.debug((Throwable)e);
            }
        }
        return jdkLocations;
    }
}

