/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs;

import com.intellij.util.containers.ReadonlyList;
import com.intellij.util.containers.StepList;
import java.util.ArrayList;
import java.util.List;

public class BigArray<T>
implements StepList<T> {
    private final int mySize2Power;
    private final List<ArrayList<T>> myList;
    private int myPack;
    private int mySize;

    public BigArray(int size2Power) {
        assert (size2Power > 1 && size2Power < 16);
        this.mySize2Power = size2Power;
        this.myList = new ArrayList<ArrayList<T>>();
        this.myPack = (int)Math.pow(2.0, size2Power);
        this.mySize = 0;
    }

    public T get(int idx) {
        int itemNumber = idx >> this.mySize2Power;
        return this.myList.get(itemNumber).get(idx ^ itemNumber << this.mySize2Power);
    }

    public void add(T t) {
        ArrayList<T> commits;
        if (this.myList.isEmpty() || this.myList.get(this.myList.size() - 1).size() == this.myPack) {
            commits = new ArrayList<T>(this.myPack);
            this.myList.add(commits);
        } else {
            commits = this.myList.get(this.myList.size() - 1);
        }
        ++this.mySize;
        commits.add(t);
    }

    public ReadonlyList<T> cut(int idxFromIncluded) {
        if (idxFromIncluded >= this.getSize()) {
            return ReadonlyList.EMPTY;
        }
        int itemNumber = idxFromIncluded >> this.mySize2Power;
        int insideIdx = idxFromIncluded ^ itemNumber << this.mySize2Power;
        ArrayList<T> start = this.myList.get(itemNumber);
        NotRegularReadonlyList result2 = new NotRegularReadonlyList(new ArrayList<ArrayList<T>>(this.myList.subList(itemNumber + 1, this.myList.size())), this.mySize2Power, start.subList(insideIdx, start.size()));
        this.myList.set(itemNumber, new ArrayList<T>(start.subList(0, insideIdx)));
        for (int i = this.myList.size() - 1; i > itemNumber; --i) {
            this.myList.remove(i);
        }
        this.mySize = this.myList.isEmpty() ? 0 : (this.myList.size() - 1) * this.myPack + this.myList.get(this.myList.size() - 1).size();
        return result2;
    }

    public void ensureCapacity(int minCapacity) {
    }

    public int getSize() {
        return this.mySize;
    }

    public void clear() {
        this.myList.clear();
        this.mySize = 0;
    }

    private static class NotRegularReadonlyList<T>
    implements ReadonlyList<T> {
        private final int mySize2Power;
        private final List<T> myStart;
        private final List<ArrayList<T>> myList;
        private int myPack;

        private NotRegularReadonlyList(List<ArrayList<T>> list, int size2Power, List<T> start) {
            this.myList = list;
            this.mySize2Power = size2Power;
            this.myStart = start;
            this.myPack = (int)Math.pow(2.0, size2Power);
        }

        public T get(int idx) {
            if (idx < this.myStart.size()) {
                return this.myStart.get(idx);
            }
            int corrected = idx - this.myStart.size();
            int itemNumber = corrected >> this.mySize2Power;
            return this.myList.get(itemNumber).get(corrected ^ itemNumber << this.mySize2Power);
        }

        public int getSize() {
            if (this.myList.isEmpty()) {
                return this.myStart.size();
            }
            return (this.myList.size() - 1) * this.myPack + this.myList.get(this.myList.size() - 1).size() + this.myStart.size();
        }
    }
}

