/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.issueLinks;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vcs.IssueNavigationConfiguration;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.Consumer;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;

public class IssueLinkRenderer {
    private final SimpleColoredComponent myColoredComponent;
    private final IssueNavigationConfiguration myIssueNavigationConfiguration;

    public IssueLinkRenderer(Project project, SimpleColoredComponent coloredComponent) {
        this.myColoredComponent = coloredComponent;
        this.myIssueNavigationConfiguration = IssueNavigationConfiguration.getInstance((Project)project);
    }

    public List<String> appendTextWithLinks(String text) {
        return this.appendTextWithLinks(text, SimpleTextAttributes.REGULAR_ATTRIBUTES);
    }

    public List<String> appendTextWithLinks(String text, final SimpleTextAttributes baseStyle) {
        return this.appendTextWithLinks(text, baseStyle, new Consumer<String>(){

            public void consume(String s) {
                IssueLinkRenderer.this.append(s, baseStyle);
            }
        });
    }

    public List<String> appendTextWithLinks(String text, SimpleTextAttributes baseStyle, Consumer<String> consumer) {
        ArrayList<String> pieces = new ArrayList<String>();
        List list = this.myIssueNavigationConfiguration.findIssueLinks((CharSequence)text);
        int pos = 0;
        SimpleTextAttributes linkAttributes = IssueLinkRenderer.getLinkAttributes(baseStyle);
        for (IssueNavigationConfiguration.LinkMatch match : list) {
            String piece;
            TextRange textRange = match.getRange();
            if (textRange.getStartOffset() > pos) {
                piece = text.substring(pos, textRange.getStartOffset());
                pieces.add(piece);
                consumer.consume((Object)piece);
            }
            piece = textRange.substring(text);
            pieces.add(piece);
            this.append(piece, linkAttributes, match);
            pos = textRange.getEndOffset();
        }
        if (pos < text.length()) {
            String piece = text.substring(pos);
            pieces.add(piece);
            consumer.consume((Object)piece);
        }
        return pieces;
    }

    private void append(String piece, SimpleTextAttributes baseStyle) {
        this.myColoredComponent.append(piece, baseStyle);
    }

    private void append(String piece, SimpleTextAttributes baseStyle, IssueNavigationConfiguration.LinkMatch match) {
        this.myColoredComponent.append(piece, baseStyle, (Object)new SimpleColoredComponent.BrowserLauncherTag(match.getTargetUrl()));
    }

    private static SimpleTextAttributes getLinkAttributes(SimpleTextAttributes baseStyle) {
        Color color = baseStyle.getFgColor();
        int alpha = color != null ? color.getAlpha() : 255;
        Color resultColor = new Color(JBColor.blue.getRed(), JBColor.blue.getGreen(), JBColor.blue.getBlue(), alpha);
        return new SimpleTextAttributes(baseStyle.getStyle() | 0x10, resultColor);
    }
}

