/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.configurable;

import com.intellij.ide.ui.OptionsTopHitProvider;
import com.intellij.ide.ui.PublicFieldBasedOptionDescription;
import com.intellij.ide.ui.PublicMethodBasedOptionDescription;
import com.intellij.ide.ui.search.BooleanOptionDescription;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.contentAnnotation.VcsContentAnnotationSettings;
import com.intellij.openapi.vcs.readOnlyHandler.ReadonlyStatusHandlerImpl;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class VcsOptionsTopHitProvider
extends OptionsTopHitProvider {
    @Override
    public String getId() {
        return "vcs";
    }

    @Override
    @NotNull
    public Collection<BooleanOptionDescription> getOptions(@Nullable Project project) {
        if (project == null || ProjectLevelVcsManager.getInstance((Project)project).getAllVcss().length == 0) {
            List<BooleanOptionDescription> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/configurable/VcsOptionsTopHitProvider", "getOptions"));
            }
            return list;
        }
        VcsConfiguration vcs = VcsConfiguration.getInstance((Project)project);
        if (vcs == null) {
            List<BooleanOptionDescription> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/configurable/VcsOptionsTopHitProvider", "getOptions"));
            }
            return list;
        }
        ArrayList<BooleanOptionDescription> options = new ArrayList<BooleanOptionDescription>();
        String id = "project.propVCSSupport.Mappings";
        options.add(VcsOptionsTopHitProvider.option(vcs, id, "Limit history by " + vcs.MAXIMUM_HISTORY_ROWS + " rows", "LIMIT_HISTORY"));
        options.add(VcsOptionsTopHitProvider.option(vcs, id, "Show directories with changed descendants", "SHOW_DIRTY_RECURSIVELY"));
        options.add(VcsOptionsTopHitProvider.option(vcs, id, "Store on shelf base revision texts for files under DVCS", "INCLUDE_TEXT_INTO_SHELF"));
        VcsContentAnnotationSettings vcsCA = VcsContentAnnotationSettings.getInstance((Project)project);
        if (vcsCA != null) {
            options.add(VcsOptionsTopHitProvider.option(vcsCA, id, "Show changed in last " + vcsCA.getLimitDays() + " days", "isShow", "setShow"));
        }
        options.add(VcsOptionsTopHitProvider.option(vcs, id, "Notify about VCS root errors", "SHOW_VCS_ERROR_NOTIFICATIONS"));
        options.add(VcsOptionsTopHitProvider.option(vcs, id, "Commit message right margin " + vcs.COMMIT_MESSAGE_MARGIN_SIZE + " columns", "USE_COMMIT_MESSAGE_MARGIN"));
        options.add(VcsOptionsTopHitProvider.option(vcs, id, ApplicationBundle.message((String)"checkbox.wrap.typing.on.right.margin", (Object[])new Object[0]), "WRAP_WHEN_TYPING_REACHES_RIGHT_MARGIN"));
        id = "project.propVCSSupport.Confirmation";
        ReadonlyStatusHandler vcsROSH = ReadonlyStatusHandler.getInstance((Project)project);
        if (vcsROSH instanceof ReadonlyStatusHandlerImpl) {
            options.add(VcsOptionsTopHitProvider.option(((ReadonlyStatusHandlerImpl)vcsROSH).getState(), id, "Show \"Clear Read-only Status\" Dialog", "SHOW_DIALOG"));
        }
        options.add(VcsOptionsTopHitProvider.option(vcs, id, "Confirmation: Suggest to move uncommitted changes to another changelist", "OFFER_MOVE_TO_ANOTHER_CHANGELIST_ON_PARTIAL_COMMIT"));
        options.add(VcsOptionsTopHitProvider.option(vcs, id, "Confirmation: Force non-empty checkin comments", "FORCE_NON_EMPTY_COMMENT"));
        options.add(VcsOptionsTopHitProvider.option(vcs, id, "Confirmation: Clear initial commit message", "CLEAR_INITIAL_COMMIT_MESSAGE"));
        id = "project.propVCSSupport.Background";
        options.add(VcsOptionsTopHitProvider.option(vcs, id, "Perform in background: update from VCS", "PERFORM_UPDATE_IN_BACKGROUND"));
        options.add(VcsOptionsTopHitProvider.option(vcs, id, "Perform in background: commit to VCS", "PERFORM_COMMIT_IN_BACKGROUND"));
        options.add(VcsOptionsTopHitProvider.option(vcs, id, "Perform in background: checkout from VCS", "PERFORM_CHECKOUT_IN_BACKGROUND"));
        options.add(VcsOptionsTopHitProvider.option(vcs, id, "Perform in background: Edit/Checkout", "PERFORM_EDIT_IN_BACKGROUND"));
        options.add(VcsOptionsTopHitProvider.option(vcs, id, "Perform in background: Add/Remove", "PERFORM_ADD_REMOVE_IN_BACKGROUND"));
        options.add(VcsOptionsTopHitProvider.option(vcs, id, "Perform in background: revert", "PERFORM_ROLLBACK_IN_BACKGROUND"));
        if (!project.isDefault()) {
            options.add(VcsOptionsTopHitProvider.tracker(project, "Changelists: Enable changelist conflict tracking", "TRACKING_ENABLED"));
            options.add(VcsOptionsTopHitProvider.tracker(project, "Changelists: Show conflict resolving dialog", "SHOW_DIALOG"));
            options.add(VcsOptionsTopHitProvider.tracker(project, "Changelists: Highlight files with conflicts", "HIGHLIGHT_CONFLICTS"));
            options.add(VcsOptionsTopHitProvider.tracker(project, "Changelists: Highlight files from non-active changelists", "HIGHLIGHT_NON_ACTIVE_CHANGELIST"));
        }
        Collection<BooleanOptionDescription> collection = Collections.unmodifiableCollection(options);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/configurable/VcsOptionsTopHitProvider", "getOptions"));
        }
        return collection;
    }

    private static BooleanOptionDescription option(final Object instance, String id, String option, String field) {
        return new PublicFieldBasedOptionDescription(option, id, field){

            public Object getInstance() {
                return instance;
            }
        };
    }

    private static BooleanOptionDescription option(final Object instance, String id, String option, String getter, String setter) {
        return new PublicMethodBasedOptionDescription(option, id, getter, setter){

            public Object getInstance() {
                return instance;
            }
        };
    }

    private static BooleanOptionDescription tracker(final Project project, String option, String field) {
        return new PublicFieldBasedOptionDescription(option, "project.propVCSSupport.ChangelistConflict", field){

            public Object getInstance() {
                return ChangeListManagerImpl.getInstanceImpl(project).getConflictTracker().getOptions();
            }

            protected void fireUpdated() {
                ChangeListManagerImpl.getInstanceImpl(project).getConflictTracker().optionsChanged();
            }
        };
    }
}

