/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.update;

import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class GroupByPackages {
    private final Map<File, Collection<File>> myParentToChildrenMap;
    private final Collection<File> myRoots;

    public GroupByPackages(@NotNull Collection<File> files) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/openapi/vcs/update/GroupByPackages", "<init>"));
        }
        this.myParentToChildrenMap = new HashMap<File, Collection<File>>();
        this.myRoots = new HashSet<File>();
        for (File file : files) {
            this.process(file);
        }
        this.splitRoots();
    }

    private void splitRoots() {
        for (File oldRoot : new ArrayList<File>(this.myRoots)) {
            File newRoot;
            if (oldRoot.equals(newRoot = this.splitRoot(oldRoot))) continue;
            this.replaceRoot(oldRoot, newRoot);
        }
    }

    private void replaceRoot(File oldRoot, File newRoot) {
        this.myRoots.remove(oldRoot);
        this.myRoots.add(newRoot);
    }

    private File splitRoot(@NotNull File oldRoot) {
        if (oldRoot == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldRoot", "com/intellij/openapi/vcs/update/GroupByPackages", "splitRoot"));
        }
        List<File> children2 = this.getChildren(oldRoot);
        if (children2.size() == 1) {
            return this.splitRoot(children2.get(0));
        }
        return oldRoot;
    }

    private void process(@NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vcs/update/GroupByPackages", "process"));
        }
        File f = file;
        for (File parent = file.getParentFile(); parent != null; parent = parent.getParentFile()) {
            Collection<File> files = this.myParentToChildrenMap.get(parent);
            if (files == null) {
                files = new HashSet<File>();
                this.myParentToChildrenMap.put(parent, files);
            }
            files.add(f);
            f = parent;
        }
        this.myRoots.add(f);
    }

    @NotNull
    public List<File> getRoots() {
        ArrayList<File> arrayList = new ArrayList<File>(this.myRoots);
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/update/GroupByPackages", "getRoots"));
        }
        return arrayList;
    }

    @NotNull
    public List<File> getChildren(File file) {
        Collection<File> collection = this.myParentToChildrenMap.get(file);
        if (collection == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/update/GroupByPackages", "getChildren"));
            }
            return list;
        }
        ArrayList<File> arrayList = new ArrayList<File>(collection);
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/update/GroupByPackages", "getChildren"));
        }
        return arrayList;
    }
}

