/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.status;

import com.intellij.AppTopics;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManagerAdapter;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.CustomStatusBarWidget;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.impl.status.EditorBasedWidget;
import com.intellij.openapi.wm.impl.status.TextPanel;
import com.intellij.ui.ClickListener;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.LineSeparator;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LineSeparatorPanel
extends EditorBasedWidget
implements StatusBarWidget.Multiframe,
CustomStatusBarWidget {
    @NotNull
    private final TextPanel myComponent;
    private boolean myActionEnabled;

    public LineSeparatorPanel(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/wm/impl/status/LineSeparatorPanel", "<init>"));
        }
        super(project);
        this.myComponent = new TextPanel.ExtraSize(){

            @Override
            protected void paintComponent(@NotNull Graphics g) {
                if (g == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/openapi/wm/impl/status/LineSeparatorPanel$1", "paintComponent"));
                }
                super.paintComponent(g);
                if (LineSeparatorPanel.this.myActionEnabled && this.getText() != null) {
                    Rectangle r = this.getBounds();
                    Insets insets = this.getInsets();
                    Icon arrows = AllIcons.Ide.Statusbar_arrows;
                    arrows.paintIcon(this, g, r.width - insets.right - arrows.getIconWidth() - 2, r.height / 2 - arrows.getIconHeight() / 2);
                }
            }
        };
        new ClickListener(){

            public boolean onClick(@NotNull MouseEvent e, int clickCount) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/wm/impl/status/LineSeparatorPanel$2", "onClick"));
                }
                LineSeparatorPanel.this.update();
                LineSeparatorPanel.this.showPopup(e);
                return true;
            }
        }.installOn((Component)this.myComponent);
        this.myComponent.setBorder(StatusBarWidget.WidgetBorder.WIDE);
    }

    private void update() {
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                String toDoComment;
                VirtualFile file = LineSeparatorPanel.this.getSelectedFile();
                LineSeparatorPanel.this.myActionEnabled = false;
                String lineSeparator = null;
                String toolTipText = null;
                String panelText = null;
                if (file != null) {
                    LineSeparatorPanel.this.myActionEnabled = file.isWritable();
                    lineSeparator = LoadTextUtil.detectLineSeparator(file, true);
                    if (lineSeparator != null) {
                        toolTipText = String.format("Line separator: %s", StringUtil.escapeLineBreak((String)lineSeparator));
                        panelText = LineSeparator.fromString((String)lineSeparator).toString();
                    }
                }
                if (lineSeparator == null) {
                    toolTipText = "No line separator";
                    panelText = "n/a";
                    LineSeparatorPanel.this.myActionEnabled = false;
                }
                LineSeparatorPanel.this.myComponent.resetColor();
                if (LineSeparatorPanel.this.myActionEnabled) {
                    toDoComment = "Click to change";
                    LineSeparatorPanel.this.myComponent.setForeground(UIUtil.getActiveTextColor());
                    LineSeparatorPanel.this.myComponent.setTextAlignment(0.0f);
                } else {
                    toDoComment = "";
                    LineSeparatorPanel.this.myComponent.setForeground(UIUtil.getInactiveTextColor());
                    LineSeparatorPanel.this.myComponent.setTextAlignment(0.5f);
                }
                LineSeparatorPanel.this.myComponent.setToolTipText(String.format("%s%n%s", toolTipText, toDoComment));
                LineSeparatorPanel.this.myComponent.setText(panelText);
                if (LineSeparatorPanel.this.myStatusBar != null) {
                    LineSeparatorPanel.this.myStatusBar.updateWidget(LineSeparatorPanel.this.ID());
                }
            }
        });
    }

    private void showPopup(MouseEvent e) {
        if (!this.myActionEnabled) {
            return;
        }
        DataContext dataContext = this.getContext();
        AnAction group = ActionManager.getInstance().getAction("ChangeLineSeparators");
        if (!(group instanceof ActionGroup)) {
            return;
        }
        ListPopup popup = JBPopupFactory.getInstance().createActionGroupPopup("Line separator", (ActionGroup)group, dataContext, JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, false);
        Dimension dimension = popup.getContent().getPreferredSize();
        Point at = new Point(0, -dimension.height);
        popup.show(new RelativePoint(e.getComponent(), at));
        Disposer.register((Disposable)this, (Disposable)popup);
    }

    @Override
    public void install(@NotNull StatusBar statusBar) {
        if (statusBar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statusBar", "com/intellij/openapi/wm/impl/status/LineSeparatorPanel", "install"));
        }
        super.install(statusBar);
        MessageBusConnection connection = ApplicationManager.getApplication().getMessageBus().connect((Disposable)this);
        connection.subscribe(AppTopics.FILE_DOCUMENT_SYNC, (Object)new FileDocumentManagerAdapter(){

            public void fileContentReloaded(@NotNull VirtualFile file, @NotNull Document document) {
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/wm/impl/status/LineSeparatorPanel$4", "fileContentReloaded"));
                }
                if (document == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/wm/impl/status/LineSeparatorPanel$4", "fileContentReloaded"));
                }
                LineSeparatorPanel.this.update();
            }
        });
    }

    @NotNull
    private DataContext getContext() {
        Editor editor = this.getEditor();
        DataContext parent = DataManager.getInstance().getDataContext((Component)this.myStatusBar);
        DataContext dataContext = SimpleDataContext.getSimpleContext(CommonDataKeys.VIRTUAL_FILE_ARRAY.getName(), new VirtualFile[]{this.getSelectedFile()}, SimpleDataContext.getSimpleContext(CommonDataKeys.PROJECT.getName(), this.getProject(), SimpleDataContext.getSimpleContext(PlatformDataKeys.CONTEXT_COMPONENT.getName(), editor == null ? null : editor.getComponent(), parent)));
        if (dataContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/status/LineSeparatorPanel", "getContext"));
        }
        return dataContext;
    }

    public JComponent getComponent() {
        return this.myComponent;
    }

    public StatusBarWidget copy() {
        return new LineSeparatorPanel(this.getProject());
    }

    @NotNull
    public String ID() {
        if ("LineSeparator" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/impl/status/LineSeparatorPanel", "ID"));
        }
        return "LineSeparator";
    }

    @Nullable
    public StatusBarWidget.WidgetPresentation getPresentation(@NotNull StatusBarWidget.PlatformType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/openapi/wm/impl/status/LineSeparatorPanel", "getPresentation"));
        }
        return null;
    }

    public void selectionChanged(@NotNull FileEditorManagerEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/wm/impl/status/LineSeparatorPanel", "selectionChanged"));
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        this.update();
    }

    public void fileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/openapi/wm/impl/status/LineSeparatorPanel", "fileOpened"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/wm/impl/status/LineSeparatorPanel", "fileOpened"));
        }
        this.update();
    }
}

