/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.ui;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.impl.ModuleLibraryTable;
import com.intellij.openapi.roots.impl.libraries.LibraryImpl;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablePresentation;
import com.intellij.packaging.ui.ArtifactEditorContext;
import com.intellij.packaging.ui.PackagingElementPresentation;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.PlatformIcons;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LibraryElementPresentation
extends PackagingElementPresentation {
    private final String myLevel;
    private final String myModuleName;
    private final Library myLibrary;
    private final String myLibraryName;
    private final ArtifactEditorContext myContext;

    public LibraryElementPresentation(String libraryName, String level, @Nullable String moduleName, Library library, ArtifactEditorContext context) {
        this.myLevel = level;
        this.myModuleName = moduleName;
        this.myLibrary = library;
        this.myLibraryName = libraryName;
        this.myContext = context;
    }

    public String getPresentableName() {
        return this.myLibraryName;
    }

    public boolean canNavigateToSource() {
        return this.myLibrary != null;
    }

    public void navigateToSource() {
        this.myContext.selectLibrary(this.myLibrary);
    }

    public void render(@NotNull PresentationData presentationData, SimpleTextAttributes mainAttributes, SimpleTextAttributes commentAttributes) {
        if (presentationData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentationData", "com/intellij/packaging/impl/ui/LibraryElementPresentation", "render"));
        }
        if (this.myLibrary != null) {
            presentationData.setIcon(PlatformIcons.LIBRARY_ICON);
            presentationData.addText(this.myLibraryName, mainAttributes);
            presentationData.addText(LibraryElementPresentation.getLibraryTableComment(this.myLibrary), commentAttributes);
        } else {
            presentationData.addText(this.myLibraryName + " (" + (this.myModuleName != null ? "module '" + this.myModuleName + "'" : this.myLevel) + ")", SimpleTextAttributes.ERROR_ATTRIBUTES);
        }
    }

    public int getWeight() {
        return 30;
    }

    public static String getLibraryTableDisplayName(Library library) {
        LibraryTable table = library.getTable();
        LibraryTablePresentation presentation = table != null ? table.getPresentation() : ModuleLibraryTable.MODULE_LIBRARY_TABLE_PRESENTATION;
        return presentation.getDisplayName(false);
    }

    public static String getLibraryTableComment(Library library) {
        String displayName;
        LibraryTable libraryTable = library.getTable();
        if (libraryTable != null) {
            displayName = libraryTable.getPresentation().getDisplayName(false);
        } else {
            Module module = ((LibraryImpl)library).getModule();
            String tableName = LibraryElementPresentation.getLibraryTableDisplayName(library);
            displayName = module != null ? "'" + module.getName() + "' " + tableName : tableName;
        }
        return " (" + displayName + ")";
    }
}

