/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profile.codeInspection.ui;

import com.intellij.codeInspection.ex.Descriptor;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.ScopeToolState;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ToolDescriptors {
    @NotNull
    private final Descriptor myDefaultDescriptor;
    @NotNull
    private final List<Descriptor> myNonDefaultDescriptors;

    private ToolDescriptors(@NotNull Descriptor defaultDescriptor, @NotNull List<Descriptor> nonDefaultDescriptors) {
        if (defaultDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultDescriptor", "com/intellij/profile/codeInspection/ui/ToolDescriptors", "<init>"));
        }
        if (nonDefaultDescriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nonDefaultDescriptors", "com/intellij/profile/codeInspection/ui/ToolDescriptors", "<init>"));
        }
        this.myDefaultDescriptor = defaultDescriptor;
        this.myNonDefaultDescriptors = nonDefaultDescriptors;
    }

    public static ToolDescriptors fromScopeToolState(ScopeToolState state, InspectionProfileImpl profile, Project project) {
        InspectionToolWrapper toolWrapper = state.getTool();
        List<ScopeToolState> nonDefaultTools = profile.getNonDefaultTools(toolWrapper.getShortName(), project);
        ArrayList<Descriptor> descriptors = new ArrayList<Descriptor>(nonDefaultTools.size());
        for (ScopeToolState nonDefaultToolState : nonDefaultTools) {
            descriptors.add(new Descriptor(nonDefaultToolState, profile, project));
        }
        return new ToolDescriptors(new Descriptor(state, profile, project), descriptors);
    }

    @NotNull
    public Descriptor getDefaultDescriptor() {
        Descriptor descriptor = this.myDefaultDescriptor;
        if (descriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/profile/codeInspection/ui/ToolDescriptors", "getDefaultDescriptor"));
        }
        return descriptor;
    }

    @NotNull
    public List<Descriptor> getNonDefaultDescriptors() {
        List<Descriptor> list = this.myNonDefaultDescriptors;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/profile/codeInspection/ui/ToolDescriptors", "getNonDefaultDescriptors"));
        }
        return list;
    }

    @NotNull
    public ScopeToolState getDefaultScopeToolState() {
        ScopeToolState scopeToolState = this.myDefaultDescriptor.getState();
        if (scopeToolState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/profile/codeInspection/ui/ToolDescriptors", "getDefaultScopeToolState"));
        }
        return scopeToolState;
    }
}

