/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.impl.PackageDirectoryCache;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElementFinder;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.impl.file.PsiPackageImpl;
import com.intellij.psi.search.EverythingGlobalScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.NonClasspathDirectoriesScope;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.messages.MessageBusConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class NonClasspathClassFinder
extends PsiElementFinder {
    private static final EverythingGlobalScope ALL_SCOPE = new EverythingGlobalScope();
    protected final Project myProject;
    private volatile PackageDirectoryCache myCache;
    private final PsiManager myManager;
    private final String[] myFileExtensions;

    public NonClasspathClassFinder(Project project, String ... fileExtensions) {
        this.myProject = project;
        this.myManager = PsiManager.getInstance((Project)this.myProject);
        this.myFileExtensions = (String[])ArrayUtil.append((Object[])fileExtensions, (Object)"class");
        MessageBusConnection connection = project.getMessageBus().connect((Disposable)project);
        connection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener.Adapter(){

            public void after(@NotNull List<? extends VFileEvent> events) {
                if (events == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/intellij/psi/NonClasspathClassFinder$1", "after"));
                }
                NonClasspathClassFinder.this.clearCache();
            }
        });
    }

    @NotNull
    protected PackageDirectoryCache getCache(@Nullable GlobalSearchScope scope) {
        PackageDirectoryCache cache = this.myCache;
        if (cache == null) {
            this.myCache = cache = NonClasspathClassFinder.createCache(this.calcClassRoots());
        }
        PackageDirectoryCache packageDirectoryCache = cache;
        if (packageDirectoryCache == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/NonClasspathClassFinder", "getCache"));
        }
        return packageDirectoryCache;
    }

    @NotNull
    protected static PackageDirectoryCache createCache(@NotNull List<VirtualFile> roots) {
        if (roots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "com/intellij/psi/NonClasspathClassFinder", "createCache"));
        }
        MultiMap map = MultiMap.create();
        map.putValues((Object)"", roots);
        PackageDirectoryCache packageDirectoryCache = new PackageDirectoryCache((MultiMap<String, VirtualFile>)map);
        if (packageDirectoryCache == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/NonClasspathClassFinder", "createCache"));
        }
        return packageDirectoryCache;
    }

    public void clearCache() {
        this.myCache = null;
    }

    protected List<VirtualFile> getClassRoots(@Nullable GlobalSearchScope scope) {
        return this.getCache(scope).getDirectoriesByPackageName("");
    }

    public List<VirtualFile> getClassRoots() {
        return this.getClassRoots((GlobalSearchScope)ALL_SCOPE);
    }

    public PsiClass findClass(final @NotNull String qualifiedName, @NotNull GlobalSearchScope scope) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "com/intellij/psi/NonClasspathClassFinder", "findClass"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/NonClasspathClassFinder", "findClass"));
        }
        final Ref result2 = Ref.create();
        this.processDirectories(StringUtil.getPackageName((String)qualifiedName), scope, new Processor<VirtualFile>(){

            public boolean process(VirtualFile dir) {
                PsiClass[] classes;
                PsiFile file;
                VirtualFile virtualFile = NonClasspathClassFinder.findChild(dir, StringUtil.getShortName((String)qualifiedName), NonClasspathClassFinder.this.myFileExtensions);
                PsiFile psiFile = file = virtualFile == null ? null : NonClasspathClassFinder.this.myManager.findFile(virtualFile);
                if (file instanceof PsiClassOwner && (classes = ((PsiClassOwner)file).getClasses()).length == 1) {
                    result2.set((Object)classes[0]);
                    return false;
                }
                return true;
            }
        });
        return (PsiClass)result2.get();
    }

    protected abstract List<VirtualFile> calcClassRoots();

    @NotNull
    public PsiClass[] getClasses(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope) {
        if (psiPackage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiPackage", "com/intellij/psi/NonClasspathClassFinder", "getClasses"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/NonClasspathClassFinder", "getClasses"));
        }
        final ArrayList result2 = ContainerUtil.newArrayList();
        this.processDirectories(psiPackage.getQualifiedName(), scope, new Processor<VirtualFile>(){

            public boolean process(VirtualFile dir) {
                for (VirtualFile file : dir.getChildren()) {
                    PsiFile psi;
                    if (file.isDirectory() || !ArrayUtil.contains((String)file.getExtension(), (String[])NonClasspathClassFinder.this.myFileExtensions) || !((psi = NonClasspathClassFinder.this.myManager.findFile(file)) instanceof PsiClassOwner)) continue;
                    ContainerUtil.addAll((Collection)result2, (Object[])((PsiClassOwner)psi).getClasses());
                }
                return true;
            }
        });
        PsiClass[] psiClassArray = result2.toArray(new PsiClass[result2.size()]);
        if (psiClassArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/NonClasspathClassFinder", "getClasses"));
        }
        return psiClassArray;
    }

    @NotNull
    public Set<String> getClassNames(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope) {
        if (psiPackage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiPackage", "com/intellij/psi/NonClasspathClassFinder", "getClassNames"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/NonClasspathClassFinder", "getClassNames"));
        }
        final HashSet<String> result2 = new HashSet<String>();
        this.processDirectories(psiPackage.getQualifiedName(), scope, new Processor<VirtualFile>(){

            public boolean process(VirtualFile dir) {
                for (VirtualFile file : dir.getChildren()) {
                    if (file.isDirectory() || !ArrayUtil.contains((String)file.getExtension(), (String[])NonClasspathClassFinder.this.myFileExtensions)) continue;
                    result2.add(file.getNameWithoutExtension());
                }
                return true;
            }
        });
        HashSet<String> hashSet = result2;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/NonClasspathClassFinder", "getClassNames"));
        }
        return hashSet;
    }

    public PsiPackage findPackage(@NotNull String qualifiedName) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "com/intellij/psi/NonClasspathClassFinder", "findPackage"));
        }
        CommonProcessors.FindFirstProcessor processor2 = new CommonProcessors.FindFirstProcessor();
        this.processDirectories(qualifiedName, (GlobalSearchScope)ALL_SCOPE, (Processor<VirtualFile>)processor2);
        return processor2.getFoundValue() != null ? this.createPackage(qualifiedName) : null;
    }

    private PsiPackageImpl createPackage(String qualifiedName) {
        return new PsiPackageImpl(this.myManager, qualifiedName);
    }

    public boolean processPackageDirectories(final @NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope, final @NotNull Processor<PsiDirectory> consumer, boolean includeLibrarySources) {
        if (psiPackage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiPackage", "com/intellij/psi/NonClasspathClassFinder", "processPackageDirectories"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/NonClasspathClassFinder", "processPackageDirectories"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/psi/NonClasspathClassFinder", "processPackageDirectories"));
        }
        return this.processDirectories(psiPackage.getQualifiedName(), scope, new Processor<VirtualFile>(){

            public boolean process(VirtualFile dir) {
                PsiDirectory psiDirectory = psiPackage.getManager().findDirectory(dir);
                return psiDirectory == null || consumer.process((Object)psiDirectory);
            }
        });
    }

    private boolean processDirectories(@NotNull String qualifiedName, final @NotNull GlobalSearchScope scope, final @NotNull Processor<VirtualFile> processor2) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "com/intellij/psi/NonClasspathClassFinder", "processDirectories"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/NonClasspathClassFinder", "processDirectories"));
        }
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/NonClasspathClassFinder", "processDirectories"));
        }
        return ContainerUtil.process(this.getCache(scope).getDirectoriesByPackageName(qualifiedName), (Processor)new Processor<VirtualFile>(){

            public boolean process(VirtualFile file) {
                return !scope.contains(file) || processor2.process((Object)file);
            }
        });
    }

    @NotNull
    public PsiPackage[] getSubPackages(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope) {
        if (psiPackage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiPackage", "com/intellij/psi/NonClasspathClassFinder", "getSubPackages"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/NonClasspathClassFinder", "getSubPackages"));
        }
        String pkgName = psiPackage.getQualifiedName();
        Set<String> names = this.getCache(scope).getSubpackageNames(pkgName);
        if (names.isEmpty()) {
            PsiPackage[] psiPackageArray = super.getSubPackages(psiPackage, scope);
            if (psiPackageArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/NonClasspathClassFinder", "getSubPackages"));
            }
            return psiPackageArray;
        }
        ArrayList<PsiPackageImpl> result2 = new ArrayList<PsiPackageImpl>();
        for (String name : names) {
            result2.add(this.createPackage(pkgName.isEmpty() ? name : pkgName + "." + name));
        }
        PsiPackage[] psiPackageArray = result2.toArray(new PsiPackage[result2.size()]);
        if (psiPackageArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/NonClasspathClassFinder", "getSubPackages"));
        }
        return psiPackageArray;
    }

    @NotNull
    public PsiClass[] findClasses(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope) {
        PsiClass[] psiClassArray;
        if (qualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "com/intellij/psi/NonClasspathClassFinder", "findClasses"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/NonClasspathClassFinder", "findClasses"));
        }
        PsiClass psiClass = this.findClass(qualifiedName, scope);
        if (psiClass == null) {
            psiClassArray = PsiClass.EMPTY_ARRAY;
        } else {
            PsiClass[] psiClassArray2 = new PsiClass[1];
            psiClassArray = psiClassArray2;
            psiClassArray2[0] = psiClass;
        }
        if (psiClassArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/NonClasspathClassFinder", "findClasses"));
        }
        return psiClassArray;
    }

    @NotNull
    public static GlobalSearchScope addNonClasspathScope(@NotNull Project project, @NotNull GlobalSearchScope base) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/NonClasspathClassFinder", "addNonClasspathScope"));
        }
        if (base == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "base", "com/intellij/psi/NonClasspathClassFinder", "addNonClasspathScope"));
        }
        GlobalSearchScope scope = base;
        for (PsiElementFinder finder : (PsiElementFinder[])Extensions.getExtensions((ExtensionPointName)EP_NAME, (AreaInstance)project)) {
            if (!(finder instanceof NonClasspathClassFinder)) continue;
            scope = scope.uniteWith(NonClasspathDirectoriesScope.compose(((NonClasspathClassFinder)finder).getClassRoots()));
        }
        GlobalSearchScope globalSearchScope = scope;
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/NonClasspathClassFinder", "addNonClasspathScope"));
        }
        return globalSearchScope;
    }

    public PsiManager getPsiManager() {
        return this.myManager;
    }

    @Nullable
    private static VirtualFile findChild(@NotNull VirtualFile root, @NotNull String relPath, @NotNull String[] extensions) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/psi/NonClasspathClassFinder", "findChild"));
        }
        if (relPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "relPath", "com/intellij/psi/NonClasspathClassFinder", "findChild"));
        }
        if (extensions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extensions", "com/intellij/psi/NonClasspathClassFinder", "findChild"));
        }
        VirtualFile file = null;
        for (String extension : extensions) {
            file = root.findChild(relPath + '.' + extension);
            if (file != null) break;
        }
        return file;
    }
}

