/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.DefaultFileTypeSpecificInputFilter;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.FileContentImpl;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.PsiDependentIndex;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class JavaFunctionalExpressionIndex
extends FileBasedIndexExtension<String, Collection<IndexHolder>>
implements PsiDependentIndex {
    public static final ID<String, Collection<IndexHolder>> JAVA_FUNCTIONAL_EXPRESSION_INDEX_ID = ID.create((String)"java.functional.expression");
    private static final String THIS_REF_NAME = "this";
    private static final String SUPER_REF_NAME = "super";

    @NotNull
    public ID<String, Collection<IndexHolder>> getName() {
        ID<String, Collection<IndexHolder>> iD = JAVA_FUNCTIONAL_EXPRESSION_INDEX_ID;
        if (iD == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/search/JavaFunctionalExpressionIndex", "getName"));
        }
        return iD;
    }

    @NotNull
    public DataIndexer<String, Collection<IndexHolder>, FileContent> getIndexer() {
        DataIndexer<String, Collection<IndexHolder>, FileContent> dataIndexer = new DataIndexer<String, Collection<IndexHolder>, FileContent>(){

            @NotNull
            public Map<String, Collection<IndexHolder>> map(@NotNull FileContent inputData) {
                if (inputData == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inputData", "com/intellij/psi/impl/search/JavaFunctionalExpressionIndex$1", "map"));
                }
                if (!JavaStubElementTypes.JAVA_FILE.shouldBuildStubFor(inputData.getFile())) {
                    Map<String, Collection<IndexHolder>> map = Collections.emptyMap();
                    if (map == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/search/JavaFunctionalExpressionIndex$1", "map"));
                    }
                    return map;
                }
                CharSequence contentAsText = inputData.getContentAsText();
                if (!StringUtil.contains((CharSequence)contentAsText, (CharSequence)"::") && !StringUtil.contains((CharSequence)contentAsText, (CharSequence)"->")) {
                    Map<String, Collection<IndexHolder>> map = Collections.emptyMap();
                    if (map == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/search/JavaFunctionalExpressionIndex$1", "map"));
                    }
                    return map;
                }
                PsiFile file = ((FileContentImpl)inputData).getPsiFileForPsiDependentIndex();
                if (!(file instanceof PsiJavaFile)) {
                    Map<String, Collection<IndexHolder>> map = Collections.emptyMap();
                    if (map == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/search/JavaFunctionalExpressionIndex$1", "map"));
                    }
                    return map;
                }
                HashMap methodsMap = ContainerUtil.newHashMap();
                for (PsiFunctionalExpression expression : ((SyntaxTraverser)SyntaxTraverser.psiTraverser().withRoot((Object)file)).filter(PsiFunctionalExpression.class)) {
                    String shortEnumName;
                    PsiClass containingClass;
                    PsiExpressionList expressionList = (PsiExpressionList)PsiTreeUtil.getParentOfType((PsiElement)expression, PsiExpressionList.class, (boolean)true, (Class[])new Class[]{PsiStatement.class, PsiModifierListOwner.class});
                    if (expressionList == null) continue;
                    PsiElement parent = expressionList.getParent();
                    String methodName = null;
                    if (parent instanceof PsiMethodCallExpression) {
                        boolean thisRef;
                        methodName = ((PsiMethodCallExpression)parent).getMethodExpression().getReferenceName();
                        if (methodName != null && ((thisRef = methodName.equals(JavaFunctionalExpressionIndex.THIS_REF_NAME)) || methodName.equals(JavaFunctionalExpressionIndex.SUPER_REF_NAME))) {
                            methodName = null;
                            PsiClass containingClass2 = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)parent, PsiClass.class);
                            if (containingClass2 != null) {
                                if (thisRef) {
                                    methodName = containingClass2.getName();
                                } else {
                                    PsiJavaCodeReferenceElement[] referenceElements;
                                    PsiReferenceList extendsList = containingClass2.getExtendsList();
                                    if (extendsList != null && (referenceElements = extendsList.getReferenceElements()).length > 0) {
                                        methodName = referenceElements[0].getReferenceName();
                                    }
                                }
                            }
                        }
                    } else if (parent instanceof PsiNewExpression) {
                        PsiJavaCodeReferenceElement classReference = ((PsiNewExpression)parent).getClassOrAnonymousClassReference();
                        if (classReference != null) {
                            methodName = classReference.getReferenceName();
                        }
                    } else if (parent instanceof PsiEnumConstant && (containingClass = ((PsiEnumConstant)parent).getContainingClass()) != null && (shortEnumName = containingClass.getName()) != null) {
                        methodName = shortEnumName;
                    }
                    if (methodName == null) continue;
                    HashSet<IndexHolder> holders = (HashSet<IndexHolder>)methodsMap.get(methodName);
                    if (holders == null) {
                        holders = new HashSet<IndexHolder>();
                        methodsMap.put(methodName, holders);
                    }
                    holders.add(new IndexHolder(expression instanceof PsiLambdaExpression ? ((PsiLambdaExpression)expression).getParameterList().getParametersCount() : -1, expressionList.getExpressions().length, LambdaUtil.getLambdaIdx((PsiExpressionList)expressionList, (PsiElement)expression)));
                }
                HashMap hashMap = methodsMap;
                if (hashMap == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/search/JavaFunctionalExpressionIndex$1", "map"));
                }
                return hashMap;
            }
        };
        if (dataIndexer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/search/JavaFunctionalExpressionIndex", "getIndexer"));
        }
        return dataIndexer;
    }

    @NotNull
    public KeyDescriptor<String> getKeyDescriptor() {
        EnumeratorStringDescriptor enumeratorStringDescriptor = EnumeratorStringDescriptor.INSTANCE;
        if (enumeratorStringDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/search/JavaFunctionalExpressionIndex", "getKeyDescriptor"));
        }
        return enumeratorStringDescriptor;
    }

    @NotNull
    public DataExternalizer<Collection<IndexHolder>> getValueExternalizer() {
        DataExternalizer<Collection<IndexHolder>> dataExternalizer = new DataExternalizer<Collection<IndexHolder>>(){

            public void save(@NotNull DataOutput out, Collection<IndexHolder> holders) throws IOException {
                if (out == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "com/intellij/psi/impl/search/JavaFunctionalExpressionIndex$2", "save"));
                }
                DataInputOutputUtil.writeINT((DataOutput)out, (int)holders.size());
                for (IndexHolder holder : holders) {
                    DataInputOutputUtil.writeINT((DataOutput)out, (int)holder.getLambdaParamsNumber());
                    DataInputOutputUtil.writeINT((DataOutput)out, (int)holder.getMethodArgsLength());
                    DataInputOutputUtil.writeINT((DataOutput)out, (int)holder.getFunctionExpressionIndex());
                }
            }

            public Collection<IndexHolder> read(@NotNull DataInput in) throws IOException {
                if (in == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "in", "com/intellij/psi/impl/search/JavaFunctionalExpressionIndex$2", "read"));
                }
                int l = DataInputOutputUtil.readINT((DataInput)in);
                HashSet<IndexHolder> holders = new HashSet<IndexHolder>(l);
                while (l-- > 0) {
                    holders.add(new IndexHolder(DataInputOutputUtil.readINT((DataInput)in), DataInputOutputUtil.readINT((DataInput)in), DataInputOutputUtil.readINT((DataInput)in)));
                }
                return holders;
            }
        };
        if (dataExternalizer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/search/JavaFunctionalExpressionIndex", "getValueExternalizer"));
        }
        return dataExternalizer;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        DefaultFileTypeSpecificInputFilter defaultFileTypeSpecificInputFilter = new DefaultFileTypeSpecificInputFilter(new FileType[]{JavaFileType.INSTANCE});
        if (defaultFileTypeSpecificInputFilter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/search/JavaFunctionalExpressionIndex", "getInputFilter"));
        }
        return defaultFileTypeSpecificInputFilter;
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    public int getVersion() {
        return 0;
    }

    public static class IndexHolder {
        private final int myLambdaParamsNumber;
        private final int myMethodArgsLength;
        private final int myFunctionExpressionIndex;

        public IndexHolder(int lambdaParamsNumber, int methodArgsLength, int functionExpressionIndex) {
            this.myLambdaParamsNumber = lambdaParamsNumber;
            this.myMethodArgsLength = methodArgsLength;
            this.myFunctionExpressionIndex = functionExpressionIndex;
        }

        public int getLambdaParamsNumber() {
            return this.myLambdaParamsNumber;
        }

        public int getMethodArgsLength() {
            return this.myMethodArgsLength;
        }

        public int getFunctionExpressionIndex() {
            return this.myFunctionExpressionIndex;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            IndexHolder holder = (IndexHolder)o;
            if (this.myLambdaParamsNumber != holder.myLambdaParamsNumber) {
                return false;
            }
            if (this.myMethodArgsLength != holder.myMethodArgsLength) {
                return false;
            }
            return this.myFunctionExpressionIndex == holder.myFunctionExpressionIndex;
        }

        public int hashCode() {
            int result2 = this.myLambdaParamsNumber;
            result2 = 31 * result2 + this.myMethodArgsLength;
            result2 = 31 * result2 + this.myFunctionExpressionIndex;
            return result2;
        }
    }
}

