/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.util.PsiMatcherExpression;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.NotNull;

public class PsiMatchers {
    private PsiMatchers() {
    }

    @NotNull
    public static PsiMatcherExpression hasName(final @NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/util/PsiMatchers", "hasName"));
        }
        PsiMatcherExpression psiMatcherExpression = new PsiMatcherExpression(){

            @Override
            public Boolean match(PsiElement element) {
                if (element instanceof PsiNamedElement && name.equals(((PsiNamedElement)element).getName())) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
        };
        if (psiMatcherExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/util/PsiMatchers", "hasName"));
        }
        return psiMatcherExpression;
    }

    @NotNull
    public static PsiMatcherExpression hasText(final @NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/psi/util/PsiMatchers", "hasText"));
        }
        PsiMatcherExpression psiMatcherExpression = new PsiMatcherExpression(){

            @Override
            public Boolean match(PsiElement element) {
                if (element.getTextLength() != text.length()) {
                    return Boolean.FALSE;
                }
                return text.equals(element.getText());
            }
        };
        if (psiMatcherExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/util/PsiMatchers", "hasText"));
        }
        return psiMatcherExpression;
    }

    @NotNull
    public static PsiMatcherExpression hasText(final String ... texts) {
        if (texts == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "texts", "com/intellij/psi/util/PsiMatchers", "hasText"));
        }
        PsiMatcherExpression psiMatcherExpression = new PsiMatcherExpression(){

            @Override
            public Boolean match(PsiElement element) {
                String text = element.getText();
                return ArrayUtil.find((Object[])texts, (Object)text) != -1;
            }
        };
        if (psiMatcherExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/util/PsiMatchers", "hasText"));
        }
        return psiMatcherExpression;
    }

    @NotNull
    public static PsiMatcherExpression hasClass(final @NotNull Class<?> aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/psi/util/PsiMatchers", "hasClass"));
        }
        PsiMatcherExpression psiMatcherExpression = new PsiMatcherExpression(){

            @Override
            public Boolean match(PsiElement element) {
                if (aClass.isAssignableFrom(element.getClass())) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
        };
        if (psiMatcherExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/util/PsiMatchers", "hasClass"));
        }
        return psiMatcherExpression;
    }

    @NotNull
    public static PsiMatcherExpression hasClass(final Class ... classes) {
        if (classes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classes", "com/intellij/psi/util/PsiMatchers", "hasClass"));
        }
        PsiMatcherExpression psiMatcherExpression = new PsiMatcherExpression(){

            @Override
            public Boolean match(PsiElement element) {
                for (Class aClass : classes) {
                    if (!aClass.isAssignableFrom(element.getClass())) continue;
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
        };
        if (psiMatcherExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/util/PsiMatchers", "hasClass"));
        }
        return psiMatcherExpression;
    }
}

