/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util.proximity;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.ProximityLocation;
import com.intellij.psi.util.proximity.ProximityWeigher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReferenceListWeigher
extends ProximityWeigher {
    private static final PsiElementPattern.Capture<PsiElement> INSIDE_REFERENCE_LIST = (PsiElementPattern.Capture)PlatformPatterns.psiElement().withParents(new Class[]{PsiJavaCodeReferenceElement.class, PsiReferenceList.class});

    @Nullable
    protected Preference getPreferredCondition(@NotNull ProximityLocation location) {
        if (location == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "com/intellij/psi/util/proximity/ReferenceListWeigher", "getPreferredCondition"));
        }
        PsiElement position = location.getPosition();
        if (INSIDE_REFERENCE_LIST.accepts((Object)position)) {
            PsiReferenceList.Role role;
            assert (position != null);
            PsiReferenceList list = (PsiReferenceList)position.getParent().getParent();
            if (ReferenceListWeigher.shouldContainInterfaces(list, role = list.getRole())) {
                return Preference.Interfaces;
            }
            if (role == PsiReferenceList.Role.EXTENDS_LIST) {
                return Preference.Classes;
            }
            if (role == PsiReferenceList.Role.THROWS_LIST) {
                return Preference.Exceptions;
            }
        }
        return null;
    }

    private static boolean shouldContainInterfaces(PsiReferenceList list, PsiReferenceList.Role role) {
        if (role == PsiReferenceList.Role.EXTENDS_LIST) {
            PsiElement parent = list.getParent();
            return parent instanceof PsiClass && ((PsiClass)parent).isInterface();
        }
        return role == PsiReferenceList.Role.IMPLEMENTS_LIST;
    }

    @Override
    public Integer weigh(@NotNull PsiElement element, @NotNull ProximityLocation location) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/util/proximity/ReferenceListWeigher", "weigh"));
        }
        if (location == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "com/intellij/psi/util/proximity/ReferenceListWeigher", "weigh"));
        }
        if (element instanceof PsiClass) {
            Preference condition = this.getPreferredCondition(location);
            PsiClass aClass = (PsiClass)element;
            if (condition == Preference.Interfaces) {
                return aClass.isInterface() ? 1 : -1;
            }
            if (condition == Preference.Classes) {
                VirtualFile vFile;
                if (aClass.isInterface()) {
                    return -1;
                }
                if (aClass.getName().endsWith("TestCase") && (vFile = aClass.getContainingFile().getVirtualFile()) != null && ProjectFileIndex.SERVICE.getInstance((Project)location.getProject()).isInTestSourceContent(vFile)) {
                    return 2;
                }
                return 1;
            }
            if (condition == Preference.Exceptions) {
                return InheritanceUtil.isInheritor((PsiClass)aClass, (String)"java.lang.Throwable") ? 1 : -1;
            }
        }
        return 0;
    }

    protected static enum Preference {
        Interfaces,
        Classes,
        Exceptions;

    }
}

