/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractMethod;

import com.intellij.refactoring.extractMethod.AbstractVariableData;
import com.intellij.refactoring.extractMethod.ExtractMethodValidator;
import com.intellij.ui.TableUtil;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.table.JBTable;
import com.intellij.util.ui.EditableModel;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.DefaultCellEditor;
import javax.swing.InputMap;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;

public abstract class AbstractParameterTablePanel
extends JPanel {
    private AbstractVariableData[] myVariableData;
    private JBTable myTable;
    private MyTableModel myTableModel;
    private final ExtractMethodValidator myValidator;

    protected abstract void updateSignature();

    protected abstract void doEnterAction();

    protected abstract void doCancelAction();

    public void setVariableData(AbstractVariableData[] variableData) {
        this.myVariableData = variableData;
    }

    public AbstractParameterTablePanel(ExtractMethodValidator validator) {
        super(new BorderLayout());
        this.myValidator = validator;
    }

    public void init() {
        this.myTableModel = new MyTableModel();
        this.myTable = new JBTable((TableModel)this.myTableModel);
        DefaultCellEditor defaultEditor = (DefaultCellEditor)this.myTable.getDefaultEditor(Object.class);
        defaultEditor.setClickCountToStart(1);
        this.myTable.setTableHeader(null);
        this.myTable.getSelectionModel().setSelectionMode(0);
        TableUtil.setupCheckboxColumn((JTable)this.myTable, (int)0);
        this.myTable.getColumnModel().getColumn(1).setCellRenderer(new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                AbstractVariableData data = AbstractParameterTablePanel.this.myVariableData[row];
                this.setText(data.name);
                return this;
            }
        });
        this.myTable.setPreferredScrollableViewportSize(new Dimension(250, this.myTable.getRowHeight() * 5));
        this.myTable.setShowGrid(false);
        this.myTable.setIntercellSpacing((Dimension)JBUI.emptySize());
        InputMap inputMap = this.myTable.getInputMap();
        inputMap.put(KeyStroke.getKeyStroke(32, 0), "enable_disable");
        ActionMap actionMap = this.myTable.getActionMap();
        actionMap.put("enable_disable", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AbstractParameterTablePanel.this.myTable.isEditing()) {
                    return;
                }
                int[] rows = AbstractParameterTablePanel.this.myTable.getSelectedRows();
                if (rows.length > 0) {
                    boolean valueToBeSet = false;
                    for (int row : rows) {
                        if (((AbstractParameterTablePanel)AbstractParameterTablePanel.this).myVariableData[row].passAsParameter) continue;
                        valueToBeSet = true;
                        break;
                    }
                    for (int row : rows) {
                        ((AbstractParameterTablePanel)AbstractParameterTablePanel.this).myVariableData[row].passAsParameter = valueToBeSet;
                    }
                    AbstractParameterTablePanel.this.myTableModel.fireTableRowsUpdated(rows[0], rows[rows.length - 1]);
                    TableUtil.selectRows((JTable)AbstractParameterTablePanel.this.myTable, (int[])rows);
                }
            }
        });
        inputMap.put(KeyStroke.getKeyStroke(113, 0), "edit_parameter_name");
        actionMap.put("edit_parameter_name", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row;
                if (!AbstractParameterTablePanel.this.myTable.isEditing() && (row = AbstractParameterTablePanel.this.myTable.getSelectedRow()) >= 0 && row < AbstractParameterTablePanel.this.myTableModel.getRowCount()) {
                    TableUtil.editCellAt((JTable)AbstractParameterTablePanel.this.myTable, (int)row, (int)1);
                }
            }
        });
        JPanel listPanel = ToolbarDecorator.createDecorator((JTable)this.myTable).disableAddAction().disableRemoveAction().createPanel();
        this.add((Component)listPanel, "Center");
        if (this.myVariableData.length > 1) {
            this.myTable.getSelectionModel().setSelectionInterval(0, 0);
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.myTable.setEnabled(enabled);
        super.setEnabled(enabled);
    }

    public AbstractVariableData[] getVariableData() {
        return this.myVariableData;
    }

    private class MyTableModel
    extends AbstractTableModel
    implements EditableModel {
        public static final int CHECKMARK_COLUMN = 0;
        public static final int PARAMETER_NAME_COLUMN = 1;

        private MyTableModel() {
        }

        @Override
        public int getRowCount() {
            return AbstractParameterTablePanel.this.myVariableData.length;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return ((AbstractParameterTablePanel)AbstractParameterTablePanel.this).myVariableData[rowIndex].passAsParameter;
                }
                case 1: {
                    return ((AbstractParameterTablePanel)AbstractParameterTablePanel.this).myVariableData[rowIndex].name;
                }
            }
            assert (false);
            return null;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    ((AbstractParameterTablePanel)AbstractParameterTablePanel.this).myVariableData[rowIndex].passAsParameter = (Boolean)aValue;
                    this.fireTableRowsUpdated(rowIndex, rowIndex);
                    AbstractParameterTablePanel.this.myTable.getSelectionModel().setSelectionInterval(rowIndex, rowIndex);
                    AbstractParameterTablePanel.this.updateSignature();
                    break;
                }
                case 1: {
                    AbstractVariableData data = AbstractParameterTablePanel.this.myVariableData[rowIndex];
                    String name = (String)aValue;
                    if (AbstractParameterTablePanel.this.myValidator.isValidName(name)) {
                        data.name = name;
                    }
                    AbstractParameterTablePanel.this.updateSignature();
                    break;
                }
            }
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return AbstractParameterTablePanel.this.isEnabled();
                }
                case 1: {
                    return AbstractParameterTablePanel.this.isEnabled() && ((AbstractParameterTablePanel)AbstractParameterTablePanel.this).myVariableData[rowIndex].passAsParameter;
                }
            }
            return false;
        }

        public Class getColumnClass(int columnIndex) {
            if (columnIndex == 0) {
                return Boolean.class;
            }
            return super.getColumnClass(columnIndex);
        }

        public void addRow() {
            throw new IllegalAccessError("Not implemented");
        }

        public void removeRow(int index) {
            throw new IllegalAccessError("Not implemented");
        }

        public void exchangeRows(int row, int targetRow) {
            if (row < 0 || row >= AbstractParameterTablePanel.this.getVariableData().length) {
                return;
            }
            if (targetRow < 0 || targetRow >= AbstractParameterTablePanel.this.getVariableData().length) {
                return;
            }
            AbstractVariableData currentItem = AbstractParameterTablePanel.this.getVariableData()[row];
            AbstractParameterTablePanel.this.getVariableData()[row] = AbstractParameterTablePanel.this.getVariableData()[targetRow];
            AbstractParameterTablePanel.this.getVariableData()[targetRow] = currentItem;
            AbstractParameterTablePanel.this.myTableModel.fireTableRowsUpdated(Math.min(targetRow, row), Math.max(targetRow, row));
            AbstractParameterTablePanel.this.myTable.getSelectionModel().setSelectionInterval(targetRow, targetRow);
            AbstractParameterTablePanel.this.updateSignature();
        }

        public boolean canExchangeRows(int row, int targetRow) {
            if (row < 0 || row >= AbstractParameterTablePanel.this.getVariableData().length) {
                return false;
            }
            return targetRow >= 0 && targetRow < AbstractParameterTablePanel.this.getVariableData().length;
        }
    }
}

