/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.inline;

import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.lang.StdLanguages;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.inline.InlineFieldDialog;
import com.intellij.refactoring.inline.JavaInlineActionHandler;
import com.intellij.refactoring.util.CommonRefactoringUtil;

public class InlineConstantFieldHandler
extends JavaInlineActionHandler {
    private static final String REFACTORING_NAME = RefactoringBundle.message((String)"inline.field.title");

    public boolean canInlineElement(PsiElement element) {
        return element instanceof PsiField && StdLanguages.JAVA.equals(element.getLanguage());
    }

    public void inlineElement(Project project, Editor editor, PsiElement element) {
        PsiElement resolve;
        PsiReference reference;
        PsiElement navigationElement = element.getNavigationElement();
        final PsiField field = (PsiField)(navigationElement instanceof PsiField ? navigationElement : element);
        if (!field.hasInitializer()) {
            String message = RefactoringBundle.message((String)"no.initializer.present.for.the.field");
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)REFACTORING_NAME, (String)"refactoring.inlineField");
            return;
        }
        if (field instanceof PsiEnumConstant) {
            String message = REFACTORING_NAME + " is not supported for enum constants";
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)REFACTORING_NAME, (String)"refactoring.inlineField");
            return;
        }
        if (ReferencesSearch.search((PsiElement)field, (SearchScope)ProjectScope.getProjectScope((Project)project), (boolean)false).findFirst() == null) {
            String message = RefactoringBundle.message((String)"field.0.is.never.used", (Object[])new Object[]{field.getName()});
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)REFACTORING_NAME, (String)"refactoring.inlineField");
            return;
        }
        if (!field.hasModifierProperty("final")) {
            final Ref hasWriteUsages = new Ref((Object)false);
            if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable(){

                @Override
                public void run() {
                    ApplicationManager.getApplication().runReadAction(new Runnable(){

                        @Override
                        public void run() {
                            for (PsiReference reference : ReferencesSearch.search((PsiElement)field)) {
                                PsiElement referenceElement = reference.getElement();
                                if (referenceElement instanceof PsiExpression && PsiUtil.isAccessedForReading((PsiExpression)((PsiExpression)referenceElement))) continue;
                                hasWriteUsages.set((Object)true);
                                break;
                            }
                        }
                    });
                }
            }, "Check if inline is possible...", true, project)) {
                return;
            }
            if (((Boolean)hasWriteUsages.get()).booleanValue()) {
                String message = RefactoringBundle.message((String)"0.refactoring.is.supported.only.for.final.fields", (Object[])new Object[]{REFACTORING_NAME});
                CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)REFACTORING_NAME, (String)"refactoring.inlineField");
                return;
            }
        }
        PsiReference psiReference = reference = editor != null ? TargetElementUtil.findReference(editor, editor.getCaretModel().getOffset()) : null;
        if (reference != null && (resolve = reference.resolve()) != null && !field.equals(resolve.getNavigationElement())) {
            reference = null;
        }
        if (!(element instanceof PsiCompiledElement && reference != null || CommonRefactoringUtil.checkReadOnlyStatus((Project)project, (PsiElement)field))) {
            return;
        }
        PsiReferenceExpression refExpression = reference instanceof PsiReferenceExpression ? (PsiReferenceExpression)reference : null;
        InlineFieldDialog dialog = new InlineFieldDialog(project, field, refExpression);
        dialog.show();
    }
}

