/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.invertBoolean;

import com.intellij.codeInsight.CodeInsightServicesUtil;
import com.intellij.codeInsight.daemon.impl.RecursiveCallLineMarkerProvider;
import com.intellij.ide.util.SuperMethodWarningUtil;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.invertBoolean.InvertBooleanDelegate;
import com.intellij.refactoring.invertBoolean.InvertBooleanHandler;
import com.intellij.refactoring.rename.RenameProcessor;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.Query;
import com.intellij.util.containers.HashSet;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class JavaInvertBooleanDelegate
extends InvertBooleanDelegate {
    @Override
    public boolean isVisibleOnElement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/refactoring/invertBoolean/JavaInvertBooleanDelegate", "isVisibleOnElement"));
        }
        return element instanceof PsiVariable || element instanceof PsiMethod;
    }

    @Override
    public boolean isAvailableOnElement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/refactoring/invertBoolean/JavaInvertBooleanDelegate", "isAvailableOnElement"));
        }
        if (element instanceof PsiVariable) {
            return PsiType.BOOLEAN.equals((Object)((PsiVariable)element).getType());
        }
        if (element instanceof PsiMethod) {
            return PsiType.BOOLEAN.equals((Object)((PsiMethod)element).getReturnType());
        }
        return false;
    }

    @Override
    public PsiElement adjustElement(PsiElement element, Project project, Editor editor) {
        if (element instanceof PsiVariable) {
            PsiVariable var = (PsiVariable)element;
            PsiType returnType = var.getType();
            if (!PsiType.BOOLEAN.equals((Object)returnType)) {
                CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"invert.boolean.wrong.type")), (String)InvertBooleanHandler.REFACTORING_NAME, (String)"refactoring.invertBoolean");
                return null;
            }
            if (var instanceof PsiParameter && ((PsiParameter)var).getDeclarationScope() instanceof PsiMethod) {
                PsiMethod method = (PsiMethod)((PsiParameter)var).getDeclarationScope();
                PsiMethod superMethod = SuperMethodWarningUtil.checkSuperMethod(method, RefactoringBundle.message((String)"to.refactor"));
                if (superMethod == null) {
                    return null;
                }
                var = superMethod.getParameterList().getParameters()[method.getParameterList().getParameterIndex((PsiParameter)var)];
            }
            return var;
        }
        if (element instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)element;
            PsiType returnType = method.getReturnType();
            if (!PsiType.BOOLEAN.equals((Object)returnType)) {
                CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"invert.boolean.wrong.type")), (String)InvertBooleanHandler.REFACTORING_NAME, (String)"refactoring.invertBoolean");
                return null;
            }
            return SuperMethodWarningUtil.checkSuperMethod(method, RefactoringBundle.message((String)"to.refactor"));
        }
        return null;
    }

    public void collectRefsToInvert(PsiElement namedElement, Collection<PsiElement> elementsToInvert) {
        Query query = namedElement instanceof PsiMethod ? MethodReferencesSearch.search((PsiMethod)((PsiMethod)namedElement)) : ReferencesSearch.search((PsiElement)namedElement);
        Collection refs = query.findAll();
        for (PsiReference ref : refs) {
            PsiElement element = ref.getElement();
            PsiElement refElement = this.getElementToInvert(namedElement, element);
            if (refElement == null) {
                refElement = JavaInvertBooleanDelegate.getForeignElementToInvert(namedElement, element, (Language)JavaLanguage.INSTANCE);
            }
            if (refElement == null) continue;
            elementsToInvert.add(refElement);
        }
    }

    @Override
    public PsiElement getElementToInvert(PsiElement namedElement, PsiElement element) {
        if (element instanceof PsiReferenceExpression) {
            PsiElement gParent;
            PsiReferenceExpression refExpr = (PsiReferenceExpression)element;
            PsiElement parent = refExpr.getParent();
            if (parent instanceof PsiAssignmentExpression && refExpr.equals(((PsiAssignmentExpression)parent).getLExpression())) {
                return ((PsiAssignmentExpression)parent).getRExpression();
            }
            if (namedElement instanceof PsiParameter && (gParent = refExpr.getParent().getParent()) instanceof PsiMethodCallExpression && !JavaInvertBooleanDelegate.canInvertReferenceElement((PsiElement)((PsiMethodCallExpression)gParent).getMethodExpression(), true)) {
                return null;
            }
            return refExpr;
        }
        return null;
    }

    private static boolean canInvertReferenceElement(PsiElement expression, boolean recursive) {
        PsiExpression qualifierExpression;
        PsiExpression psiExpression = qualifierExpression = expression instanceof PsiReferenceExpression ? ((PsiReferenceExpression)expression).getQualifierExpression() : null;
        if (qualifierExpression == null || !"super".equals(qualifierExpression.getText())) {
            PsiElement parent = expression.getParent();
            if (parent instanceof PsiMethodCallExpression) {
                return !recursive || !RecursiveCallLineMarkerProvider.isRecursiveMethodCall((PsiMethodCallExpression)parent);
            }
            return true;
        }
        return false;
    }

    @Override
    public void replaceWithNegatedExpression(@NotNull PsiElement expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/refactoring/invertBoolean/JavaInvertBooleanDelegate", "replaceWithNegatedExpression"));
        }
        if (!(expression instanceof PsiExpression)) {
            return;
        }
        if (expression.getParent() instanceof PsiMethodCallExpression) {
            expression = expression.getParent();
        }
        while (expression.getParent() instanceof PsiPrefixExpression && ((PsiPrefixExpression)expression.getParent()).getOperationTokenType() == JavaTokenType.EXCL) {
            expression = expression.getParent();
        }
        if (!(expression.getParent() instanceof PsiExpressionStatement)) {
            expression.replace((PsiElement)CodeInsightServicesUtil.invertCondition((PsiExpression)((PsiExpression)expression)));
        }
    }

    @Override
    public void invertElementInitializer(PsiElement element) {
        PsiExpression initializer;
        if (element instanceof PsiField && ((PsiField)element).getInitializer() == null) {
            ((PsiField)element).setInitializer(JavaPsiFacade.getElementFactory((Project)element.getProject()).createExpressionFromText("true", element));
        } else if (element instanceof PsiVariable && (initializer = ((PsiVariable)element).getInitializer()) != null) {
            this.replaceWithNegatedExpression((PsiElement)initializer);
        }
    }

    @Override
    public void collectRefElements(PsiElement element, RenameProcessor renameProcessor, @NotNull String newName, final Collection<PsiElement> elementsToInvert) {
        block10: {
            block9: {
                if (newName == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newName", "com/intellij/refactoring/invertBoolean/JavaInvertBooleanDelegate", "collectRefElements"));
                }
                this.collectRefsToInvert(element, elementsToInvert);
                if (!(element instanceof PsiMethod)) break block9;
                Collection overriders = OverridingMethodsSearch.search((PsiMethod)((PsiMethod)element)).findAll();
                if (renameProcessor != null) {
                    for (Object overrider : overriders) {
                        renameProcessor.addElement((PsiElement)overrider, newName);
                    }
                }
                HashSet allMethods = new HashSet(overriders);
                allMethods.add((PsiMethod)element);
                for (PsiMethod method : allMethods) {
                    method.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

                        public void visitReturnStatement(PsiReturnStatement statement) {
                            PsiExpression returnValue = statement.getReturnValue();
                            if (returnValue != null && PsiType.BOOLEAN.equals((Object)returnValue.getType())) {
                                elementsToInvert.add(returnValue);
                            }
                        }

                        public void visitClass(PsiClass aClass) {
                        }

                        public void visitLambdaExpression(PsiLambdaExpression expression) {
                        }
                    });
                }
                break block10;
            }
            if (!(element instanceof PsiParameter) || !(((PsiParameter)element).getDeclarationScope() instanceof PsiMethod)) break block10;
            PsiMethod method = (PsiMethod)((PsiParameter)element).getDeclarationScope();
            int index = method.getParameterList().getParameterIndex((PsiParameter)element);
            assert (index >= 0);
            Query methodQuery = MethodReferencesSearch.search((PsiMethod)method);
            Collection methodRefs = methodQuery.findAll();
            for (PsiReference ref : methodRefs) {
                PsiExpression[] args;
                PsiReferenceExpression methodExpression;
                PsiElement parent = ref.getElement().getParent();
                if (parent instanceof PsiAnonymousClass) {
                    parent = parent.getParent();
                }
                if (!(parent instanceof PsiCall)) continue;
                PsiCall call = (PsiCall)parent;
                PsiReferenceExpression psiReferenceExpression = methodExpression = call instanceof PsiMethodCallExpression ? ((PsiMethodCallExpression)call).getMethodExpression() : null;
                PsiExpressionList argumentList = call.getArgumentList();
                if (argumentList == null || index >= (args = argumentList.getExpressions()).length || methodExpression != null && !JavaInvertBooleanDelegate.canInvertReferenceElement((PsiElement)methodExpression, args[index] instanceof PsiReferenceExpression && ((PsiReferenceExpression)args[index]).resolve() == element)) continue;
                elementsToInvert.add((PsiElement)args[index]);
            }
            Collection overriders = OverridingMethodsSearch.search((PsiMethod)method).findAll();
            for (PsiMethod overrider : overriders) {
                PsiParameter overriderParameter = overrider.getParameterList().getParameters()[index];
                if (renameProcessor != null) {
                    renameProcessor.addElement((PsiElement)overriderParameter, newName);
                }
                this.collectRefsToInvert((PsiElement)overriderParameter, elementsToInvert);
            }
        }
    }

    @Override
    public void findConflicts(UsageInfo[] usageInfos, MultiMap<PsiElement, String> conflicts) {
        for (UsageInfo info : usageInfos) {
            PsiElement element = info.getElement();
            if (!(element instanceof PsiMethodReferenceExpression)) continue;
            conflicts.putValue((Object)element, (Object)"Method is used in method reference expression");
        }
    }
}

