/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.listeners.impl;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMember;
import com.intellij.refactoring.listeners.JavaRefactoringListenerManager;
import com.intellij.refactoring.listeners.MoveMemberListener;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;

public class JavaRefactoringListenerManagerImpl
extends JavaRefactoringListenerManager {
    private final List<MoveMemberListener> myMoveMemberListeners = ContainerUtil.createLockFreeCopyOnWriteList();

    public void addMoveMembersListener(MoveMemberListener moveMembersListener) {
        this.myMoveMemberListeners.add(moveMembersListener);
    }

    public void removeMoveMembersListener(MoveMemberListener moveMembersListener) {
        this.myMoveMemberListeners.remove(moveMembersListener);
    }

    public void fireMemberMoved(PsiClass sourceClass, PsiMember member) {
        for (MoveMemberListener listener : this.myMoveMemberListeners) {
            listener.memberMoved(sourceClass, member);
        }
    }
}

