/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.makeStatic;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.changeSignature.MethodNodeBase;
import com.intellij.refactoring.changeSignature.inCallers.JavaCallerChooser;
import com.intellij.refactoring.changeSignature.inCallers.JavaMethodNode;
import com.intellij.refactoring.makeStatic.InternalUsageInfo;
import com.intellij.refactoring.makeStatic.MakeStaticUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

abstract class MakeStaticJavaCallerChooser
extends JavaCallerChooser {
    private final Project myProject;

    public MakeStaticJavaCallerChooser(PsiMethod method, Project project, Consumer<Set<PsiMethod>> consumer) {
        super(method, project, "Select Methods To Propagate Static", null, consumer);
        this.myProject = project;
    }

    static PsiMethod isTheLastClassRef(PsiElement element, PsiMethod member) {
        PsiClass gContainingClass;
        PsiClass containingClass;
        PsiMethod containingMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethod.class, (boolean)false);
        if (!(containingMethod == null || containingMethod.hasModifierProperty("static") || containingMethod.isConstructor() || containingMethod.findDeepestSuperMethods().length != 0 || containingMethod.equals(member) || (containingClass = containingMethod.getContainingClass()) == null || (gContainingClass = containingClass.getContainingClass()) != null && !gContainingClass.hasModifierProperty("static"))) {
            InternalUsageInfo[] refsInMember;
            for (InternalUsageInfo info : refsInMember = MakeStaticUtil.findClassRefsInMember((PsiTypeParameterListOwner)containingMethod, true)) {
                PsiElement referencedElement = info.getReferencedElement();
                if (member.equals(referencedElement) || containingMethod.equals(referencedElement)) continue;
                return null;
            }
            return containingMethod;
        }
        return null;
    }

    protected abstract ArrayList<UsageInfo> getTopLevelItems();

    @Override
    protected JavaMethodNode createTreeNode(PsiMethod nodeMethod, HashSet<PsiMethod> called, Runnable cancelCallback) {
        MakeStaticJavaMethodNode node = new MakeStaticJavaMethodNode(nodeMethod, (java.util.HashSet<PsiMethod>)called, cancelCallback, nodeMethod != null ? nodeMethod.getProject() : this.myProject);
        if (((PsiMethod)this.getTopMethod()).equals(nodeMethod)) {
            node.setEnabled(false);
            node.setChecked(true);
        }
        return node;
    }

    private class MakeStaticJavaMethodNode
    extends JavaMethodNode {
        public MakeStaticJavaMethodNode(PsiMethod currentMethod, java.util.HashSet<PsiMethod> called, Runnable cancelCallback, Project project) {
            super(currentMethod, (Set<PsiMethod>)called, project, cancelCallback);
        }

        @Override
        protected List<PsiMethod> computeCallers() {
            if (((PsiMethod)MakeStaticJavaCallerChooser.this.getTopMethod()).equals(this.getMethod())) {
                ArrayList<UsageInfo> items = MakeStaticJavaCallerChooser.this.getTopLevelItems();
                return ContainerUtil.map(items, (Function)new Function<UsageInfo, PsiMethod>(){

                    public PsiMethod fun(UsageInfo info) {
                        return (PsiMethod)info.getElement();
                    }
                });
            }
            return super.computeCallers();
        }

        @Override
        protected MethodNodeBase<PsiMethod> createNode(PsiMethod caller, java.util.HashSet<PsiMethod> called) {
            return new MakeStaticJavaMethodNode(caller, called, this.myCancelCallback, this.myProject);
        }

        @Override
        protected Condition<PsiMethod> getFilter() {
            return new Condition<PsiMethod>(){

                public boolean value(PsiMethod method) {
                    return !((PsiMethod)MakeStaticJavaMethodNode.this.myMethod).equals(method) && MakeStaticJavaCallerChooser.isTheLastClassRef((PsiElement)method, (PsiMethod)MakeStaticJavaMethodNode.this.myMethod) != null;
                }
            };
        }
    }
}

