/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.tempWithQuery;

import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.extractMethod.ExtractMethodHandler;
import com.intellij.refactoring.extractMethod.ExtractMethodProcessor;
import com.intellij.refactoring.extractMethod.PrepareFailedException;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.duplicates.DuplicatesImpl;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class TempWithQueryHandler
implements RefactoringActionHandler {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.tempWithQuery.TempWithQueryHandler");
    private static final String REFACTORING_NAME = RefactoringBundle.message((String)"replace.temp.with.query.title");

    public void invoke(@NotNull Project project, Editor editor, PsiFile file, DataContext dataContext) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/refactoring/tempWithQuery/TempWithQueryHandler", "invoke"));
        }
        PsiElement element = TargetElementUtil.findTargetElement(editor, 11);
        editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        if (!(element instanceof PsiLocalVariable)) {
            String message = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"error.wrong.caret.position.local.name"));
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)REFACTORING_NAME, (String)"refactoring.replaceTemp");
            return;
        }
        TempWithQueryHandler.invokeOnVariable(file, project, (PsiLocalVariable)element, editor);
    }

    private static void invokeOnVariable(PsiFile file, final Project project, final PsiLocalVariable local, final Editor editor) {
        if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)project, (PsiElement)file)) {
            return;
        }
        String localName = local.getName();
        PsiExpression initializer = local.getInitializer();
        if (initializer == null) {
            String message = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"variable.has.no.initializer", (Object[])new Object[]{localName}));
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)REFACTORING_NAME, (String)"refactoring.replaceTemp");
            return;
        }
        final PsiReference[] refs = (PsiReference[])ReferencesSearch.search((PsiElement)local, (SearchScope)GlobalSearchScope.projectScope((Project)project), (boolean)false).toArray((Object[])new PsiReference[0]);
        if (refs.length == 0) {
            String message = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"variable.is.never.used", (Object[])new Object[]{localName}));
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)REFACTORING_NAME, (String)"refactoring.replaceTemp");
            return;
        }
        final HighlightManager highlightManager = HighlightManager.getInstance((Project)project);
        ArrayList<PsiReference> array = new ArrayList<PsiReference>();
        EditorColorsManager manager = EditorColorsManager.getInstance();
        final TextAttributes attributes = manager.getGlobalScheme().getAttributes(EditorColors.SEARCH_RESULT_ATTRIBUTES);
        for (PsiReference ref : refs) {
            PsiElement refElement = ref.getElement();
            if (PsiUtil.isAccessedForWriting((PsiExpression)((PsiExpression)refElement))) {
                array.add(ref);
            }
            if (array.isEmpty()) continue;
            PsiReference[] refsForWriting = array.toArray(new PsiReference[array.size()]);
            highlightManager.addOccurrenceHighlights(editor, refsForWriting, attributes, true, null);
            String message = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"variable.is.accessed.for.writing", (Object[])new Object[]{localName}));
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)REFACTORING_NAME, (String)"refactoring.replaceTemp");
            WindowManager.getInstance().getStatusBar(project).setInfo(RefactoringBundle.message((String)"press.escape.to.remove.the.highlighting"));
            return;
        }
        final ExtractMethodProcessor processor2 = new ExtractMethodProcessor(project, editor, new PsiElement[]{initializer}, local.getType(), REFACTORING_NAME, localName, "refactoring.replaceTemp");
        try {
            if (!processor2.prepare()) {
                return;
            }
        }
        catch (PrepareFailedException e) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)e.getMessage(), (String)REFACTORING_NAME, (String)"refactoring.replaceTemp");
            ExtractMethodHandler.highlightPrepareError(e, file, editor, project);
            return;
        }
        PsiClass targetClass = processor2.getTargetClass();
        if (targetClass != null && targetClass.isInterface()) {
            String message = RefactoringBundle.message((String)"cannot.replace.temp.with.query.in.interface");
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)REFACTORING_NAME, (String)"refactoring.replaceTemp");
            return;
        }
        if (processor2.showDialog()) {
            CommandProcessor.getInstance().executeCommand(project, new Runnable(){

                @Override
                public void run() {
                    final Runnable action = new Runnable(){

                        @Override
                        public void run() {
                            try {
                                processor2.doRefactoring();
                                local.normalizeDeclaration();
                                PsiExpression initializer = local.getInitializer();
                                PsiExpression[] exprs = new PsiExpression[refs.length];
                                for (int idx = 0; idx < refs.length; ++idx) {
                                    PsiElement ref = refs[idx].getElement();
                                    exprs[idx] = (PsiExpression)ref.replace((PsiElement)initializer);
                                }
                                PsiDeclarationStatement declaration = (PsiDeclarationStatement)local.getParent();
                                declaration.delete();
                                highlightManager.addOccurrenceHighlights(editor, (PsiElement[])exprs, attributes, true, null);
                            }
                            catch (IncorrectOperationException e) {
                                LOG.error((Throwable)e);
                            }
                        }
                    };
                    PostprocessReformattingAspect.getInstance(project).postponeFormattingInside(new Runnable(){

                        @Override
                        public void run() {
                            ApplicationManager.getApplication().runWriteAction(action);
                            DuplicatesImpl.processDuplicates(processor2, project, editor);
                        }
                    });
                }
            }, REFACTORING_NAME, null);
        }
        WindowManager.getInstance().getStatusBar(project).setInfo(RefactoringBundle.message((String)"press.escape.to.remove.the.highlighting"));
    }

    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, DataContext dataContext) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/refactoring/tempWithQuery/TempWithQueryHandler", "invoke"));
        }
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/refactoring/tempWithQuery/TempWithQueryHandler", "invoke"));
        }
        if (elements.length == 1 && elements[0] instanceof PsiLocalVariable && dataContext != null) {
            PsiFile file = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext);
            Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
            if (file != null && editor != null) {
                TempWithQueryHandler.invokeOnVariable(file, project, (PsiLocalVariable)elements[0], editor);
            }
        }
    }
}

