/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.typeMigration.rules;

import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.typeMigration.TypeConversionDescriptorBase;
import com.intellij.refactoring.typeMigration.TypeMigrationLabeler;
import com.intellij.refactoring.typeMigration.rules.TypeConversionRule;

public class RootTypeConversionRule
extends TypeConversionRule {
    @Override
    public TypeConversionDescriptorBase findConversion(PsiType from, PsiType to, PsiMember member, PsiExpression context, TypeMigrationLabeler labeler) {
        PsiClass targetClass;
        if (to instanceof PsiClassType && from instanceof PsiClassType && (targetClass = ((PsiClassType)to).resolve()) != null && member instanceof PsiMethod && member.isPhysical()) {
            PsiMethod method = (PsiMethod)member;
            PsiMethod replacer = targetClass.findMethodBySignature(method, true);
            if (replacer == null) {
                for (PsiMethod superMethod : method.findDeepestSuperMethods()) {
                    replacer = targetClass.findMethodBySignature(superMethod, true);
                    if (replacer == null) continue;
                    method = superMethod;
                    break;
                }
            }
            if (replacer != null && TypeConversionUtil.areTypesConvertible((PsiType)method.getReturnType(), (PsiType)replacer.getReturnType())) {
                PsiElement parent = context.getParent();
                if (context instanceof PsiReferenceExpression && parent instanceof PsiMethodCallExpression) {
                    PsiType evaluatedQualifierType;
                    JavaResolveResult resolveResult = ((PsiReferenceExpression)context).advancedResolve(false);
                    PsiReferenceExpression methodExpression = ((PsiMethodCallExpression)parent).getMethodExpression();
                    PsiExpression qualifier = methodExpression.getQualifierExpression();
                    PsiClass substitutionClass = method.getContainingClass();
                    PsiSubstitutor aSubst = qualifier != null ? ((evaluatedQualifierType = labeler.getTypeEvaluator().evaluateType(qualifier)) instanceof PsiClassType ? ((PsiClassType)evaluatedQualifierType).resolveGenerics().getSubstitutor() : PsiSubstitutor.EMPTY) : TypeConversionUtil.getClassSubstitutor((PsiClass)member.getContainingClass(), (PsiClass)substitutionClass, (PsiSubstitutor)PsiSubstitutor.EMPTY);
                    PsiParameter[] originalParams = ((PsiMethod)member).getParameterList().getParameters();
                    PsiParameter[] migrationParams = replacer.getParameterList().getParameters();
                    PsiExpression[] actualParams = ((PsiMethodCallExpression)parent).getArgumentList().getExpressions();
                    assert (originalParams.length == migrationParams.length);
                    PsiSubstitutor methodTypeParamsSubstitutor = labeler.getTypeEvaluator().createMethodSubstitution(originalParams, actualParams, method, context, aSubst != null ? aSubst : PsiSubstitutor.EMPTY, true);
                    for (int i = 0; i < originalParams.length; ++i) {
                        PsiType migrationType;
                        PsiType originalType = resolveResult.getSubstitutor().substitute(originalParams[i].getType());
                        PsiType type = migrationParams[i].getType();
                        if (InheritanceUtil.isInheritorOrSelf((PsiClass)targetClass, (PsiClass)substitutionClass, (boolean)true)) {
                            PsiSubstitutor superClassSubstitutor = TypeConversionUtil.getClassSubstitutor((PsiClass)substitutionClass, (PsiClass)targetClass, (PsiSubstitutor)PsiSubstitutor.EMPTY);
                            assert (superClassSubstitutor != null);
                            type = superClassSubstitutor.substitute(type);
                        }
                        if (originalType.equals(migrationType = methodTypeParamsSubstitutor.substitute(type)) || TypeConversionUtil.areTypesAssignmentCompatible((PsiType)migrationType, (PsiExpression)actualParams[i])) continue;
                        labeler.migrateExpressionType(actualParams[i], migrationType, (PsiElement)context, false, true);
                    }
                }
                return new TypeConversionDescriptorBase();
            }
        }
        return null;
    }
}

