/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spi.psi;

import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.util.ClassUtil;
import com.intellij.spi.psi.SPIPackageOrClassReferenceElement;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class SPIClassProviderReferenceElement
extends SPIPackageOrClassReferenceElement {
    public SPIClassProviderReferenceElement(ASTNode node) {
        super(node);
    }

    @Override
    @NotNull
    public Object[] getVariants() {
        String name = this.getContainingFile().getName();
        PsiClass superProvider = JavaPsiFacade.getInstance((Project)this.getProject()).findClass(name, this.getResolveScope());
        if (superProvider != null) {
            final ArrayList result2 = new ArrayList();
            ClassInheritorsSearch.search((PsiClass)superProvider).forEach((Processor)new Processor<PsiClass>(){

                public boolean process(PsiClass psiClass) {
                    String jvmClassName;
                    if (!psiClass.hasModifierProperty("abstract") && (jvmClassName = ClassUtil.getJVMClassName((PsiClass)psiClass)) != null) {
                        result2.add(LookupElementBuilder.create((Object)psiClass, (String)jvmClassName));
                    }
                    return true;
                }
            });
            Object[] objectArray = ArrayUtil.toObjectArray(result2);
            if (objectArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spi/psi/SPIClassProviderReferenceElement", "getVariants"));
            }
            return objectArray;
        }
        if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spi/psi/SPIClassProviderReferenceElement", "getVariants"));
        }
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }
}

