/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.concurrency.JobSchedulerImpl;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.ArrayUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.math.BigInteger;

public class Timings {
    private static final int IO_PROBES = 42;
    public static final long CPU_TIMING;
    public static final long IO_TIMING;
    public static final long MACHINE_TIMING;
    public static final long ETALON_TIMING = 438L;
    public static final long ETALON_CPU_TIMING = 200L;
    public static final long ETALON_IO_TIMING = 100L;

    private static long measureCPU() {
        long start = System.currentTimeMillis();
        BigInteger k = new BigInteger("1");
        for (int i = 0; i < 1000000; ++i) {
            k = k.add(new BigInteger("1"));
        }
        return System.currentTimeMillis() - start;
    }

    public static int adjustAccordingToMySpeed(int value, boolean isParallelizable) {
        return Math.max(1, (int)(1.0 * (double)value * 438.0 / (double)MACHINE_TIMING) / 8 * (isParallelizable ? JobSchedulerImpl.CORES_COUNT : 1));
    }

    public static String getStatistics() {
        return " Timings: CPU=" + CPU_TIMING + " (" + (int)((double)CPU_TIMING * 1.0 / 200.0 * 100.0) + "% of the etalon)" + ", I/O=" + IO_TIMING + " (" + (int)((double)IO_TIMING * 1.0 / 100.0 * 100.0) + "% of the etalon)" + ", total=" + MACHINE_TIMING + " (" + (int)((double)MACHINE_TIMING * 1.0 / 438.0 * 100.0) + "% of the etalon) " + Runtime.getRuntime().availableProcessors() + " cores.";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        int N = 20;
        for (int i = 0; i < N; ++i) {
            Timings.measureCPU();
        }
        long[] elapsed = new long[N];
        for (int i = 0; i < N; ++i) {
            elapsed[i] = Timings.measureCPU();
        }
        CPU_TIMING = ArrayUtil.averageAmongMedians((long[])elapsed, (int)2);
        long start = System.currentTimeMillis();
        for (int i = 0; i < 42; ++i) {
            try {
                File tempFile2 = FileUtil.createTempFile((String)"test", (String)("test" + i));
                FileWriter writer = new FileWriter(tempFile2);
                try {
                    for (int j = 0; j < 15; ++j) {
                        writer.write("test" + j);
                        writer.flush();
                    }
                }
                finally {
                    writer.close();
                }
                FileReader reader = new FileReader(tempFile2);
                try {
                    while (reader.read() >= 0) {
                    }
                }
                finally {
                    reader.close();
                }
                if (i == 41) {
                    FileOutputStream stream = new FileOutputStream(tempFile2);
                    try {
                        stream.getFD().sync();
                    }
                    finally {
                        stream.close();
                    }
                }
                if (tempFile2.delete()) continue;
                throw new IOException("Unable to delete: " + tempFile2);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        IO_TIMING = System.currentTimeMillis() - start;
        MACHINE_TIMING = CPU_TIMING + IO_TIMING;
    }
}

