/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationActivationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.AppIconScheme;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.ui.Win7TaskBar;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import org.apache.sanselan.ImageFormat;
import org.apache.sanselan.Sanselan;

public abstract class AppIcon {
    private static final Logger LOG = Logger.getInstance((String)"AppIcon");
    static AppIcon ourMacImpl;
    static AppIcon ourWin7Impl;
    static AppIcon ourEmptyImpl;

    public abstract boolean setProgress(Project var1, Object var2, AppIconScheme.Progress var3, double var4, boolean var6);

    public abstract boolean hideProgress(Project var1, Object var2);

    public abstract void setErrorBadge(Project var1, String var2);

    public abstract void setOkBadge(Project var1, boolean var2);

    public abstract void requestAttention(Project var1, boolean var2);

    public abstract void requestFocus(IdeFrame var1);

    public static AppIcon getInstance() {
        if (ourMacImpl == null) {
            ourMacImpl = new MacAppIcon();
            ourWin7Impl = new Win7AppIcon();
            ourEmptyImpl = new EmptyIcon();
        }
        if (SystemInfo.isMac && SystemInfo.isJavaVersionAtLeast((String)"1.6")) {
            return ourMacImpl;
        }
        if (SystemInfo.isWin7OrNewer) {
            return ourWin7Impl;
        }
        return ourEmptyImpl;
    }

    private static void assertIsDispatchThread() {
        Application app = ApplicationManager.getApplication();
        if (app != null) {
            if (!app.isUnitTestMode()) {
                app.assertIsDispatchThread();
            }
        } else assert (EventQueue.isDispatchThread());
    }

    private static class EmptyIcon
    extends AppIcon {
        private EmptyIcon() {
        }

        @Override
        public boolean setProgress(Project project, Object processId, AppIconScheme.Progress scheme, double value, boolean isOk) {
            return false;
        }

        @Override
        public boolean hideProgress(Project project, Object processId) {
            return false;
        }

        @Override
        public void setErrorBadge(Project project, String text) {
        }

        @Override
        public void setOkBadge(Project project, boolean visible) {
        }

        @Override
        public void requestAttention(Project project, boolean critical) {
        }

        @Override
        public void requestFocus(IdeFrame frame) {
        }
    }

    private static class Win7AppIcon
    extends BaseIcon {
        private static final Color ERROR_COLOR = new Color(197, 54, 13);
        private static Object myOkIcon;

        private Win7AppIcon() {
        }

        @Override
        public boolean _setProgress(IdeFrame frame, Object processId, AppIconScheme.Progress scheme, double value, boolean isOk) {
            this.myCurrentProcessId = processId;
            if (Math.abs(this.myLastValue - value) < 0.02) {
                return true;
            }
            try {
                if (Win7AppIcon.isValid(frame)) {
                    Win7TaskBar.setProgress(frame, value, isOk);
                }
            }
            catch (Throwable e) {
                LOG.error(e);
            }
            this.myLastValue = value;
            this.myCurrentProcessId = null;
            return true;
        }

        @Override
        public boolean _hideProgress(IdeFrame frame, Object processId) {
            if (this.myCurrentProcessId != null && !this.myCurrentProcessId.equals(processId)) {
                return false;
            }
            try {
                if (Win7AppIcon.isValid(frame)) {
                    Win7TaskBar.hideProgress(frame);
                }
            }
            catch (Throwable e) {
                LOG.error(e);
            }
            this.myCurrentProcessId = null;
            this.myLastValue = 0.0;
            return true;
        }

        @Override
        public void _setTextBadge(IdeFrame frame, String text) {
            if (!Win7AppIcon.isValid(frame)) {
                return;
            }
            Object icon = null;
            if (text != null) {
                try {
                    int size = 55;
                    BufferedImage image = UIUtil.createImage((int)size, (int)size, (int)2);
                    Graphics2D g = image.createGraphics();
                    int roundSize = 40;
                    g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    g.setPaint(ERROR_COLOR);
                    g.fillRoundRect(size / 2 - roundSize / 2, size / 2 - roundSize / 2, roundSize, roundSize, size, size);
                    g.setColor(Color.white);
                    Font font = g.getFont();
                    g.setFont(new Font(font.getName(), font.getStyle(), 22));
                    FontMetrics fontMetrics = g.getFontMetrics();
                    int width = fontMetrics.stringWidth(text);
                    g.drawString(text, size / 2 - width / 2, size / 2 - fontMetrics.getHeight() / 2 + fontMetrics.getAscent());
                    ByteArrayOutputStream bytes = new ByteArrayOutputStream();
                    Sanselan.writeImage((BufferedImage)image, (OutputStream)bytes, (ImageFormat)ImageFormat.IMAGE_FORMAT_ICO, new HashMap());
                    icon = Win7TaskBar.createIcon(bytes.toByteArray());
                }
                catch (Throwable e) {
                    LOG.error(e);
                }
            }
            try {
                Win7TaskBar.setOverlayIcon(frame, icon, icon != null);
            }
            catch (Throwable e) {
                LOG.error(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public void _setOkBadge(IdeFrame frame, boolean visible) {
            if (!Win7AppIcon.isValid(frame)) {
                return;
            }
            Object icon = null;
            if (visible) {
                Class<Win7AppIcon> clazz = Win7AppIcon.class;
                // MONITORENTER : com.intellij.ui.AppIcon$Win7AppIcon.class
                if (myOkIcon == null) {
                    try {
                        BufferedImage image = ImageIO.read(this.getClass().getResource("/mac/appIconOk512.png"));
                        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
                        Sanselan.writeImage((BufferedImage)image, (OutputStream)bytes, (ImageFormat)ImageFormat.IMAGE_FORMAT_ICO, new HashMap());
                        myOkIcon = Win7TaskBar.createIcon(bytes.toByteArray());
                    }
                    catch (Throwable e) {
                        LOG.error(e);
                        myOkIcon = null;
                    }
                }
                icon = myOkIcon;
                // MONITOREXIT : clazz
            }
            try {
                Win7TaskBar.setOverlayIcon(frame, icon, false);
                return;
            }
            catch (Throwable e) {
                LOG.error(e);
            }
        }

        @Override
        public void _requestAttention(IdeFrame frame, boolean critical) {
            try {
                if (Win7AppIcon.isValid(frame)) {
                    Win7TaskBar.attention(frame, critical);
                }
            }
            catch (Throwable e) {
                LOG.error(e);
            }
        }

        @Override
        protected IdeFrame getIdeFrame(Project project) {
            return WindowManager.getInstance().getIdeFrame(project);
        }

        @Override
        public void requestFocus(IdeFrame frame) {
        }

        private static boolean isValid(IdeFrame frame) {
            return frame != null && ((Component)frame).isDisplayable();
        }
    }

    private static class MacAppIcon
    extends BaseIcon {
        private static BufferedImage myAppImage;

        private MacAppIcon() {
        }

        private BufferedImage getAppImage() {
            AppIcon.assertIsDispatchThread();
            try {
                if (myAppImage != null) {
                    return myAppImage;
                }
                Object app = this.getApp();
                Image appImage = (Image)this.getAppMethod("getDockIconImage", new Class[0]).invoke(app, new Object[0]);
                if (appImage == null) {
                    return null;
                }
                int width = appImage.getWidth(null);
                int height = appImage.getHeight(null);
                BufferedImage img = UIUtil.createImage((int)width, (int)height, (int)2);
                Graphics2D g2d = img.createGraphics();
                g2d.drawImage(appImage, null, null);
                myAppImage = img;
            }
            catch (NoSuchMethodException e) {
                return null;
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
            return myAppImage;
        }

        @Override
        public void _setTextBadge(IdeFrame frame, String text) {
            AppIcon.assertIsDispatchThread();
            try {
                this.getAppMethod("setDockIconBadge", String.class).invoke(this.getApp(), text);
            }
            catch (NoSuchMethodException e) {
                return;
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }

        @Override
        public void requestFocus(IdeFrame frame) {
            AppIcon.assertIsDispatchThread();
            try {
                this.getAppMethod("requestForeground", Boolean.TYPE).invoke(this.getApp(), true);
            }
            catch (NoSuchMethodException e) {
                return;
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }

        @Override
        public void _requestAttention(IdeFrame frame, boolean critical) {
            AppIcon.assertIsDispatchThread();
            try {
                this.getAppMethod("requestUserAttention", Boolean.TYPE).invoke(this.getApp(), critical);
            }
            catch (NoSuchMethodException e) {
                return;
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }

        @Override
        protected IdeFrame getIdeFrame(Project project) {
            return null;
        }

        @Override
        public boolean _hideProgress(IdeFrame frame, Object processId) {
            AppIcon.assertIsDispatchThread();
            if (this.getAppImage() == null) {
                return false;
            }
            if (this.myCurrentProcessId != null && !this.myCurrentProcessId.equals(processId)) {
                return false;
            }
            this.setDockIcon(this.getAppImage());
            this.myCurrentProcessId = null;
            this.myLastValue = 0.0;
            return true;
        }

        @Override
        public void _setOkBadge(IdeFrame frame, boolean visible) {
            AppIcon.assertIsDispatchThread();
            if (this.getAppImage() == null) {
                return;
            }
            AppImage img = this.createAppImage();
            if (visible) {
                Icon okIcon = AllIcons.Mac.AppIconOk512;
                int x = img.myImg.getWidth() - okIcon.getIconWidth();
                int y = 0;
                okIcon.paintIcon(JOptionPane.getRootFrame(), img.myG2d, x, y);
            }
            this.setDockIcon(img.myImg);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean _setProgress(IdeFrame frame, Object processId, AppIconScheme.Progress scheme, double value, boolean isOk) {
            AppIcon.assertIsDispatchThread();
            if (this.getAppImage() == null) {
                return false;
            }
            this.myCurrentProcessId = processId;
            if (Math.abs(this.myLastValue - value) < 0.02) {
                return true;
            }
            try {
                int progressHeight = (int)((double)myAppImage.getHeight() * 0.13);
                int xInset = (int)((double)myAppImage.getWidth() * 0.05);
                int yInset = (int)((double)myAppImage.getHeight() * 0.15);
                int width = myAppImage.getWidth() - xInset * 2;
                int y = myAppImage.getHeight() - progressHeight - yInset;
                RoundRectangle2D.Double rect = new RoundRectangle2D.Double(xInset, y, width, progressHeight, progressHeight, progressHeight);
                RoundRectangle2D.Double border = new RoundRectangle2D.Double(xInset - 1, y - 1, width + 2, progressHeight + 2, progressHeight + 2, progressHeight + 2);
                RoundRectangle2D.Double progress = new RoundRectangle2D.Double(xInset + 1, y + 1, (double)(width - 2) * value, progressHeight - 1, progressHeight - 2, progressHeight - 1);
                AppImage appImg = this.createAppImage();
                Color brighter = Color.GRAY.brighter().brighter();
                Color backGround = new Color(brighter.getRed(), brighter.getGreen(), brighter.getBlue(), 85);
                appImg.myG2d.setColor(backGround);
                appImg.myG2d.fill(rect);
                Color color = isOk ? scheme.getOkColor() : scheme.getErrorColor();
                Paint paint = UIUtil.getGradientPaint((float)(xInset + 1), (float)(y + 1), (Color)color.brighter(), (float)(xInset + 1), (float)(y + progressHeight - 1), (Color)color.darker().darker());
                appImg.myG2d.setPaint(paint);
                appImg.myG2d.fill(progress);
                appImg.myG2d.setColor(Color.GRAY.darker().darker());
                appImg.myG2d.draw(rect);
                appImg.myG2d.draw(border);
                this.setDockIcon(appImg.myImg);
                this.myLastValue = value;
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
            finally {
                this.myCurrentProcessId = null;
            }
            return true;
        }

        private AppImage createAppImage() {
            BufferedImage current = UIUtil.createImage((int)this.getAppImage().getWidth(), (int)this.getAppImage().getHeight(), (int)2);
            Graphics2D g = current.createGraphics();
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.drawImage(this.getAppImage(), null, null);
            return new AppImage(current, g);
        }

        private void setDockIcon(BufferedImage image) {
            try {
                this.getAppMethod("setDockIconImage", Image.class).invoke(this.getApp(), image);
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }

        private Method getAppMethod(String name, Class ... args) throws NoSuchMethodException, ClassNotFoundException {
            return this.getAppClass().getMethod(name, args);
        }

        private Object getApp() throws NoSuchMethodException, ClassNotFoundException, InvocationTargetException, IllegalAccessException {
            return this.getAppClass().getMethod("getApplication", new Class[0]).invoke(null, new Object[0]);
        }

        private Class<?> getAppClass() throws ClassNotFoundException {
            return Class.forName("com.apple.eawt.Application");
        }

        private class AppImage {
            BufferedImage myImg;
            Graphics2D myG2d;

            AppImage(BufferedImage img, Graphics2D g2d) {
                this.myImg = img;
                this.myG2d = g2d;
            }
        }
    }

    private static abstract class BaseIcon
    extends AppIcon {
        private ApplicationActivationListener myAppListener;
        protected Object myCurrentProcessId;
        protected double myLastValue;

        private BaseIcon() {
        }

        @Override
        public final boolean setProgress(Project project, Object processId, AppIconScheme.Progress scheme, double value, boolean isOk) {
            if (!this.isAppActive() && Registry.is((String)"ide.appIcon.progress") && (this.myCurrentProcessId == null || this.myCurrentProcessId.equals(processId))) {
                return this._setProgress(this.getIdeFrame(project), processId, scheme, value, isOk);
            }
            return false;
        }

        @Override
        public final boolean hideProgress(Project project, Object processId) {
            if (Registry.is((String)"ide.appIcon.progress")) {
                return this._hideProgress(this.getIdeFrame(project), processId);
            }
            return false;
        }

        @Override
        public final void setErrorBadge(Project project, String text) {
            if (!this.isAppActive() && Registry.is((String)"ide.appIcon.badge")) {
                this._setOkBadge(this.getIdeFrame(project), false);
                this._setTextBadge(this.getIdeFrame(project), text);
            }
        }

        @Override
        public final void setOkBadge(Project project, boolean visible) {
            if (!this.isAppActive() && Registry.is((String)"ide.appIcon.badge")) {
                this._setTextBadge(this.getIdeFrame(project), null);
                this._setOkBadge(this.getIdeFrame(project), visible);
            }
        }

        @Override
        public final void requestAttention(Project project, boolean critical) {
            if (!this.isAppActive() && Registry.is((String)"ide.appIcon.requestAttention")) {
                this._requestAttention(this.getIdeFrame(project), critical);
            }
        }

        public abstract boolean _setProgress(IdeFrame var1, Object var2, AppIconScheme.Progress var3, double var4, boolean var6);

        public abstract boolean _hideProgress(IdeFrame var1, Object var2);

        public abstract void _setTextBadge(IdeFrame var1, String var2);

        public abstract void _setOkBadge(IdeFrame var1, boolean var2);

        public abstract void _requestAttention(IdeFrame var1, boolean var2);

        protected abstract IdeFrame getIdeFrame(Project var1);

        private boolean isAppActive() {
            Application app = ApplicationManager.getApplication();
            if (app != null && this.myAppListener == null) {
                this.myAppListener = new ApplicationActivationListener.Adapter(){

                    public void applicationActivated(IdeFrame ideFrame) {
                        BaseIcon.this.hideProgress(ideFrame.getProject(), BaseIcon.this.myCurrentProcessId);
                        BaseIcon.this._setOkBadge(ideFrame, false);
                        BaseIcon.this._setTextBadge(ideFrame, null);
                    }
                };
                app.getMessageBus().connect().subscribe(ApplicationActivationListener.TOPIC, (Object)this.myAppListener);
            }
            return app != null && app.isActive();
        }
    }
}

